/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.evaluator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.m2m.internal.qvt.oml.ast.env.ModelParameterExtent;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalUtil;
import org.eclipse.m2m.internal.qvt.oml.evaluator.ModelInstance;
import org.eclipse.m2m.internal.qvt.oml.evaluator.ModelInstanceImpl;
import org.eclipse.m2m.internal.qvt.oml.evaluator.TransformationInstance;
import org.eclipse.m2m.internal.qvt.oml.expressions.ModelParameter;
import org.eclipse.m2m.internal.qvt.oml.expressions.ModelType;
import org.eclipse.m2m.internal.qvt.oml.expressions.OperationalTransformation;

public class ModelParameterHelper {
    private OperationalTransformation fMainTransformation;
    private List<ModelInstance> fModelArguments;

    public static List<ModelInstance> createModelArguments(OperationalTransformation transformation, List<ModelParameterExtent> modelExtentArgs) {
        if (transformation == null || modelExtentArgs == null) {
            throw new IllegalArgumentException();
        }
        if (modelExtentArgs.size() != transformation.getModelParameter().size()) {
            throw new IllegalArgumentException("Invalid number of transformation arguments");
        }
        ArrayList<ModelInstance> modelArgs = new ArrayList<ModelInstance>(modelExtentArgs.size());
        int pos = 0;
        for (ModelParameterExtent nextExtent : modelExtentArgs) {
            if (nextExtent == null) {
                throw new IllegalArgumentException("null model extent argument");
            }
            ModelParameter modelParam = (ModelParameter)transformation.getModelParameter().get(pos++);
            modelArgs.add(ModelParameterHelper.createModel(modelParam, nextExtent));
        }
        return modelArgs;
    }

    ModelParameterHelper(OperationalTransformation mainTransformation, List<ModelInstance> modelArgs) {
        if (mainTransformation == null || modelArgs == null) {
            throw new IllegalArgumentException();
        }
        if (modelArgs.size() != mainTransformation.getModelParameter().size()) {
            throw new IllegalArgumentException("Invalid number of transformation arguments");
        }
        int pos = 0;
        for (ModelInstance nextModel : modelArgs) {
            if (nextModel == null) {
                throw new IllegalArgumentException("null model argument");
            }
            ModelParameter modelParam = (ModelParameter)mainTransformation.getModelParameter().get(pos++);
            EClassifier modelType = modelParam.getEType();
            if (!nextModel.eClass().isInstance((Object)modelType)) continue;
            throw new IllegalArgumentException("Invalid model for parameter: " + modelParam);
        }
        this.fMainTransformation = mainTransformation;
        this.fModelArguments = new ArrayList<ModelInstance>(modelArgs);
    }

    void initModelParameters(TransformationInstance transformation) {
        ModelInstance actualModel;
        if (transformation == null) {
            throw new IllegalArgumentException();
        }
        boolean isMainTransformation = transformation.getTransformation() == this.fMainTransformation;
        OperationalTransformation transformationType = transformation.getTransformation();
        UniqueEList.FastCompare alreadyBound = new UniqueEList.FastCompare();
        int pos = 0;
        for (ModelParameter modelParam : transformationType.getModelParameter()) {
            ModelInstance passedModel = isMainTransformation ? this.fModelArguments.get(pos) : this.findAvailableStrictlyCompatibleExtent(modelParam, (Collection<ModelInstance>)alreadyBound);
            if (passedModel == null) continue;
            actualModel = passedModel.getModelType() == modelParam.getEType() ? passedModel : ModelParameterHelper.createModel(modelParam, passedModel.getExtent());
            transformation.getAdapter(TransformationInstance.InternalTransformation.class).setModel(modelParam, actualModel);
            ++pos;
        }
        if (isMainTransformation) {
            return;
        }
        for (ModelParameter modelParam : transformationType.getModelParameter()) {
            if (transformation.getModel(modelParam) != null) continue;
            ModelInstance resolvedModel = this.findFirstDirectionCompatibleExtent(modelParam, (Collection<ModelInstance>)alreadyBound);
            actualModel = resolvedModel == null ? ModelParameterHelper.createModel(modelParam, new ModelParameterExtent()) : ModelParameterHelper.createModel(modelParam, resolvedModel.getExtent());
            transformation.getAdapter(TransformationInstance.InternalTransformation.class).setModel(modelParam, actualModel);
        }
    }

    private ModelInstance findFirstDirectionCompatibleExtent(ModelParameter modelParam, Collection<ModelInstance> alreadyBound) {
        int pos = 0;
        for (ModelParameter nextParam : this.fMainTransformation.getModelParameter()) {
            ModelInstance extent;
            if (QvtOperationalUtil.isModelParamEqual(nextParam, modelParam, false) && !alreadyBound.contains(extent = this.fModelArguments.get(pos))) {
                alreadyBound.add(extent);
                return extent;
            }
            ++pos;
        }
        return null;
    }

    private ModelInstance findAvailableStrictlyCompatibleExtent(ModelParameter modelParam, Collection<ModelInstance> alreadyBound) {
        int pos = 0;
        for (ModelParameter nextParam : this.fMainTransformation.getModelParameter()) {
            ModelInstance extent;
            if (QvtOperationalUtil.isModelParamEqual(nextParam, modelParam, true) && !alreadyBound.contains(extent = this.fModelArguments.get(pos))) {
                alreadyBound.add(extent);
                return extent;
            }
            ++pos;
        }
        return null;
    }

    private static ModelInstance createModel(ModelParameter modelParam, ModelParameterExtent extent) {
        assert (modelParam != null);
        assert (extent != null);
        ModelType modelType = (ModelType)modelParam.getEType();
        ModelInstanceImpl model = new ModelInstanceImpl(modelType, extent);
        return model;
    }
}

