/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.xerces;

import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.eclipse.lemminx.services.extensions.diagnostics.DiagnosticsResult;
import org.eclipse.lemminx.uriresolver.CacheResourceDownloadingException;
import org.eclipse.lemminx.uriresolver.CacheResourceException;

public class LSPXMLEntityResolver
implements XMLEntityResolver {
    private final XMLEntityResolver entityResolver;
    private final DiagnosticsResult diagnostics;

    public LSPXMLEntityResolver(XMLEntityResolver entityResolver, DiagnosticsResult diagnostics) {
        this.entityResolver = entityResolver;
        this.diagnostics = diagnostics;
    }

    @Override
    public XMLInputSource resolveEntity(XMLResourceIdentifier resourceIdentifier) throws XNIException, IOException {
        try {
            return this.entityResolver.resolveEntity(resourceIdentifier);
        }
        catch (CacheResourceException e) {
            CompletableFuture<Path> future;
            if (e instanceof CacheResourceDownloadingException && (future = ((CacheResourceDownloadingException)e).getFuture()) != null) {
                this.diagnostics.addFuture(future);
            }
            throw new IOException(e);
        }
    }
}

