/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.io.IOException;
import org.apache.batik.transcoder.TranscoderException;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.DeviceContext;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.GdiPen;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.IEmf2SvgConverter;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.IRenderToPath;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.Record;

public class AngleArc
implements IEmf2SvgConverter,
IRenderToPath {
    private static final int CENTER_OFFSET = 0;
    private static final int RADIUS_OFFSET = 8;
    private static final int START_ANGLE_OFFSET = 12;
    private static final int END_ANGLE_OFFSET = 16;
    private Point m_center = new Point(0, 0);
    private int m_radius = 0;
    private float m_startAngle = 0.0f;
    private float m_sweepAngle = 0.0f;

    @Override
    public void readEMFRecord(Record emr) throws IOException {
        this.m_center = emr.getPointLAt(0);
        this.m_radius = emr.getIntAt(8);
        this.m_startAngle = emr.getFloatAt(12);
        this.m_sweepAngle = emr.getFloatAt(16);
    }

    @Override
    public void render(Graphics2D g, DeviceContext context) throws TranscoderException {
        GdiPen curPen = context.getCurPen();
        if (curPen != null) {
            curPen.apply(g, context);
            Shape shape = this.getShape(context);
            Arc2D.Double arc = (Arc2D.Double)shape;
            Point2D point = arc.getStartPoint();
            g.drawLine(context.convertXToSVGLogicalUnits(context.getCurPosX()), context.convertYToSVGLogicalUnits(context.getCurPosY()), (int)point.getX(), (int)point.getY());
            g.draw(shape);
            point = arc.getEndPoint();
            context.setCurPosX(context.convertXToWindowsLogicalUnits((int)point.getX()));
            context.setCurPosY(context.convertYToWindowsLogicalUnits((int)point.getY()));
        }
    }

    @Override
    public void render(DeviceContext context) throws TranscoderException {
        Shape shape = this.getShape(context);
        GeneralPath p = context.getGdiPath().getCurrentFigure();
        p.append(shape, true);
        Arc2D.Double arc = (Arc2D.Double)shape;
        Point2D point = arc.getEndPoint();
        context.setCurPosX(context.convertXToWindowsLogicalUnits((int)point.getX()));
        context.setCurPosY(context.convertYToWindowsLogicalUnits((int)point.getY()));
    }

    private Shape getShape(DeviceContext context) {
        int centerX = context.convertXToSVGLogicalUnits(this.m_center.x);
        int centerY = context.convertYToSVGLogicalUnits(this.m_center.y);
        int radius = context.scaleX(this.m_radius);
        Rectangle rect = new Rectangle(centerX - radius, centerY - radius, radius * 2, radius * 2);
        Arc2D.Double arc = new Arc2D.Double();
        arc.setArc(rect, this.m_startAngle, this.m_sweepAngle, 0);
        return arc;
    }
}

