/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.core;

import java.security.cert.Certificate;
import java.util.Collection;
import java.util.Collections;
import org.bouncycastle.openpgp.PGPPublicKey;

public abstract class UIServices {
    public static final String SERVICE_NAME = UIServices.class.getName();
    public static final AuthenticationInfo AUTHENTICATION_PROMPT_CANCELED = new AuthenticationInfo("", "", false);

    public abstract AuthenticationInfo getUsernamePassword(String var1);

    public abstract AuthenticationInfo getUsernamePassword(String var1, AuthenticationInfo var2);

    public abstract TrustInfo getTrustInfo(Certificate[][] var1, String[] var2);

    public void showInformationMessage(String title, String text, String linkText) {
        System.out.println(text);
    }

    public TrustInfo getTrustInfo(Certificate[][] unTrustedCertificateChains, Collection<PGPPublicKey> untrustedPGPKeys, String[] unsignedDetail) {
        return this.getTrustInfo(unTrustedCertificateChains, unsignedDetail);
    }

    public static class AuthenticationInfo {
        private final boolean save;
        private final String userName;
        private final String password;

        public AuthenticationInfo(String userName, String password, boolean saveResult) {
            this.userName = userName;
            this.password = password;
            this.save = saveResult;
        }

        public boolean saveResult() {
            return this.save;
        }

        public String getUserName() {
            return this.userName;
        }

        public String getPassword() {
            return this.password;
        }
    }

    public static class TrustInfo {
        private final Certificate[] trustedCertificates;
        private final Collection<PGPPublicKey> trustedPGPKeys;
        private final boolean saveTrustedCertificates;
        private final boolean trustUnsigned;
        private final boolean trustAlways;

        @Deprecated
        public TrustInfo(Certificate[] trusted, boolean save, boolean trustUnsigned) {
            this.trustedCertificates = trusted;
            this.trustedPGPKeys = Collections.emptyList();
            this.saveTrustedCertificates = save;
            this.trustUnsigned = trustUnsigned;
            this.trustAlways = false;
        }

        public TrustInfo(Collection<Certificate> trustedCertificates, Collection<PGPPublicKey> trustedPGPKeys, boolean save, boolean trustUnsigned) {
            this(trustedCertificates, trustedPGPKeys, save, trustUnsigned, false);
        }

        public TrustInfo(Collection<Certificate> trustedCertificates, Collection<PGPPublicKey> trustedPGPKeys, boolean save, boolean trustUnsigned, boolean trustAlways) {
            this.trustAlways = trustAlways;
            this.trustedCertificates = (Certificate[])trustedCertificates.toArray(Certificate[]::new);
            this.trustedPGPKeys = trustedPGPKeys;
            this.saveTrustedCertificates = save;
            this.trustUnsigned = trustUnsigned;
        }

        public Certificate[] getTrustedCertificates() {
            return this.trustedCertificates;
        }

        public Collection<PGPPublicKey> getTrustedPGPKeys() {
            return this.trustedPGPKeys;
        }

        public boolean persistTrust() {
            return this.saveTrustedCertificates;
        }

        public boolean trustUnsignedContent() {
            return this.trustUnsigned;
        }

        public boolean trustAlways() {
            return this.trustAlways;
        }
    }
}

