/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eef.ide.ui.internal.widgets;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.eclipse.eef.EEFToolbarAction;
import org.eclipse.eef.common.ui.api.IEEFFormContainer;
import org.eclipse.eef.core.api.EEFGroup;
import org.eclipse.eef.core.api.EEFPage;
import org.eclipse.eef.core.api.EditingContextAdapter;
import org.eclipse.eef.core.api.controllers.EEFControllersFactory;
import org.eclipse.eef.core.api.controllers.IEEFController;
import org.eclipse.eef.core.api.controllers.IEEFSectionController;
import org.eclipse.eef.core.api.controllers.IEEFToolbarActionController;
import org.eclipse.eef.ide.ui.api.widgets.AbstractEEFLifecycleManager;
import org.eclipse.eef.ide.ui.api.widgets.IEEFLifecycleManager;
import org.eclipse.eef.ide.ui.internal.widgets.EEFGroupLifecycleManager;
import org.eclipse.eef.ide.ui.internal.widgets.IEEFToolbarLifecycleManager;
import org.eclipse.eef.ide.ui.internal.widgets.quickfix.EEFMessageHyperlinkListener;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.forms.events.IHyperlinkListener;

public class EEFSectionLifecycleManager
extends AbstractEEFLifecycleManager
implements IEEFToolbarLifecycleManager {
    private EEFPage eefPage;
    private IEEFSectionController controller;
    private List<IEEFLifecycleManager> lifecycleManagers = new ArrayList<IEEFLifecycleManager>();
    private IHyperlinkListener hyperlinkListener;

    public EEFSectionLifecycleManager(EEFPage eefPage) {
        this.eefPage = eefPage;
    }

    @Override
    public void createControl(Composite parent, IEEFFormContainer formContainer) {
        super.createControl(parent, formContainer);
        this.hyperlinkListener = new EEFMessageHyperlinkListener(formContainer.getShell());
        this.controller = new EEFControllersFactory().createSectionController(this.eefPage.getDescription(), this.eefPage.getVariableManager(), this.eefPage.getInterpreter(), this.eefPage.getView().getContextAdapter());
        List eefGroups = this.eefPage.getGroups();
        for (EEFGroup eefGroup : eefGroups) {
            EditingContextAdapter contextAdapter = eefGroup.getPage().getView().getContextAdapter();
            EEFGroupLifecycleManager groupLifecycleManager = new EEFGroupLifecycleManager(eefGroup.getDescription(), eefGroup.getVariableManager(), eefGroup.getInterpreter(), contextAdapter);
            groupLifecycleManager.createControl(parent, formContainer);
            this.lifecycleManagers.add(groupLifecycleManager);
        }
    }

    @Override
    public void aboutToBeShown() {
        super.aboutToBeShown();
        this.populateToolBar(this.container.getForm().getToolBarManager(), (Collection<EEFToolbarAction>)this.eefPage.getDescription().getActions(), (IEEFToolbarActionController)this.controller, this.eefPage.getView().getContextAdapter(), this.eefPage.getInterpreter(), this.eefPage.getVariableManager());
        this.container.getForm().addMessageHyperlinkListener(this.hyperlinkListener);
        this.lifecycleManagers.forEach(IEEFLifecycleManager::aboutToBeShown);
    }

    @Override
    public void refresh() {
        super.refresh();
        this.controller.refresh();
        this.lifecycleManagers.forEach(IEEFLifecycleManager::refresh);
        this.container.getForm().getMessageManager().update();
    }

    @Override
    public void aboutToBeHidden() {
        super.aboutToBeHidden();
        if (!this.container.getForm().isDisposed()) {
            this.container.getForm().removeMessageHyperlinkListener(this.hyperlinkListener);
            this.container.getForm().getMessageManager().removeAllMessages();
            this.clearToolBar(this.container.getForm().getToolBarManager());
        }
        this.lifecycleManagers.forEach(IEEFLifecycleManager::aboutToBeHidden);
    }

    private void clearToolBar(IToolBarManager toolBarManager) {
        if (toolBarManager instanceof ToolBarManager) {
            ToolBar toolBar = ((ToolBarManager)toolBarManager).getControl();
            toolBar.setBackground(Display.getCurrent().getSystemColor(37));
        }
        Optional.ofNullable(toolBarManager).ifPresent(manager -> {
            manager.removeAll();
            manager.update(true);
        });
    }

    @Override
    protected IEEFController getController() {
        return this.controller;
    }

    @Override
    protected Control getValidationControl() {
        return null;
    }

    @Override
    public void dispose() {
        this.lifecycleManagers.forEach(IEEFLifecycleManager::dispose);
    }
}

