/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eef.ide.ui.internal.widgets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.eef.EEFHyperlinkDescription;
import org.eclipse.eef.EEFHyperlinkStyle;
import org.eclipse.eef.EEFWidgetAction;
import org.eclipse.eef.EEFWidgetDescription;
import org.eclipse.eef.EEFWidgetStyle;
import org.eclipse.eef.common.ui.api.EEFWidgetFactory;
import org.eclipse.eef.common.ui.api.IEEFFormContainer;
import org.eclipse.eef.common.ui.api.SWTUtils;
import org.eclipse.eef.core.api.EditingContextAdapter;
import org.eclipse.eef.core.api.controllers.EEFControllersFactory;
import org.eclipse.eef.core.api.controllers.IEEFHyperlinkController;
import org.eclipse.eef.core.api.controllers.IEEFOnClickController;
import org.eclipse.eef.core.api.controllers.IEEFWidgetController;
import org.eclipse.eef.ide.ui.api.widgets.AbstractEEFWidgetLifecycleManager;
import org.eclipse.eef.ide.ui.api.widgets.EEFHyperlinkListener;
import org.eclipse.eef.ide.ui.api.widgets.EEFStyleHelper;
import org.eclipse.eef.ide.ui.internal.EEFIdeUiPlugin;
import org.eclipse.eef.ide.ui.internal.widgets.ActionButton;
import org.eclipse.eef.ide.ui.internal.widgets.EEFStyledTextStyleCallback;
import org.eclipse.sirius.common.interpreter.api.IInterpreter;
import org.eclipse.sirius.common.interpreter.api.IVariableManager;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class EEFHyperlinkLifecycleManager
extends AbstractEEFWidgetLifecycleManager {
    private EEFHyperlinkDescription description;
    private StyledText hyperlink;
    private EEFWidgetFactory widgetFactory;
    private List<ActionButton> actionButtons = new ArrayList<ActionButton>();
    private IEEFHyperlinkController controller;
    private MouseListener hyperlinkListener;

    public EEFHyperlinkLifecycleManager(EEFHyperlinkDescription description, IVariableManager variableManager, IInterpreter interpreter, EditingContextAdapter editingContextAdapter) {
        super(variableManager, interpreter, editingContextAdapter);
        this.description = description;
    }

    @Override
    protected void createMainControl(Composite parent, IEEFFormContainer formContainer) {
        this.widgetFactory = formContainer.getWidgetFactory();
        Composite hyperlinkComposite = this.widgetFactory.createFlatFormComposite(parent);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        hyperlinkComposite.setLayout((Layout)layout);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        hyperlinkComposite.setLayoutData((Object)gridData);
        this.createHyperlink(hyperlinkComposite);
        this.createWidgetActionButtons(hyperlinkComposite);
        this.controller = new EEFControllersFactory().createHyperlinkController(this.description, this.variableManager, this.interpreter, this.editingContextAdapter);
    }

    private void createHyperlink(Composite parent) {
        this.hyperlink = this.widgetFactory.createStyledText(parent, 8);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        gridData.horizontalIndent = 5;
        this.hyperlink.setLayoutData((Object)gridData);
        this.hyperlink.setEditable(false);
    }

    private void createWidgetActionButtons(Composite parent) {
        if (!this.description.getActions().isEmpty()) {
            Composite buttons = this.widgetFactory.createComposite(parent);
            GridData gridData = new GridData();
            gridData.grabExcessHorizontalSpace = false;
            buttons.setLayoutData((Object)gridData);
            GridLayout layout = new GridLayout(this.description.getActions().size(), true);
            layout.marginHeight = 0;
            buttons.setLayout((Layout)layout);
            for (EEFWidgetAction action : this.description.getActions()) {
                ActionButton actionButton = new ActionButton(action, buttons, this.widgetFactory, this.interpreter, this.variableManager);
                this.actionButtons.add(actionButton);
            }
        }
    }

    @Override
    protected int getLabelVerticalAlignment() {
        return 4;
    }

    @Override
    protected IEEFWidgetController getController() {
        return this.controller;
    }

    @Override
    protected EEFWidgetDescription getWidgetDescription() {
        return this.description;
    }

    @Override
    public void aboutToBeShown() {
        super.aboutToBeShown();
        this.hyperlinkListener = new EEFHyperlinkListener(this, (Control)this.hyperlink, this.container, (IEEFOnClickController)this.controller);
        this.hyperlink.addMouseListener(this.hyperlinkListener);
        this.controller.onNewValue(value -> {
            if (!this.hyperlink.isDisposed()) {
                if (this.hyperlink.getText() == null || !this.hyperlink.getText().equals(value)) {
                    String text = this.controller.computeDisplayValue(value);
                    this.hyperlink.setText(text);
                    this.hyperlink.setData(value);
                }
                this.setStyle();
                if (!this.hyperlink.isEnabled()) {
                    this.hyperlink.setEnabled(true);
                }
            }
        });
        this.actionButtons.forEach(actionButton -> {
            SelectionListener selectionListener = SWTUtils.widgetSelectedAdapter(event -> {
                if (!this.container.isRenderingInProgress()) {
                    IStatus result = this.controller.action(actionButton.getAction());
                    if (result != null && result.getSeverity() == 4) {
                        EEFIdeUiPlugin.INSTANCE.log(result);
                    } else {
                        this.refresh();
                    }
                }
            });
            actionButton.addSelectionListener(selectionListener);
        });
    }

    private void setStyle() {
        StyleRange[] styleRanges;
        StyleRange styleRange;
        EEFStyleHelper styleHelper = new EEFStyleHelper(this.interpreter, this.variableManager);
        EEFWidgetStyle widgetStyle = styleHelper.getWidgetStyle((EEFWidgetDescription)this.description);
        if (widgetStyle instanceof EEFHyperlinkStyle) {
            EEFHyperlinkStyle style = (EEFHyperlinkStyle)widgetStyle;
            EEFStyledTextStyleCallback callback = new EEFStyledTextStyleCallback(this.hyperlink);
            styleHelper.applyTextStyle(style.getFontNameExpression(), style.getFontSizeExpression(), style.getFontStyleExpression(), this.hyperlink.getFont(), style.getBackgroundColorExpression(), null, callback);
        }
        if ((styleRange = (styleRanges = this.hyperlink.getStyleRanges()).length > 0 ? styleRanges[0] : new StyleRange()) != null) {
            styleRange.start = 0;
            styleRange.length = this.hyperlink.getText().length();
            styleRange.underline = true;
            styleRange.underlineStyle = 4;
        }
        this.hyperlink.setStyleRange(styleRange);
    }

    @Override
    protected Control getValidationControl() {
        return this.hyperlink;
    }

    @Override
    public void aboutToBeHidden() {
        super.aboutToBeHidden();
        if (!this.hyperlink.isDisposed()) {
            this.hyperlink.removeMouseListener(this.hyperlinkListener);
        }
        this.actionButtons.forEach(ActionButton::removeSelectionListener);
        this.controller.removeNewValueConsumer();
    }

    @Override
    protected void setEnabled(boolean isEnabled) {
        if (!this.hyperlink.isDisposed()) {
            this.hyperlink.setEnabled(isEnabled);
        }
        this.actionButtons.stream().filter(actionButton -> !actionButton.getButton().isDisposed()).forEach(actionButton -> actionButton.setEnabled(isEnabled));
    }

    @Override
    public void dispose() {
        super.dispose();
        this.actionButtons.clear();
    }
}

