/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.builder;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.compiler.task.ITodoTaskPreferences;
import org.eclipse.dltk.compiler.task.TodoTaskAstParser;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.builder.AbstractBuildParticipantType;
import org.eclipse.dltk.core.builder.IBuildContext;
import org.eclipse.dltk.core.builder.IBuildParticipant;

public abstract class AbstractTodoTaskBuildParticipantType
extends AbstractBuildParticipantType {
    @Override
    public final IBuildParticipant createBuildParticipant(IScriptProject project) {
        ITodoTaskPreferences prefs = this.getPreferences(project);
        if (prefs.isEnabled()) {
            return this.getBuildParticipant(prefs);
        }
        return null;
    }

    protected abstract ITodoTaskPreferences getPreferences(IScriptProject var1);

    protected IBuildParticipant getBuildParticipant(ITodoTaskPreferences preferences) {
        return new TodoTaskBuildParticipant(preferences);
    }

    protected static class TodoTaskBuildParticipant
    extends TodoTaskAstParser
    implements IBuildParticipant {
        public TodoTaskBuildParticipant(ITodoTaskPreferences preferences) {
            super(preferences);
        }

        @Override
        public void build(IBuildContext context) throws CoreException {
            if (this.isValid()) {
                ModuleDeclaration ast = (ModuleDeclaration)context.get(IBuildContext.ATTR_MODULE_DECLARATION);
                this.initialize(ast);
                this.parse(context.getTaskReporter(), context.getContents());
            }
        }
    }
}

