/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.zest.core.viewers;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.zest.core.viewers.AbstractZoomableViewer;
import org.eclipse.zest.core.viewers.IGraphContentProvider;
import org.eclipse.zest.core.viewers.internal.IStylingGraphModelFactory;
import org.eclipse.zest.core.widgets.CGraphNode;
import org.eclipse.zest.core.widgets.ConstraintAdapter;
import org.eclipse.zest.core.widgets.Graph;
import org.eclipse.zest.core.widgets.GraphConnection;
import org.eclipse.zest.core.widgets.GraphContainer;
import org.eclipse.zest.core.widgets.GraphItem;
import org.eclipse.zest.core.widgets.GraphNode;
import org.eclipse.zest.core.widgets.IContainer;
import org.eclipse.zest.core.widgets.ZestStyles;
import org.eclipse.zest.layouts.LayoutAlgorithm;
import org.eclipse.zest.layouts.LayoutRelationship;

public abstract class AbstractStructuredGraphViewer
extends AbstractZoomableViewer {
    private final int graphStyle;
    private int nodeStyle;
    private int connectionStyle;
    private Map<Object, GraphNode> nodesMap = new HashMap<Object, GraphNode>();
    private Map<Object, GraphConnection> connectionsMap = new HashMap<Object, GraphConnection>();
    private final List<ConstraintAdapter> constraintAdapters = new ArrayList<ConstraintAdapter>();

    protected AbstractStructuredGraphViewer(int graphStyle) {
        this.graphStyle = graphStyle;
        this.connectionStyle = 0;
        this.nodeStyle = 0;
    }

    public void setNodeStyle(int nodeStyle) {
        if (this.getInput() != null) {
            throw new SWTError(1);
        }
        this.nodeStyle = nodeStyle;
    }

    public void setConnectionStyle(int connectionStyle) {
        if (this.getInput() != null) {
            throw new SWTError(1);
        }
        if (!ZestStyles.validateConnectionStyle(connectionStyle)) {
            throw new SWTError(5);
        }
        this.connectionStyle = connectionStyle;
    }

    public int getGraphStyle() {
        return this.graphStyle;
    }

    public int getNodeStyle() {
        return this.nodeStyle;
    }

    public Graph getGraphControl() {
        return (Graph)this.getControl();
    }

    public int getConnectionStyle() {
        return this.connectionStyle;
    }

    public void addConstraintAdapter(ConstraintAdapter constraintAdapter) {
        this.constraintAdapters.add(constraintAdapter);
    }

    public List<? extends ConstraintAdapter> getConstraintAdapters() {
        return this.constraintAdapters;
    }

    public abstract void setLayoutAlgorithm(LayoutAlgorithm var1, boolean var2);

    protected abstract LayoutAlgorithm getLayoutAlgorithm();

    public void setLayoutAlgorithm(LayoutAlgorithm algorithm) {
        this.setLayoutAlgorithm(algorithm, false);
    }

    public Object[] getNodeElements() {
        return this.nodesMap.keySet().toArray();
    }

    public Object[] getConnectionElements() {
        return this.connectionsMap.keySet().toArray();
    }

    public Map<Object, GraphNode> getNodesMap() {
        return this.nodesMap;
    }

    public GraphNode addGraphModelContainer(Object element) {
        GraphNode node = this.getGraphModelNode(element);
        if (node == null) {
            node = new GraphContainer((Graph)this.getControl(), 0);
            this.nodesMap.put(element, node);
            node.setData(element);
        }
        return node;
    }

    public GraphNode addGraphModelNode(IContainer container, Object element) {
        GraphNode node = this.getGraphModelNode(element);
        if (node == null) {
            node = new GraphNode(container, 0);
            this.nodesMap.put(element, node);
            node.setData(element);
        }
        return node;
    }

    protected GraphNode createNodeObject(Graph graphModel, IFigure figure) {
        return new CGraphNode((IContainer)graphModel, 0, figure);
    }

    protected GraphConnection createConnectionObject(Graph graphModel, GraphNode source, GraphNode destination) {
        return new GraphConnection(graphModel, 0, source, destination);
    }

    public GraphNode addGraphModelNode(Object element, IFigure figure) {
        GraphNode node = this.getGraphModelNode(element);
        if (node == null) {
            if (figure != null) {
                node = this.createNodeObject((Graph)this.getControl(), figure);
                this.nodesMap.put(element, node);
                node.setData(element);
            } else {
                node = new GraphNode((Graph)this.getControl(), 0);
                this.nodesMap.put(element, node);
                node.setData(element);
            }
        }
        return node;
    }

    public GraphConnection addGraphModelConnection(Object element, GraphNode source, GraphNode target) {
        GraphConnection connection = this.getGraphModelConnection(element);
        if (connection == null) {
            connection = this.createConnectionObject(this.getGraphControl(), source, target);
            this.connectionsMap.put(element, connection);
            connection.setData(element);
        }
        return connection;
    }

    public GraphConnection getGraphModelConnection(Object obj) {
        return this.connectionsMap.get(obj);
    }

    public GraphNode getGraphModelNode(Object obj) {
        return this.nodesMap.get(obj);
    }

    public void removeGraphModelConnection(Object obj) {
        GraphConnection connection = this.connectionsMap.get(obj);
        if (connection != null) {
            this.connectionsMap.remove(obj);
            if (!connection.isDisposed()) {
                connection.dispose();
            }
        }
    }

    public void removeGraphModelNode(Object obj) {
        GraphNode node = this.nodesMap.get(obj);
        if (node != null) {
            this.nodesMap.remove(obj);
            if (!node.isDisposed()) {
                node.dispose();
            }
        }
    }

    protected void internalRefresh(Object element) {
        if (this.getInput() == null) {
            return;
        }
        if (element == this.getInput()) {
            this.getFactory().refreshGraph(this.getGraphControl());
        } else {
            this.getFactory().refresh(this.getGraphControl(), element);
        }
        this.getGraphControl().getLightweightSystem().getUpdateManager().performUpdate();
    }

    protected void doUpdateItem(Widget item, Object element, boolean fullMap) {
        if (item == this.getGraphControl()) {
            this.getFactory().update(this.getNodesArray(this.getGraphControl()));
            this.getFactory().update(this.getConnectionsArray(this.getGraphControl()));
        } else if (item instanceof GraphItem) {
            this.getFactory().update((GraphItem)item);
        }
    }

    protected Widget doFindInputItem(Object element) {
        if (element == this.getInput() && element instanceof Widget) {
            return (Widget)element;
        }
        return null;
    }

    protected GraphItem doFindItem(Object element) {
        GraphItem node = this.nodesMap.get(element);
        GraphItem connection = this.connectionsMap.get(element);
        return node != null ? node : connection;
    }

    protected List<Object> getSelectionFromWidget() {
        List<? extends GraphItem> internalSelection = this.getWidgetSelection();
        LinkedList<Object> externalSelection = new LinkedList<Object>();
        for (GraphItem graphItem : internalSelection) {
            Object data = graphItem.getData();
            if (data == null) continue;
            externalSelection.add(data);
        }
        return externalSelection;
    }

    protected GraphItem[] findItems(List<Object> l) {
        if (l == null) {
            return new GraphItem[0];
        }
        return (GraphItem[])l.stream().map(arg_0 -> ((AbstractStructuredGraphViewer)this).findItem(arg_0)).toArray(GraphItem[]::new);
    }

    protected void setSelectionToWidget(List l, boolean reveal) {
        Graph control = (Graph)this.getControl();
        LinkedList<GraphItem> selection = new LinkedList<GraphItem>();
        for (Object obj : l) {
            GraphNode node = this.nodesMap.get(obj);
            GraphConnection conn = this.connectionsMap.get(obj);
            if (node != null) {
                selection.add(node);
            }
            if (conn == null) continue;
            selection.add(conn);
        }
        control.setSelection(selection.toArray(new GraphItem[selection.size()]));
    }

    protected List<? extends GraphItem> getWidgetSelection() {
        Graph control = (Graph)this.getControl();
        return control.getSelection();
    }

    protected void inputChanged(Object input, Object oldInput) {
        IStylingGraphModelFactory factory = this.getFactory();
        factory.setConnectionStyle(this.getConnectionStyle());
        factory.setNodeStyle(this.getNodeStyle());
        Map<Object, GraphNode> oldNodesMap = this.nodesMap;
        Graph graph = (Graph)this.getControl();
        graph.setSelection(new GraphNode[0]);
        for (GraphNode node : this.nodesMap.values()) {
            if (node.isDisposed()) continue;
            node.dispose();
        }
        for (GraphConnection connection : this.connectionsMap.values()) {
            if (connection.isDisposed()) continue;
            connection.dispose();
        }
        this.nodesMap = new HashMap<Object, GraphNode>();
        this.connectionsMap = new HashMap<Object, GraphConnection>();
        graph = factory.createGraphModel(graph);
        ((Graph)this.getControl()).setNodeStyle(this.getNodeStyle());
        ((Graph)this.getControl()).setConnectionStyle(this.getConnectionStyle());
        for (Object data : oldNodesMap.keySet()) {
            GraphNode newNode = this.nodesMap.get(data);
            if (newNode == null) continue;
            GraphNode oldNode = oldNodesMap.get(data);
            newNode.setLocation(oldNode.getLocation().x, oldNode.getLocation().y);
            if (!oldNode.isSizeFixed()) continue;
            newNode.setSize(oldNode.getSize().width, oldNode.getSize().height);
        }
        this.applyLayout();
    }

    protected abstract IStylingGraphModelFactory getFactory();

    protected void filterVisuals() {
        if (this.getGraphControl() == null) {
            return;
        }
        Object[] filtered = this.getFilteredChildren(this.getInput());
        SimpleGraphComparator comparator = new SimpleGraphComparator();
        TreeSet<GraphItem> filteredElements = new TreeSet<GraphItem>(comparator);
        TreeSet<GraphItem> unfilteredElements = new TreeSet<GraphItem>(comparator);
        List<? extends GraphConnection> connections = this.getGraphControl().getConnections();
        List<? extends GraphNode> nodes = this.getGraphControl().getNodes();
        if (filtered.length == 0) {
            for (GraphConnection graphConnection : connections) {
                graphConnection.setVisible(false);
            }
            for (GraphNode graphNode : nodes) {
                graphNode.setVisible(false);
            }
            return;
        }
        for (GraphConnection graphConnection : connections) {
            if (graphConnection.getExternalConnection() == null) continue;
            unfilteredElements.add(graphConnection);
        }
        for (GraphNode graphNode : nodes) {
            if (graphNode.getData() == null) continue;
            unfilteredElements.add(graphNode);
        }
        Object[] objectArray = filtered;
        int n = filtered.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            GraphItem modelElement = this.connectionsMap.get(object);
            if (modelElement == null) {
                modelElement = this.nodesMap.get(object);
            }
            if (modelElement != null) {
                filteredElements.add(modelElement);
            }
            ++n2;
        }
        unfilteredElements.removeAll(filteredElements);
        while (!unfilteredElements.isEmpty()) {
            GraphItem graphItem = unfilteredElements.first();
            graphItem.setVisible(false);
            unfilteredElements.remove((Object)graphItem);
        }
        while (!filteredElements.isEmpty()) {
            GraphItem graphItem = filteredElements.first();
            graphItem.setVisible(true);
            filteredElements.remove((Object)graphItem);
        }
    }

    protected Object[] getRawChildren(Object parent) {
        if (parent == this.getInput()) {
            LinkedList<Object> children = new LinkedList<Object>();
            if (this.getGraphControl() != null) {
                for (GraphConnection graphConnection : this.getGraphControl().getConnections()) {
                    if (graphConnection.getExternalConnection() == null) continue;
                    children.add(graphConnection.getExternalConnection());
                }
                for (GraphNode graphNode : this.getGraphControl().getNodes()) {
                    if (graphNode.getData() == null) continue;
                    children.add(graphNode.getData());
                }
                return children.toArray();
            }
        }
        return super.getRawChildren(parent);
    }

    public void reveal(Object element) {
        Widget[] items = this.findItems(element);
        Point location = null;
        Widget[] widgetArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            Widget item = widgetArray[n2];
            if (item instanceof GraphNode) {
                GraphNode graphModelNode = (GraphNode)item;
                graphModelNode.highlight();
                location = AbstractStructuredGraphViewer.getTopLeftBoundary(graphModelNode.getLocation(), location);
            } else if (item instanceof GraphConnection) {
                GraphConnection graphModelConnection = (GraphConnection)item;
                graphModelConnection.highlight();
                location = AbstractStructuredGraphViewer.getTopLeftBoundary(graphModelConnection.getSource().getLocation(), location);
                location = AbstractStructuredGraphViewer.getTopLeftBoundary(graphModelConnection.getDestination().getLocation(), location);
            }
            ++n2;
        }
        if (location != null) {
            this.getGraphControl().scrollSmoothTo(location.x, location.y);
        }
    }

    private static Point getTopLeftBoundary(Point point1, Point point2) {
        if (point2 != null) {
            return new Point(Math.min(point1.x, point2.x), Math.min(point1.y, point2.y));
        }
        return point1;
    }

    public void unReveal(Object element) {
        Widget[] items;
        Widget[] widgetArray = items = this.findItems(element);
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            Widget item = widgetArray[n2];
            if (item instanceof GraphNode) {
                GraphNode graphModelNode = (GraphNode)item;
                graphModelNode.unhighlight();
            } else if (item instanceof GraphConnection) {
                GraphConnection graphModelConnection = (GraphConnection)item;
                graphModelConnection.unhighlight();
            }
            ++n2;
        }
    }

    public abstract void applyLayout();

    public void removeRelationship(Object connection) {
        GraphConnection relationship = this.connectionsMap.get(connection);
        if (relationship != null) {
            LayoutAlgorithm layoutAlgorithm = this.getLayoutAlgorithm();
            if (layoutAlgorithm instanceof LayoutAlgorithm.Zest1) {
                LayoutAlgorithm.Zest1 zest1 = (LayoutAlgorithm.Zest1)layoutAlgorithm;
                zest1.removeRelationship(relationship.getLayoutRelationship());
            }
            relationship.dispose();
        }
    }

    public void addNode(Object element) {
        if (this.nodesMap.get(element) == null) {
            this.getFactory().createNode(this.getGraphControl(), element);
        }
    }

    public void removeNode(Object element) {
        GraphNode node = this.nodesMap.get(element);
        if (node != null) {
            LayoutAlgorithm layoutAlgorithm = this.getLayoutAlgorithm();
            if (layoutAlgorithm instanceof LayoutAlgorithm.Zest1) {
                LayoutAlgorithm.Zest1 zest1 = (LayoutAlgorithm.Zest1)layoutAlgorithm;
                zest1.removeEntity(node.getLayoutEntity());
                ArrayList<LayoutRelationship> relationships = new ArrayList<LayoutRelationship>();
                for (GraphConnection graphConnection : node.getSourceConnections()) {
                    relationships.add(graphConnection.getLayoutRelationship());
                }
                for (GraphConnection graphConnection : node.getTargetConnections()) {
                    relationships.add(graphConnection.getLayoutRelationship());
                }
                zest1.removeRelationships(relationships);
            }
            node.dispose();
        }
    }

    public void addRelationship(Object connection, Object srcNode, Object destNode) {
        IStylingGraphModelFactory modelFactory = this.getFactory();
        modelFactory.createConnection(this.getGraphControl(), connection, srcNode, destNode);
    }

    public void addRelationship(Object connection) {
        IStylingGraphModelFactory modelFactory = this.getFactory();
        if (this.connectionsMap.get(connection) == null) {
            if (!(modelFactory.getContentProvider() instanceof IGraphContentProvider)) {
                throw new UnsupportedOperationException();
            }
            IGraphContentProvider content = (IGraphContentProvider)modelFactory.getContentProvider();
            Object source = content.getSource(connection);
            Object dest = content.getDestination(connection);
            modelFactory.createConnection(this.getGraphControl(), connection, source, dest);
        }
    }

    protected GraphConnection[] getConnectionsArray(Graph graph) {
        GraphConnection[] connsArray = new GraphConnection[graph.getConnections().size()];
        return graph.getConnections().toArray(connsArray);
    }

    protected GraphNode[] getNodesArray(Graph graph) {
        GraphNode[] nodesArray = new GraphNode[graph.getNodes().size()];
        return graph.getNodes().toArray(nodesArray);
    }

    private class SimpleGraphComparator
    implements Comparator<GraphItem> {
        Set<String> storedStrings = new TreeSet<String>();

        @Override
        public int compare(GraphItem arg0, GraphItem arg1) {
            if (arg0 instanceof GraphNode && arg1 instanceof GraphConnection) {
                return 1;
            }
            if (arg0 instanceof GraphConnection && arg1 instanceof GraphNode) {
                return -1;
            }
            if (((Object)((Object)arg0)).equals((Object)arg1)) {
                return 0;
            }
            return this.getObjectString((Object)arg0).compareTo(this.getObjectString((Object)arg1));
        }

        private String getObjectString(Object o) {
            String s = o.getClass().getName() + "@" + Integer.toHexString(o.hashCode());
            while (this.storedStrings.contains(s)) {
                s = s + "X";
            }
            return s;
        }
    }
}

