/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public final class EnvironmentUtils
extends AbstractUIPlugin {
    public static final String HOST_NAME = EnvironmentUtils.getHostName();
    public static final boolean DEVELOPER_HOST;
    public static final boolean IS_WINDOWS;
    public static final boolean IS_MAC;
    public static final boolean IS_LINUX;
    private static final String OS_NAME_OSX_PREFIX = "Mac OS X";
    public static final boolean IS_MAC_10_6;
    private static Float m_forcedJavaVersion;
    private static final String WBP_JAVA_VM_VENDOR = "wbp java.vm.vendor";
    private static final String WBP_TESTING_TIME = "wbp.testing.time";
    private static final String WBP_GEF_PALETTE = "wbp.gef.palette";
    private static final String WBP_BURNINGWAVE = "wbp.burningwave.enabled";

    static {
        String host = HOST_NAME.toUpperCase(Locale.ENGLISH);
        DEVELOPER_HOST = "SCHEGLOV-KE".equals(host) || "SCHEGLOV-MACPRO".equals(host) || "SCHEGLOV-WIN".equals(host) || "SCHEGLOV".equals(host) || "MITIN-AA".equals(host) || "MITIN-AA-MAC".equals(host) || "SABLIN-AA".equals(host) || "FLANKER-WINDOWS".equals(host);
        IS_MAC_10_6 = EnvironmentUtils.getOSMatches(OS_NAME_OSX_PREFIX, "10.6");
        if (SystemUtils.OS_NAME.startsWith("Windows")) {
            IS_WINDOWS = true;
            IS_MAC = false;
            IS_LINUX = false;
        } else if (SystemUtils.OS_NAME.startsWith("Linux")) {
            IS_WINDOWS = false;
            IS_MAC = false;
            IS_LINUX = true;
        } else if (SystemUtils.OS_NAME.startsWith(OS_NAME_OSX_PREFIX)) {
            IS_WINDOWS = false;
            IS_MAC = true;
            IS_LINUX = false;
        } else if (SystemUtils.OS_NAME.startsWith("Mac")) {
            IS_WINDOWS = false;
            IS_MAC = true;
            IS_LINUX = false;
        } else {
            IS_WINDOWS = false;
            IS_MAC = false;
            IS_LINUX = false;
        }
        m_forcedJavaVersion = null;
    }

    private static String getHostName() {
        String hostName = "";
        try {
            String[] names;
            hostName = InetAddress.getLocalHost().getHostName();
            String[] stringArray = names = StringUtils.split((String)hostName, (char)'.');
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                if (StringUtils.isNumeric((CharSequence)name)) {
                    return hostName;
                }
                ++n2;
            }
            hostName = names[0];
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return hostName;
    }

    private static boolean getOSMatches(String osNamePrefix, String osVersionPrefix) {
        if (SystemUtils.OS_NAME == null || SystemUtils.OS_VERSION == null) {
            return false;
        }
        return SystemUtils.OS_NAME.startsWith(osNamePrefix) && SystemUtils.OS_VERSION.startsWith(osVersionPrefix);
    }

    public static float getJavaVersion() {
        if (m_forcedJavaVersion != null) {
            return m_forcedJavaVersion.floatValue();
        }
        Runtime.Version version = Runtime.version();
        String versionString = String.format("%d.%d%d%d", version.feature(), version.interim(), version.update(), version.patch());
        return Float.valueOf(versionString).floatValue();
    }

    public static float getMinimumJavaVersion() {
        return 1.8f;
    }

    public static void setForcedJavaVersion(Float version) {
        m_forcedJavaVersion = version;
    }

    public static boolean isJavaIBM() {
        return EnvironmentUtils.getTestSensetive_JAVA_VM_VENDOR().toUpperCase(Locale.ENGLISH).contains("IBM");
    }

    private static String getTestSensetive_JAVA_VM_VENDOR() {
        String forcedVendor = System.getProperty(WBP_JAVA_VM_VENDOR);
        if (forcedVendor != null) {
            return forcedVendor;
        }
        return SystemUtils.JAVA_VM_VENDOR;
    }

    public static void setForcedIBM(boolean forced) {
        if (forced) {
            System.setProperty(WBP_JAVA_VM_VENDOR, "Fake IBM");
        } else {
            System.clearProperty(WBP_JAVA_VM_VENDOR);
        }
    }

    public static boolean isTestingTime() {
        return "true".equals(System.getProperty(WBP_TESTING_TIME));
    }

    public static void setTestingTime(boolean value) {
        System.setProperty(WBP_TESTING_TIME, value ? "true" : "false");
    }

    public static boolean isGefPalette() {
        return Boolean.getBoolean(WBP_GEF_PALETTE);
    }

    public static boolean isBurningWaveEnabled() {
        return Boolean.valueOf(System.getProperty(WBP_BURNINGWAVE, Boolean.TRUE.toString()));
    }
}

