/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.presentation;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.ui.PHPDebugUIPlugin;

public class PHPModelPresentationRegistry {
    private static final String EXTENSION_POINT_NAME = "phpDebugModelPresentations";
    private static final String MODEL_PRESENTATION_TAG = "phpDebugModelPresentation";
    private static final String ID_ATTRIBUTE = "id";
    private static final String CLASS_ATTRIBUTE = "class";
    private static PHPModelPresentationRegistry instance = null;
    private Dictionary<String, DebugModelPresentationFactory> debugModelPresentations = new Hashtable<String, DebugModelPresentationFactory>();
    private IDebugModelPresentation bestMatchPresentation;

    private PHPModelPresentationRegistry() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = registry.getConfigurationElementsFor(PHPDebugUIPlugin.getID(), EXTENSION_POINT_NAME);
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            if (MODEL_PRESENTATION_TAG.equals(element.getName())) {
                this.debugModelPresentations.put(element.getAttribute(ID_ATTRIBUTE), new DebugModelPresentationFactory(element));
            }
            ++i;
        }
    }

    private static PHPModelPresentationRegistry getInstance() {
        if (instance == null) {
            instance = new PHPModelPresentationRegistry();
        }
        return instance;
    }

    public static IDebugModelPresentation getBestMatchPresentation() {
        PHPModelPresentationRegistry registry = PHPModelPresentationRegistry.getInstance();
        if (registry.bestMatchPresentation != null) {
            return registry.bestMatchPresentation;
        }
        try {
            DebugModelPresentationFactory bestModelPresentationFactory = null;
            Dictionary<String, DebugModelPresentationFactory> presentations = registry.debugModelPresentations;
            Enumeration<DebugModelPresentationFactory> e = presentations.elements();
            while (e.hasMoreElements()) {
                DebugModelPresentationFactory modelPresentationFactory = e.nextElement();
                if (PHPDebugUIPlugin.getID().equals(modelPresentationFactory.element.getNamespaceIdentifier())) {
                    bestModelPresentationFactory = modelPresentationFactory;
                    continue;
                }
                registry.bestMatchPresentation = modelPresentationFactory.createParametersInitializer();
                return registry.bestMatchPresentation;
            }
            if (bestModelPresentationFactory != null) {
                registry.bestMatchPresentation = bestModelPresentationFactory.createParametersInitializer();
                return registry.bestMatchPresentation;
            }
        }
        catch (Exception e) {
            PHPDebugPlugin.log((Throwable)e);
        }
        return null;
    }

    private class DebugModelPresentationFactory {
        private IConfigurationElement element;
        private IDebugModelPresentation modelPresentation;

        public DebugModelPresentationFactory(IConfigurationElement element) {
            this.element = element;
        }

        public IDebugModelPresentation createParametersInitializer() {
            SafeRunner.run((ISafeRunnable)new SafeRunnable("Error creation extension for extension-point org.eclipse.php.internal.debug.core.phpDebugParametersInitializers"){

                public void run() throws Exception {
                    DebugModelPresentationFactory.this.modelPresentation = (IDebugModelPresentation)DebugModelPresentationFactory.this.element.createExecutableExtension(PHPModelPresentationRegistry.CLASS_ATTRIBUTE);
                }
            });
            return this.modelPresentation;
        }
    }
}

