/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.impactanalyzer.instanceScope;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.ocl.ecore.OCLExpression;
import org.eclipse.ocl.ecore.OperationCallExp;
import org.eclipse.ocl.ecore.TypeExp;
import org.eclipse.ocl.ecore.Variable;
import org.eclipse.ocl.ecore.impl.TypeExpImpl;
import org.eclipse.ocl.examples.impactanalyzer.impl.OperationBodyToCallMapper;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.AbstractTracer;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.AllInstancesNavigationStep;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.EmptyResultNavigationStep;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.IdentityNavigationStep;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.IndirectingStep;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.NavigationStep;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.PathCache;
import org.eclipse.ocl.examples.impactanalyzer.util.OCLFactory;

public class OperationCallExpTracer
extends AbstractTracer<OperationCallExp> {
    private static final Set<String> sourcePassThroughStdLibOpNames = new HashSet<String>();
    private static final Set<String> argumentPassThroughStdLibOpNames;

    static {
        sourcePassThroughStdLibOpNames.add("any");
        sourcePassThroughStdLibOpNames.add("asBag");
        sourcePassThroughStdLibOpNames.add("asSet");
        sourcePassThroughStdLibOpNames.add("asOrderedSet");
        sourcePassThroughStdLibOpNames.add("asSequence");
        sourcePassThroughStdLibOpNames.add("at");
        sourcePassThroughStdLibOpNames.add("excluding");
        sourcePassThroughStdLibOpNames.add("first");
        sourcePassThroughStdLibOpNames.add("flatten");
        sourcePassThroughStdLibOpNames.add("including");
        sourcePassThroughStdLibOpNames.add("insertAt");
        sourcePassThroughStdLibOpNames.add("append");
        sourcePassThroughStdLibOpNames.add("intersection");
        sourcePassThroughStdLibOpNames.add("oclAsType");
        sourcePassThroughStdLibOpNames.add("union");
        sourcePassThroughStdLibOpNames.add("selectByKind");
        sourcePassThroughStdLibOpNames.add("selectByType");
        argumentPassThroughStdLibOpNames = new HashSet<String>();
        argumentPassThroughStdLibOpNames.add("including");
        argumentPassThroughStdLibOpNames.add("insertAt");
        argumentPassThroughStdLibOpNames.add("append");
        argumentPassThroughStdLibOpNames.add("union");
    }

    public OperationCallExpTracer(OperationCallExp expression, Stack<String> tuplePartNames, OCLFactory oclFactory) {
        super(expression, tuplePartNames, oclFactory);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public NavigationStep traceback(EClass context, PathCache pathCache, OperationBodyToCallMapper operationBodyToCallMapper) {
        void var4_17;
        OCLExpression body = operationBodyToCallMapper.getOperationBody((EOperation)((OperationCallExp)this.getExpression()).getReferredOperation());
        if (body != null) {
            IndirectingStep bodyStep = pathCache.createIndirectingStepFor((OCLExpression)this.getExpression(), this.getTupleLiteralPartNamesToLookFor());
            NavigationStep actualStep = (NavigationStep)pathCache.getOrCreateNavigationPath(body, context, operationBodyToCallMapper, this.getTupleLiteralPartNamesToLookFor(), this.oclFactory);
            bodyStep.setActualStep(actualStep);
            IndirectingStep indirectingStep = bodyStep;
        } else {
            String opName = ((EOperation)((OperationCallExp)this.getExpression()).getReferredOperation()).getName();
            if (opName.equals("oclAsType")) {
                OCLExpression argument = (OCLExpression)((OperationCallExp)this.getExpression()).getArgument().get(0);
                if (!(argument instanceof TypeExp)) throw new RuntimeException("What else could be the argument of oclAsType if not a TypeExp? " + argument.eClass().getName());
                EClassifier type = ((TypeExpImpl)argument).getReferredType();
                IdentityNavigationStep identityStep = new IdentityNavigationStep((EClass)((OperationCallExp)this.getExpression()).getType(), (EClass)type, (OCLExpression)this.getExpression());
                NavigationStep sourceStep = (NavigationStep)pathCache.getOrCreateNavigationPath((OCLExpression)((OperationCallExp)this.getExpression()).getSource(), context, operationBodyToCallMapper, this.getTupleLiteralPartNamesToLookFor(), this.oclFactory);
                NavigationStep navigationStep = pathCache.navigationStepFromSequence((OCLExpression)this.getExpression(), this.getTupleLiteralPartNamesToLookFor(), identityStep, sourceStep);
            } else if (sourcePassThroughStdLibOpNames.contains(opName)) {
                NavigationStep sourcePath = (NavigationStep)pathCache.getOrCreateNavigationPath((OCLExpression)((OperationCallExp)this.getExpression()).getSource(), context, operationBodyToCallMapper, this.getTupleLiteralPartNamesToLookFor(), this.oclFactory);
                if (argumentPassThroughStdLibOpNames.contains(opName)) {
                    int paramPos = 0;
                    if (opName.equals("insertAt")) {
                        paramPos = 1;
                    }
                    OCLExpression argument = (OCLExpression)((OperationCallExp)this.getExpression()).getArgument().get(paramPos);
                    NavigationStep argumentPath = (NavigationStep)pathCache.getOrCreateNavigationPath(argument, context, operationBodyToCallMapper, this.getTupleLiteralPartNamesToLookFor(), this.oclFactory);
                    NavigationStep navigationStep = pathCache.navigationStepForBranch(this.getInnermostElementType((EClassifier)((OperationCallExp)this.getExpression()).getType()), context, (OCLExpression)this.getExpression(), this.getTupleLiteralPartNamesToLookFor(), opName.equals("selectByType"), sourcePath, argumentPath);
                } else {
                    NavigationStep navigationStep = pathCache.navigationStepForBranch(this.getInnermostElementType((EClassifier)((OperationCallExp)this.getExpression()).getType()), context, (OCLExpression)this.getExpression(), this.getTupleLiteralPartNamesToLookFor(), opName.equals("selectByType"), sourcePath);
                }
            } else if (opName.equals("allInstances")) {
                EClass classifier = (EClass)((TypeExp)((OperationCallExp)this.getExpression()).getSource()).getReferredType();
                AllInstancesNavigationStep allInstancesNavigationStep = new AllInstancesNavigationStep(classifier, context, (OCLExpression)this.getExpression(), pathCache.getOppositeEndFinder());
            } else {
                EmptyResultNavigationStep emptyResultNavigationStep = new EmptyResultNavigationStep((OCLExpression)this.getExpression());
            }
        }
        this.applyScopesOnNavigationStep((NavigationStep)var4_17, operationBodyToCallMapper);
        return var4_17;
    }

    @Override
    protected Set<Variable> calculateEnteringScope(OperationBodyToCallMapper operationBodyToCallMapper) {
        OCLExpression body = operationBodyToCallMapper.getOperationBody((EOperation)((OperationCallExp)this.getExpression()).getReferredOperation());
        if (body != null) {
            return OperationCallExpTracer.getVariablesScopedByExpression(body, operationBodyToCallMapper);
        }
        return Collections.emptySet();
    }

    @Override
    protected Set<Variable> calculateLeavingScopes(OperationBodyToCallMapper operationBodyToCallMapper) {
        return OperationCallExpTracer.getAllVariablesInScope((OCLExpression)this.getExpression(), operationBodyToCallMapper);
    }
}

