/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.internal.modulecore;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jst.common.internal.modulecore.IClasspathDependencyComponent;
import org.eclipse.jst.common.internal.modulecore.IClasspathDependencyProvider;
import org.eclipse.jst.common.internal.modulecore.IClasspathDependencyReceiver;
import org.eclipse.wst.common.componentcore.internal.flat.AbstractFlattenParticipant;
import org.eclipse.wst.common.componentcore.internal.flat.FlatVirtualComponent;
import org.eclipse.wst.common.componentcore.internal.flat.IFlatResource;
import org.eclipse.wst.common.componentcore.internal.flat.VirtualComponentFlattenUtility;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;

public class AddClasspathLibReferencesParticipant
extends AbstractFlattenParticipant {
    private List<IFlatResource> list;

    public boolean shouldIgnoreReference(IVirtualComponent rootComponent, IVirtualReference referenced, FlatVirtualComponent.FlatComponentTaskModel dataModel) {
        return referenced.getRuntimePath().toString().startsWith("../");
    }

    public void finalize(IVirtualComponent component, FlatVirtualComponent.FlatComponentTaskModel dataModel, List<IFlatResource> resources) {
        this.list = resources;
        if (!(component instanceof IClasspathDependencyReceiver)) {
            return;
        }
        if (((IClasspathDependencyReceiver)component).canReceiveClasspathDependencies()) {
            this.addReferencedComponentClasspathDependencies((IClasspathDependencyReceiver)component);
        }
    }

    private void addReferencedComponentClasspathDependencies(IClasspathDependencyReceiver component) {
        IVirtualReference[] refs = component.getReferences();
        int i = 0;
        while (i < refs.length) {
            IVirtualReference reference = refs[i];
            IPath runtimePath = reference.getRuntimePath();
            IVirtualComponent referencedComponent = reference.getReferencedComponent();
            if (referencedComponent instanceof IClasspathDependencyProvider && !referencedComponent.isBinary() && referencedComponent instanceof IClasspathDependencyProvider) {
                IVirtualReference[] cpRefs = ((IClasspathDependencyProvider)referencedComponent).getJavaClasspathReferences();
                int j = 0;
                while (j < cpRefs.length) {
                    IClasspathDependencyComponent cpComp;
                    IVirtualReference cpRef = cpRefs[j];
                    IPath cpRefRuntimePath = cpRef.getRuntimePath();
                    if (cpRef.getReferencedComponent() instanceof IClasspathDependencyComponent && !(cpComp = (IClasspathDependencyComponent)cpRef.getReferencedComponent()).isClassFolder() && cpRefRuntimePath.toString().startsWith("../")) {
                        cpRefRuntimePath = runtimePath.append(cpRefRuntimePath.removeFirstSegments(1));
                        new VirtualComponentFlattenUtility(this.list, null).addFile((IVirtualComponent)cpComp, cpRefRuntimePath, (IAdaptable)cpComp);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private List<IVirtualReference> getReferencedProjectComponentClasspathDependencies(IClasspathDependencyReceiver component, FlatVirtualComponent.FlatComponentTaskModel dataModel) {
        IVirtualReference[] refs = component.getReferences();
        ArrayList<IVirtualReference> validReferences = new ArrayList<IVirtualReference>();
        int i = 0;
        while (i < refs.length) {
            IVirtualReference reference = refs[i];
            IVirtualComponent referencedComponent = reference.getReferencedComponent();
            if (referencedComponent instanceof IClasspathDependencyProvider && !referencedComponent.isBinary() && referencedComponent instanceof IClasspathDependencyProvider) {
                IVirtualReference[] cpRefs = ((IClasspathDependencyProvider)referencedComponent).getJavaClasspathReferences();
                int j = 0;
                while (j < cpRefs.length) {
                    IVirtualReference cpRef = cpRefs[j];
                    IPath cpRefRuntimePath = cpRef.getRuntimePath();
                    if (!(cpRef.getReferencedComponent() instanceof IClasspathDependencyComponent) && cpRefRuntimePath.toString().startsWith("../")) {
                        validReferences.add(new ClasspathLibVirtualReference(cpRef));
                    }
                    ++j;
                }
            }
            ++i;
        }
        return validReferences;
    }

    public List<IVirtualReference> getChildModules(IVirtualComponent component, FlatVirtualComponent.FlatComponentTaskModel dataModel) {
        List<IVirtualReference> result = null;
        if (!(component instanceof IClasspathDependencyReceiver)) {
            return null;
        }
        if (((IClasspathDependencyReceiver)component).canReceiveClasspathDependencies()) {
            result = this.getReferencedProjectComponentClasspathDependencies((IClasspathDependencyReceiver)component, dataModel);
        }
        return result;
    }

    private static class ClasspathLibVirtualReference
    implements IVirtualReference {
        private IVirtualReference ref;

        ClasspathLibVirtualReference(IVirtualReference ref) {
            this.ref = ref;
        }

        public void create(int updateFlags, IProgressMonitor aMonitor) {
            this.ref.create(updateFlags, aMonitor);
        }

        public boolean exists() {
            return this.ref.exists();
        }

        public String getArchiveName() {
            return this.ref.getArchiveName();
        }

        public int getDependencyType() {
            return this.ref.getDependencyType();
        }

        public IVirtualComponent getEnclosingComponent() {
            return this.ref.getEnclosingComponent();
        }

        public IVirtualComponent getReferencedComponent() {
            return this.ref.getReferencedComponent();
        }

        public IPath getRuntimePath() {
            return this.ref.getRuntimePath().removeFirstSegments(1);
        }

        public boolean isDerived() {
            return this.ref.isDerived();
        }

        public void setArchiveName(String archiveName) {
            this.ref.setArchiveName(archiveName);
        }

        public void setDependencyType(int aDependencyType) {
            this.ref.setDependencyType(aDependencyType);
        }

        public void setReferencedComponent(IVirtualComponent referencedComponent, EObject dependentObject) {
            this.ref.setReferencedComponent(referencedComponent, dependentObject);
        }

        public void setRuntimePath(IPath aRuntimePath) {
            this.ref.setRuntimePath(aRuntimePath);
        }
    }
}

