/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.launching;

import java.io.File;
import org.eclipse.jdt.internal.launching.LaunchingMessages;
import org.eclipse.jdt.internal.launching.LaunchingPlugin;
import org.eclipse.jdt.internal.launching.StandardVMDebugger;
import org.eclipse.jdt.internal.launching.StandardVMRunner;
import org.eclipse.jdt.internal.launching.StandardVMType;
import org.eclipse.jdt.launching.AbstractVMInstall;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.IVMRunner;
import org.eclipse.osgi.util.NLS;

public class StandardVM
extends AbstractVMInstall {
    public static final String VAR_PORT = "${port}";

    StandardVM(IVMInstallType type, String id) {
        super(type, id);
    }

    @Override
    public IVMRunner getVMRunner(String mode) {
        if ("run".equals(mode)) {
            return new StandardVMRunner(this);
        }
        if ("debug".equals(mode)) {
            return new StandardVMDebugger(this);
        }
        return null;
    }

    @Override
    public String getJavaVersion() {
        StandardVMType installType = (StandardVMType)this.getVMInstallType();
        File installLocation = this.getInstallLocation();
        if (installLocation != null) {
            File executable = this.getJavaExecutable();
            if (executable != null) {
                String vmVersion = installType.getVMVersion(installLocation, executable);
                StringBuilder version = new StringBuilder();
                int i = 0;
                block3: while (i < vmVersion.length()) {
                    char ch = vmVersion.charAt(i);
                    switch (ch) {
                        case '-': 
                        case '.': 
                        case '_': {
                            version.append(ch);
                            break;
                        }
                        default: {
                            if (!Character.isDigit(ch)) break block3;
                            version.append(ch);
                        }
                    }
                    ++i;
                }
                if (version.length() > 0) {
                    return version.toString();
                }
            }
            LaunchingPlugin.log(NLS.bind((String)LaunchingMessages.vmInstall_could_not_determine_java_Version, (Object)installLocation.getAbsolutePath()));
        }
        return null;
    }

    File getJavaExecutable() {
        File installLocation = this.getInstallLocation();
        if (installLocation != null) {
            return StandardVMType.findJavaExecutable(installLocation);
        }
        return null;
    }

    public String getDebugArgs() {
        return null;
    }
}

