/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.api.tests;

import java.util.Optional;
import org.eclipse.passage.lic.api.AccessCycleConfiguration;
import org.eclipse.passage.lic.api.Framework;
import org.eclipse.passage.lic.api.conditions.evaluation.ExpressionProtocol;
import org.eclipse.passage.lic.api.conditions.mining.ContentType;
import org.eclipse.passage.lic.api.inspection.RuntimeEnvironmentRegistry;
import org.eclipse.passage.lic.api.registry.Registry;
import org.eclipse.passage.lic.api.registry.Service;
import org.eclipse.passage.lic.api.registry.ServiceId;
import org.junit.Assert;
import org.junit.Test;

public abstract class FrameworkContractTest {
    @Test
    public final void exists() {
        Assert.assertNotNull(this.framework());
        Assert.assertTrue((boolean)this.framework().isPresent());
    }

    @Test
    public final void suppliesLicensedProductInformation() {
        Assert.assertNotNull((Object)this.framework().get().product());
    }

    @Test
    public final void canResolveRequirements() {
        this.assertServiceRegistryIsFunctional((Registry)this.config().requirementResolvers().get());
    }

    @Test
    public final void prohibitsRequirementsResolutionExtension() {
        Assert.assertTrue((boolean)this.readOnly((Registry)this.config().requirementResolvers().get()));
    }

    @Test
    public final void canMineConditions() {
        this.assertServiceRegistryIsFunctional((Registry)this.config().conditionMiners().get());
    }

    @Test
    public final void prohibitsConditionMiningExtension() {
        Assert.assertTrue((boolean)this.readOnly((Registry)this.config().conditionMiners().get()));
    }

    @Test
    public final void canEncodeAndDecodeStreams() {
        this.assertServiceRegistryIsFunctional((Registry)this.config().codecs().get());
    }

    @Test
    public final void prohibitsStreamCodecServicesExtension() {
        Assert.assertTrue((boolean)this.readOnly((Registry)this.config().codecs().get()));
    }

    @Test
    public final void canEncodeAndDecodeForProduct() {
        Assert.assertTrue((boolean)((Registry)this.config().codecs().get()).hasService((ServiceId)this.framework().get().product()));
    }

    @Test
    public final void hasKeyKeepers() {
        this.assertServiceRegistryIsFunctional((Registry)this.config().keyKeepers().get());
    }

    @Test
    public final void prohibitsKeyKeeperServicesExtension() {
        Assert.assertTrue((boolean)this.readOnly((Registry)this.config().keyKeepers().get()));
    }

    @Test
    public final void keepsKeyForProduct() {
        Assert.assertTrue((boolean)((Registry)this.config().keyKeepers().get()).hasService((ServiceId)this.framework().get().product()));
    }

    @Test
    public final void hasConditionTransports() {
        this.assertServiceRegistryIsFunctional((Registry)this.config().transports().get());
    }

    @Test
    public final void prohibitsConditionTransportServicesExtension() {
        Assert.assertTrue((boolean)this.readOnly((Registry)this.config().transports().get()));
    }

    @Test
    public final void hasTransportForXml() {
        Assert.assertTrue((boolean)((Registry)this.config().transports().get()).hasService((ServiceId)new ContentType.Xml()));
    }

    @Test
    public final void canParseConditionExpressions() {
        this.assertServiceRegistryIsFunctional((Registry)this.config().expressionParsers().get());
    }

    @Test
    public final void prohibitsExpressionParseServicesExtension() {
        Assert.assertTrue((boolean)this.readOnly((Registry)this.config().expressionParsers().get()));
    }

    @Test
    public final void hasParserForDefaultExpressionFormat() {
        Assert.assertTrue((boolean)((Registry)this.config().expressionParsers().get()).hasService((ServiceId)new ExpressionProtocol.Default()));
    }

    @Test
    public final void canEvaluateConditionExpressions() {
        this.assertServiceRegistryIsFunctional((Registry)this.config().expressionEvaluators().get());
    }

    @Test
    public final void prohibitsExpressionEvaluationServicesExtension() {
        Assert.assertTrue((boolean)this.readOnly((Registry)this.config().expressionEvaluators().get()));
    }

    @Test
    public final void hasEvaluatorForDefaultExpressionFormat() {
        Assert.assertTrue((boolean)((Registry)this.config().expressionEvaluators().get()).hasService((ServiceId)new ExpressionProtocol.Default()));
    }

    @Test
    public final void canAssessConditionExpressionsSegment() {
        this.assertServiceRegistryIsFunctional((Registry)this.config().expressionAssessors().get());
    }

    @Test
    public final void prohibitsExpressionSegmentAssessmentServicesExtension() {
        Assert.assertTrue((boolean)this.readOnly((Registry)this.config().expressionAssessors().get()));
    }

    @Test
    public final void hasRuntimeEnvironmentInspectorsRegistry() {
        RuntimeEnvironmentRegistry environments = this.framework().get().accessCycleConfiguration().environments();
        Assert.assertNotNull((Object)environments);
        Assert.assertNotNull((Object)environments.get());
        Assert.assertNotNull((Object)((Registry)environments.get()).services());
    }

    @Test
    public final void prohibitsRuntimeEnvironmentInspectionServicesExtension() {
        Assert.assertTrue((boolean)this.readOnly((Registry)this.config().expressionAssessors().get()));
    }

    @Test
    public final void canExaminePermissionsAgainstRequirements() {
        this.assertServiceRegistryIsFunctional((Registry)this.config().examinators().get());
    }

    @Test
    public final void prohibitsPermissionExaminingServicesExtension() {
        Assert.assertTrue((boolean)this.readOnly((Registry)this.config().examinators().get()));
    }

    @Test
    public final void canAquireLicensesFromMiningTargets() {
        Assert.assertTrue((boolean)((Registry)this.config().conditionMiners().get()).services().stream().map(Service::id).allMatch(target -> ((Registry)this.config().acquirers().get()).hasService((ServiceId)target)));
    }

    private <I extends ServiceId, S extends Service<I>> void assertServiceRegistryIsFunctional(Registry<I, S> registry) {
        Assert.assertNotNull(registry);
        Assert.assertNotNull((Object)registry.services());
        Assert.assertTrue((registry.services().size() > 0 ? 1 : 0) != 0);
    }

    private AccessCycleConfiguration config() {
        return this.framework().get().accessCycleConfiguration();
    }

    protected abstract Optional<Framework> framework();

    protected abstract boolean readOnly(Registry<?, ?> var1);
}

