/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.ui.widgets;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.internal.ui.bundle.OM;
import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.net4j.util.ui.widgets.EntryControlAdvisor;
import org.eclipse.net4j.util.ui.widgets.ImageButton;
import org.eclipse.net4j.util.ui.widgets.SafeBrowser;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;

public final class EntryField
extends Composite {
    private static final int MIN_CONTROL_HEIGHT = 15;
    private static final int MAX_CONTROL_HEIGHT = 120;
    private static final int RADIUS = 36;
    private static final int MARGIN = 9;
    private static final int MARGIN_TWICE = 18;
    private static final String TOOLTIP_PREVIEW = OM.BUNDLE.getTranslationSupport().getString("entry.field.preview");
    private static final String TOOLTIP_EDIT = OM.BUNDLE.getTranslationSupport().getString("entry.field.edit");
    private final FieldConfig config;
    private final Color whiteColor;
    private final ImageButton[] extraButtons;
    private final ImageButton modeButton;
    private Control control;
    private Mode mode = new EditMode();
    private String initialEntry;
    private String entry;
    private boolean empty;
    private boolean dirty;
    private int lastControlHeight;

    public EntryField(Composite parent, int style, FieldConfig config) {
        super(parent, style | 0x20000000);
        config = new FieldConfig(config);
        config.setEntryControlConfig(this.interceptModifyHandler(config.getEntryControlConfig()));
        this.config = config;
        this.mode = config.isInitialPreviewMode() ? new PreviewMode() : new EditMode();
        this.whiteColor = this.getDisplay().getSystemColor(1);
        this.addPaintListener(e -> {
            Rectangle box = this.getClientArea();
            e.gc.setAntialias(1);
            this.mode.paintRoundBackground(e.gc, box);
        });
        Object[] buttonAdvisors = config.getExtraButtonAdvisors();
        this.extraButtons = new ImageButton[ObjectUtil.size((Object[])buttonAdvisors)];
        this.setLayout((Layout)GridLayoutFactory.fillDefaults().margins(9, 9).numColumns(2 + this.extraButtons.length).create());
        int i = 0;
        while (i < this.extraButtons.length) {
            Object buttonAdvisor = buttonAdvisors[i];
            this.extraButtons[i] = new ImageButton(this, buttonAdvisor.getHoverImage(), buttonAdvisor.getGrayImage());
            this.extraButtons[i].setLayoutData(GridDataFactory.fillDefaults().align(1, 0x1000008).create());
            this.extraButtons[i].setSelectionMode(ImageButton.SelectionMode.MouseDown);
            this.extraButtons[i].setSelectionRunnable((Runnable)buttonAdvisor);
            this.extraButtons[i].setToolTipText(buttonAdvisor.getToolTipText());
            buttonAdvisor.customize(this.extraButtons[i]);
            ++i;
        }
        this.modeButton = new ImageButton(this, OM.getImage("icons/preview_entry.png"));
        this.modeButton.setLayoutData(GridDataFactory.fillDefaults().align(1, 0x1000008).create());
        this.modeButton.setSelectionMode(ImageButton.SelectionMode.MouseDown);
        this.modeButton.setSelectionRunnable(() -> this.setPreviewMode(!this.isPreviewMode()));
        this.mode.updateButtons();
        this.control = this.createControl(this.mode);
        this.initialEntry = this.entry = StringUtil.safe((String)this.mode.getEntryFromControl());
        this.empty = StringUtil.isEmpty((String)this.entry);
        this.mode.updateModeButtonVisibility();
    }

    public Control getControl() {
        return this.control;
    }

    public String getEntry() {
        return this.entry;
    }

    public void setEntry(String entry) {
        if (!Objects.equals(entry = StringUtil.safe((String)entry), this.entry)) {
            this.mode.setEntryToControl(entry);
            this.entry = entry;
        }
        this.setEmpty(StringUtil.isEmpty((String)entry));
        this.resetDirty();
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void resetDirty() {
        this.initialEntry = this.entry;
        this.setDirty(false);
    }

    public boolean isPreviewMode() {
        return this.mode instanceof PreviewMode;
    }

    public void setPreviewMode(boolean previewMode) {
        if (this.config.getPreviewProvider() == null || previewMode == this.isPreviewMode()) {
            return;
        }
        this.mode = this.mode.toggleMode();
        this.mode.updateButtons();
        this.control.setFocus();
        this.updateControlVerticalBar(this.lastControlHeight);
        this.layoutParent();
        this.redraw();
        Consumer<EntryField> previewModeHandler = this.config.getPreviewModeHandler();
        if (previewModeHandler != null) {
            previewModeHandler.accept(this);
        }
    }

    public boolean isExtraButtonVisible(int index) {
        return this.extraButtons[index].isVisible();
    }

    public void setExtraButtonVisible(int index, boolean visible) {
        if (visible != this.isExtraButtonVisible(index)) {
            GridData gridData = (GridData)this.extraButtons[index].getLayoutData();
            gridData.exclude = !visible;
            this.extraButtons[index].setVisible(visible);
            this.layout(true);
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        if (wHint <= 1) {
            return new Point(0, 0);
        }
        if (hHint == -1) {
            hHint = this.mode.computeControlHeight(wHint);
            hHint = Math.max(hHint, 15);
            hHint = Math.min(hHint, 120);
        }
        return new Point(wHint + 18, hHint + 18);
    }

    public boolean setFocus() {
        return this.control.setFocus();
    }

    private Control createControl(Mode mode) {
        if (this.control != null) {
            this.control.dispose();
        }
        Control control = mode.doCreateControl();
        control.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        control.setBackground(this.config.getEntryBackground());
        ImageButton firstButton = this.modeButton;
        if (this.extraButtons.length != 0) {
            firstButton = this.extraButtons[0];
        }
        control.moveAbove((Control)firstButton);
        return control;
    }

    private EntryControlAdvisor.ControlConfig interceptModifyHandler(EntryControlAdvisor.ControlConfig entryControlConfig) {
        EntryControlAdvisor.ControlConfig config = new EntryControlAdvisor.ControlConfig(entryControlConfig);
        Consumer<Control> originalModifyHandler = config.getModifyHandler();
        config.setModifyHandler(control -> {
            String newEntry = StringUtil.safe((String)this.mode.getEntryFromControl());
            if (!newEntry.equals(this.entry)) {
                this.entry = newEntry;
                Point oldSize = this.getSize();
                Point newSize = this.computeSize(oldSize.x, -1, false);
                if (newSize.y != oldSize.y) {
                    this.layoutParent();
                }
                this.updateControlVerticalBar(this.lastControlHeight);
                if (originalModifyHandler != null) {
                    originalModifyHandler.accept((Control)control);
                }
                this.setEmpty(StringUtil.isEmpty((String)newEntry));
                this.setDirty(!Objects.equals(newEntry, this.initialEntry));
            }
        });
        return config;
    }

    private void setEmpty(boolean empty) {
        if (empty != this.empty) {
            this.empty = empty;
            this.mode.updateModeButtonVisibility();
            Consumer<EntryField> emptyHandler = this.config.getEmptyHandler();
            if (emptyHandler != null) {
                emptyHandler.accept(this);
            }
        }
    }

    private void setDirty(boolean dirty) {
        if (dirty != this.dirty) {
            this.dirty = dirty;
            Consumer<EntryField> dirtyHandler = this.config.getDirtyHandler();
            if (dirtyHandler != null) {
                dirtyHandler.accept(this);
            }
        }
    }

    private void updateControlVerticalBar(int controlHeight) {
        ScrollBar verticalBar;
        if (this.mode instanceof EditMode && this.control instanceof Scrollable && (verticalBar = ((Scrollable)this.control).getVerticalBar()) != null) {
            verticalBar.setVisible(controlHeight > 120);
        }
    }

    private void layoutParent() {
        this.requestLayout();
        this.getParent().requestLayout();
    }

    public static interface ButtonAdvisor
    extends Runnable {
        public String getToolTipText();

        public Image getHoverImage();

        default public Image getGrayImage() {
            return null;
        }

        default public void customize(ImageButton button) {
        }
    }

    private final class EditMode
    implements Mode {
        @Override
        public void paintRoundBackground(GC gc, Rectangle box) {
            gc.setBackground(EntryField.this.config.getEntryBackground());
            gc.fillRoundRectangle(box.x, box.y, box.width - 1, box.height - 1, 36, 36);
        }

        @Override
        public Control doCreateControl() {
            String emptyHint;
            ScrollBar verticalBar;
            Control control = EntryField.this.config.getEntryControlAdvisor().createControl(EntryField.this, EntryField.this.config.getEntryControlConfig());
            if (control instanceof Scrollable && (verticalBar = ((Scrollable)control).getVerticalBar()) != null) {
                verticalBar.setVisible(false);
            }
            if (!StringUtil.isEmpty((String)(emptyHint = EntryField.this.config.getEmptyHint()))) {
                control.addPaintListener(e -> {
                    if (StringUtil.isEmpty((String)EntryField.this.entry)) {
                        e.gc.setForeground(EntryField.this.getDisplay().getSystemColor(16));
                        e.gc.drawText(emptyHint, 3, 0);
                    }
                });
            }
            return control;
        }

        @Override
        public int computeControlHeight(int wHint) {
            EntryField.this.lastControlHeight = EntryField.this.control.computeSize((int)wHint, (int)-1).y;
            return EntryField.this.lastControlHeight;
        }

        @Override
        public String getEntryFromControl() {
            return EntryField.this.config.getEntryControlAdvisor().getEntry(EntryField.this.control);
        }

        @Override
        public void setEntryToControl(String entry) {
            EntryField.this.config.getEntryControlAdvisor().setEntry(EntryField.this.control, entry);
        }

        @Override
        public void updateModeButtonVisibility() {
            EntryField.this.modeButton.setVisible(!EntryField.this.empty);
        }

        @Override
        public void updateButtons() {
            Color background = EntryField.this.config.getEntryBackground();
            int i = 0;
            while (i < EntryField.this.extraButtons.length) {
                EntryField.this.extraButtons[i].setBackground(background);
                ++i;
            }
            EntryField.this.modeButton.setHoverImage(OM.getImage("icons/preview_entry.png"));
            EntryField.this.modeButton.setToolTipText(TOOLTIP_PREVIEW);
            EntryField.this.modeButton.setBackground(background);
        }

        @Override
        public Mode toggleMode() {
            String entry = EntryField.this.getEntry();
            PreviewMode previewMode = new PreviewMode();
            EntryField.this.control = EntryField.this.createControl(previewMode);
            previewMode.setEntryToControl(entry);
            return previewMode;
        }
    }

    public static final class FieldConfig {
        private Color entryBackground;
        private EntryControlAdvisor entryControlAdvisor;
        private EntryControlAdvisor.ControlConfig entryControlConfig;
        private String emptyHint;
        private UnaryOperator<String> previewProvider;
        private boolean initialPreviewMode;
        private ButtonAdvisor[] extraButtonAdvisors;
        private Consumer<EntryField> emptyHandler;
        private Consumer<EntryField> dirtyHandler;
        private Consumer<EntryField> previewModeHandler;

        public FieldConfig() {
        }

        public FieldConfig(FieldConfig source) {
            this.entryBackground = source.entryBackground;
            this.entryControlAdvisor = source.entryControlAdvisor;
            this.entryControlConfig = new EntryControlAdvisor.ControlConfig(source.entryControlConfig);
            this.emptyHint = source.emptyHint;
            this.previewProvider = source.previewProvider;
            this.initialPreviewMode = source.initialPreviewMode;
            this.extraButtonAdvisors = source.extraButtonAdvisors == null ? null : Arrays.copyOf(source.extraButtonAdvisors, source.extraButtonAdvisors.length);
            this.emptyHandler = source.emptyHandler;
            this.dirtyHandler = source.dirtyHandler;
            this.previewModeHandler = source.previewModeHandler;
        }

        public Color getEntryBackground() {
            return this.entryBackground;
        }

        public void setEntryBackground(Color entryBackground) {
            this.entryBackground = entryBackground;
        }

        public EntryControlAdvisor getEntryControlAdvisor() {
            return this.entryControlAdvisor;
        }

        public void setEntryControlAdvisor(EntryControlAdvisor entryControlAdvisor) {
            this.entryControlAdvisor = entryControlAdvisor;
        }

        public EntryControlAdvisor.ControlConfig getEntryControlConfig() {
            return this.entryControlConfig;
        }

        public void setEntryControlConfig(EntryControlAdvisor.ControlConfig entryControlConfig) {
            this.entryControlConfig = entryControlConfig;
        }

        public String getEmptyHint() {
            return this.emptyHint;
        }

        public void setEmptyHint(String emptyHint) {
            this.emptyHint = emptyHint;
        }

        public UnaryOperator<String> getPreviewProvider() {
            return this.previewProvider;
        }

        public void setPreviewProvider(UnaryOperator<String> previewProvider) {
            this.previewProvider = previewProvider;
        }

        public boolean isInitialPreviewMode() {
            return this.initialPreviewMode;
        }

        public void setInitialPreviewMode(boolean initialPreviewMode) {
            this.initialPreviewMode = initialPreviewMode;
        }

        public ButtonAdvisor[] getExtraButtonAdvisors() {
            return this.extraButtonAdvisors;
        }

        public void setExtraButtonAdvisors(ButtonAdvisor ... extraButtonAdvisors) {
            this.extraButtonAdvisors = extraButtonAdvisors;
        }

        public Consumer<EntryField> getEmptyHandler() {
            return this.emptyHandler;
        }

        public void setEmptyHandler(Consumer<EntryField> emptyHandler) {
            this.emptyHandler = emptyHandler;
        }

        public Consumer<EntryField> getDirtyHandler() {
            return this.dirtyHandler;
        }

        public void setDirtyHandler(Consumer<EntryField> dirtyHandler) {
            this.dirtyHandler = dirtyHandler;
        }

        public Consumer<EntryField> getPreviewModeHandler() {
            return this.previewModeHandler;
        }

        public void setPreviewModeHandler(Consumer<EntryField> previewModeHandler) {
            this.previewModeHandler = previewModeHandler;
        }
    }

    private static interface Mode {
        public void paintRoundBackground(GC var1, Rectangle var2);

        public Control doCreateControl();

        public int computeControlHeight(int var1);

        public String getEntryFromControl();

        public void setEntryToControl(String var1);

        public void updateModeButtonVisibility();

        public void updateButtons();

        public Mode toggleMode();
    }

    private final class PreviewMode
    implements Mode {
        private int wHint = -1;
        private int controlHeight = 10;
        private String controlEntry;

        @Override
        public void paintRoundBackground(GC gc, Rectangle box) {
            gc.setBackground(EntryField.this.whiteColor);
            gc.setForeground(EntryField.this.config.getEntryBackground());
            gc.drawRoundRectangle(box.x, box.y, box.width - 1, box.height - 1, 36, 36);
        }

        @Override
        public Control doCreateControl() {
            SafeBrowser browser = UIUtil.createBrowser(EntryField.this);
            browser.addProgressListener(ProgressListener.completedAdapter(event -> {
                if (EntryField.this.mode != this) {
                    return;
                }
                int width = Math.max(this.wHint, 10);
                browser.setSize(width, 10);
                this.controlHeight = ((Double)browser.evaluate("return document.body.scrollHeight;")).intValue();
                EntryField.this.layoutParent();
            }));
            return browser;
        }

        @Override
        public int computeControlHeight(int wHint) {
            this.wHint = wHint;
            return this.controlHeight;
        }

        @Override
        public String getEntryFromControl() {
            return this.controlEntry;
        }

        @Override
        public void setEntryToControl(String entry) {
            this.controlEntry = entry;
            String html = (String)EntryField.this.config.getPreviewProvider().apply(entry);
            Browser browser = (Browser)EntryField.this.control;
            browser.setText(html, true);
            browser.setVisible(!StringUtil.isEmpty((String)html.trim()));
        }

        @Override
        public void updateModeButtonVisibility() {
            EntryField.this.modeButton.setVisible(true);
        }

        @Override
        public void updateButtons() {
            int i = 0;
            while (i < EntryField.this.extraButtons.length) {
                EntryField.this.extraButtons[i].setBackground(EntryField.this.whiteColor);
                ++i;
            }
            EntryField.this.modeButton.setHoverImage(OM.getImage("icons/edit_entry.png"));
            EntryField.this.modeButton.setToolTipText(TOOLTIP_EDIT);
            EntryField.this.modeButton.setBackground(EntryField.this.whiteColor);
        }

        @Override
        public Mode toggleMode() {
            String entry = EntryField.this.getEntry();
            EditMode editMode = new EditMode();
            EntryField.this.control = EntryField.this.createControl(editMode);
            editMode.setEntryToControl(entry);
            return editMode;
        }
    }
}

