/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.ui.viewsupport;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.m2m.atl.adt.ui.AtlUIPlugin;
import org.eclipse.m2m.atl.adt.ui.editor.AtlEditor;
import org.eclipse.m2m.atl.adt.ui.viewsupport.IProblemChangedListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;

public class AtlEditorTickErrorUpdater
implements IProblemChangedListener {
    private static final String ATL_EDITOR_ERROR = "atl_file_error.gif";
    private static final String ATL_EDITOR_WARNING = "atl_file_warning.gif";
    private static final String ATL_EDITOR = "atl_file.gif";
    private AtlEditor atlEditor;
    private Map<ImageDescriptor, Image> imageCache = new HashMap<ImageDescriptor, Image>();

    public AtlEditorTickErrorUpdater(AtlEditor editor) {
        this.atlEditor = editor;
        AtlUIPlugin.getDefault().getProblemMarkerManager().addListener(this);
    }

    @Override
    public void problemsChanged(IResource[] changedResources, boolean isMarkerChange) {
        IResource resource = this.atlEditor.getUnderlyingResource();
        if (resource != null && resource.isAccessible()) {
            int i = 0;
            while (i < changedResources.length) {
                if (changedResources[i].equals((Object)resource)) {
                    this.updateEditorImage(resource);
                }
                ++i;
            }
        }
    }

    private int computeHighestServityFlag(IResource res) {
        IMarker[] pbmMarkers = null;
        try {
            pbmMarkers = res.findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
        }
        catch (CoreException e) {
            System.err.println((Object)e);
        }
        int severity = -1;
        if (pbmMarkers != null) {
            int i = 0;
            while (i < pbmMarkers.length) {
                IMarker curr = pbmMarkers[i];
                severity = curr.getAttribute("severity", -1);
                if (severity == 2) {
                    return 2;
                }
                ++i;
            }
        }
        return severity;
    }

    public void updateEditorImage(IResource res) {
        if (res == null) {
            return;
        }
        Image titleImage = this.atlEditor.getTitleImage();
        if (titleImage == null) {
            return;
        }
        Image newImage = this.getImage(res);
        if (newImage != null && titleImage != newImage) {
            this.postImageChange(newImage);
        }
    }

    private Image getImage(IResource res) {
        int flag = this.computeHighestServityFlag(res);
        ImageDescriptor imgDesc = null;
        switch (flag) {
            case 2: {
                imgDesc = AtlUIPlugin.getImageDescriptor(ATL_EDITOR_ERROR);
                break;
            }
            case 1: {
                imgDesc = AtlUIPlugin.getImageDescriptor(ATL_EDITOR_WARNING);
                break;
            }
            default: {
                imgDesc = AtlUIPlugin.getImageDescriptor(ATL_EDITOR);
            }
        }
        if (imgDesc == null) {
            return null;
        }
        Image img = this.imageCache.get(imgDesc);
        if (img == null) {
            img = imgDesc.createImage();
            this.imageCache.put(imgDesc, img);
        }
        return img;
    }

    private void postImageChange(final Image newImage) {
        Shell shell = this.atlEditor.getEditorSite().getShell();
        if (shell != null && !shell.isDisposed()) {
            shell.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    AtlEditorTickErrorUpdater.this.atlEditor.updateTitleImage(newImage);
                }
            });
        }
    }

    public void dispose() {
        Iterator<Image> images = this.imageCache.values().iterator();
        while (images.hasNext()) {
            images.next().dispose();
        }
        this.imageCache.clear();
        AtlUIPlugin.getDefault().getProblemMarkerManager().removeListener(this);
    }
}

