/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.ui.text.atl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.NumberRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WordPatternRule;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.m2m.atl.adt.ui.text.AbstractScanner;
import org.eclipse.m2m.atl.adt.ui.text.AtlTextTools;
import org.eclipse.m2m.atl.adt.ui.text.AtlWordDetector;
import org.eclipse.m2m.atl.common.IAtlLexems;

public class AtlCodeScanner
extends AbstractScanner {
    public AtlCodeScanner(AtlTextTools textTools) {
        super(textTools);
    }

    @Override
    public void adaptToPreferenceChange(PropertyChangeEvent event) {
        if (super.affectsBehavior(event)) {
            super.adaptToPreferenceChange(event);
        }
    }

    @Override
    public boolean affectsBehavior(PropertyChangeEvent event) {
        return super.affectsBehavior(event);
    }

    @Override
    protected List<IRule> createRules() {
        ArrayList<IRule> rules = new ArrayList<IRule>();
        rules.add((IRule)new EndOfLineRule("---", (IToken)this.getToken("Atl.Syntax.SingleLineSpecialComment.Color")));
        rules.add((IRule)new EndOfLineRule("--", (IToken)this.getToken("Atl.Syntax.SingleLineComment.Color")));
        rules.add(new EnumLiteralRule(this.getToken("Atl.Syntax.Literal.Color")));
        rules.add((IRule)new MultiLineRule("'", "'", (IToken)this.getToken("Atl.Syntax.String.Color"), '\\'));
        rules.add((IRule)new MultiLineRule("\"", "\"", (IToken)this.getToken("Atl.Syntax.Identifier.Color"), '\\'));
        rules.add((IRule)new NumberRule((IToken)this.getToken("Atl.Syntax.Number.Color")));
        rules.add(new SymbolRule(IAtlLexems.BRACKETS, this.getToken("Atl.Syntax.Bracket.Color")));
        rules.add(new SymbolRule(IAtlLexems.OPERATORS, this.getToken("Atl.Syntax.Operator.Color")));
        rules.add(new SymbolRule(IAtlLexems.SYMBOLS, this.getToken("Atl.Syntax.Symbol.Color")));
        WordRule wordRule = new WordRule((IWordDetector)new AtlWordDetector(), (IToken)this.getToken("Atl.Syntax.Default.Color"));
        int i = 0;
        while (i < IAtlLexems.CONSTANTS.length) {
            wordRule.addWord(IAtlLexems.CONSTANTS[i], (IToken)this.getToken("Atl.Syntax.Constant.Color"));
            ++i;
        }
        i = 0;
        while (i < IAtlLexems.KEYWORDS.length) {
            wordRule.addWord(IAtlLexems.KEYWORDS[i], (IToken)this.getToken("Atl.Syntax.Keyword.Color"));
            ++i;
        }
        i = 0;
        while (i < IAtlLexems.TYPES.length) {
            wordRule.addWord(IAtlLexems.TYPES[i], (IToken)this.getToken("Atl.Syntax.Type.Color"));
            ++i;
        }
        i = 0;
        while (i < IAtlLexems.ABSTRACT_TYPES.length) {
            wordRule.addWord(IAtlLexems.ABSTRACT_TYPES[i], (IToken)this.getToken("Atl.Syntax.AbstractType.Color"));
            ++i;
        }
        i = 0;
        while (i < IAtlLexems.CONTEXT_KEYWORDS.length) {
            wordRule.addWord(IAtlLexems.CONTEXT_KEYWORDS[i], (IToken)this.getToken("Atl.Syntax.ContextKeyword.Color"));
            ++i;
        }
        rules.add((IRule)wordRule);
        rules.add((IRule)new WordPatternRule((IWordDetector)new AtlWordDetector(), "\"", "\"", (IToken)this.getToken("Atl.Syntax.Identifier.Color")));
        return rules;
    }

    @Override
    protected String[] getPropertyNames() {
        return new String[]{"Atl.Syntax.Bracket", "Atl.Syntax.Constant", "Atl.Syntax.Default", "Atl.Syntax.Identifier", "Atl.Syntax.Keyword", "Atl.Syntax.BoldKeyword", "Atl.Syntax.ContextKeyword", "Atl.Syntax.Literal", "Atl.Syntax.Number", "Atl.Syntax.Operator", "Atl.Syntax.SingleLineComment", "Atl.Syntax.SingleLineSpecialComment", "Atl.Syntax.String", "Atl.Syntax.Symbol", "Atl.Syntax.Type", "Atl.Syntax.AbstractType"};
    }

    public class EnumLiteralRule
    implements IRule {
        private final IToken token;

        public EnumLiteralRule(Token token) {
            this.token = token;
        }

        public IToken evaluate(ICharacterScanner scanner) {
            int character = scanner.read();
            if ((char)character == '#') {
                character = scanner.read();
                while (Character.isLetterOrDigit((char)(character = scanner.read())) || (char)character == '_') {
                }
                scanner.unread();
                return this.token;
            }
            scanner.unread();
            return Token.UNDEFINED;
        }
    }

    public class IdentifierRule
    implements IRule {
        private final Token token;

        public IdentifierRule(Token token) {
            this.token = token;
        }

        public IToken evaluate(ICharacterScanner scanner) {
            int character = scanner.read();
            if ((char)character == '\"') {
                this.evaluateSimpleName(scanner);
                scanner.unread();
                if ((char)character == '\"') {
                    return this.token;
                }
            } else if (Character.isLetter((char)character) || (char)character == '_') {
                this.evaluateSimpleName(scanner);
                scanner.unread();
                return this.token;
            }
            scanner.unread();
            return Token.UNDEFINED;
        }

        private void evaluateSimpleName(ICharacterScanner scanner) {
            int character = scanner.read();
            while (Character.isLetterOrDigit((char)(character = scanner.read())) || (char)character == '_') {
            }
        }
    }

    protected class SymbolRule
    implements IRule {
        private final IToken token;
        private final String[] list;

        public SymbolRule(String[] list, Token token) {
            this.list = list;
            this.token = token;
        }

        public IToken evaluate(ICharacterScanner scanner) {
            int character = scanner.read();
            if (this.isInList((char)character)) {
                while (this.isInList((char)(character = scanner.read()))) {
                }
                scanner.unread();
                return this.token;
            }
            scanner.unread();
            return Token.UNDEFINED;
        }

        public boolean isInList(char character) {
            int i = 0;
            while (i < this.list.length) {
                if (this.list[i].equals(Character.toString(character))) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }
}

