/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.axis2.creation.core.command;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.ws.axis2.consumption.core.utils.ContentCopyUtils;
import org.eclipse.jst.ws.axis2.core.utils.FacetContainerUtils;
import org.eclipse.jst.ws.axis2.core.utils.FileUtils;
import org.eclipse.jst.ws.axis2.creation.core.data.DataModel;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.environment.IStatusHandler;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

public class Axis2WebservicesServerCommand
extends AbstractDataModelOperation {
    private DataModel model;
    private int scenario;

    public Axis2WebservicesServerCommand(DataModel model, int scenario) {
        this.model = model;
        this.scenario = scenario;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IStatus status = Status.OK_STATUS;
        IEnvironment environment = this.getEnvironment();
        IStatusHandler statusHandler = environment.getStatusHandler();
        ContentCopyUtils contentCopyUtils = new ContentCopyUtils(this.getEnvironment());
        if (this.model.getServerStatus()) {
            if (this.scenario == 0 || this.scenario == 1) {
                String webContainerDirString = FacetContainerUtils.pathToWebProjectContainer((String)this.model.getWebProjectName());
                String repositoryString = FacetContainerUtils.getAxis2WebContainerRepositoryPath((String)webContainerDirString);
                String webserviceTempDirString = this.model.getPathToWebServicesTempDir();
                status = contentCopyUtils.copyDirectoryRecursivelyIntoWorkspace(webserviceTempDirString, repositoryString, monitor, statusHandler);
                FileUtils.deleteDirectories((String)webserviceTempDirString);
            }
            status = Status.OK_STATUS;
        } else {
            status = Status.CANCEL_STATUS;
        }
        return status;
    }
}

