/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples;

public class SQLDataTypes {
    public static final String BINARY = "binary";
    public static final String BIT = "bit";
    public static final String BIGINT = "bigint";
    public static final String CHAR = "char";
    public static final String CHARACTER = "character";
    public static final String CHARACTER_VARYING = "character varying";
    public static final String DATE = "date";
    public static final String DATETIME = "datetime";
    public static final String DECIMAL = "decimal";
    public static final String DOUBLE = "double";
    public static final String DOUBLE_PRECISION = "double precision";
    public static final String FLOAT = "float";
    public static final String IMAGE = "image";
    public static final String INT = "int";
    public static final String INTEGER = "integer";
    public static final String LONG_VARCHAR = "long varchar";
    public static final String LONG_BINARY = "long binary";
    public static final String LONG_VARBINARY = "long varbinary";
    public static final String LONGSYSNAME = "longsysname";
    public static final String MONEY = "money";
    public static final String NUMERIC = "numeric";
    public static final String NCHAR = "nchar";
    public static final String NATIONAL_CHARACTER = "national character";
    public static final String NATIONAL_CHAR = "national char";
    public static final String NVARCHAR = "nvarchar";
    public static final String REAL = "real";
    public static final String SMALLDATETIME = "smalldatetime";
    public static final String SMALLMONEY = "smallmoney";
    public static final String SYSNAME = "sysname";
    public static final String SMALLINT = "smallint";
    public static final String TIME = "time";
    public static final String TIMESTAMP = "timestamp";
    public static final String TEXT = "text";
    public static final String TINYINT = "tinyint";
    public static final String UNICHAR = "unichar";
    public static final String UNITEXT = "unitext";
    public static final String UNIVARCHAR = "univarchar";
    public static final String UNSIGNED_SMALLINT = "unsigned smallint";
    public static final String UNSIGNED_INT = "unsigned int";
    public static final String UNSIGNED_BIGINT = "unsigned bigint";
    public static final String UNSIGNED_INTEGER = "unsigned integer";
    public static final String UNIQUEIDENTIFIER = "uniqueidentifier";
    public static final String UNIQUEIDENTIFIERSTR = "uniqueidentifierstr";
    public static final String VARBINARY = "varbinary";
    public static final String VARCHAR = "varchar";
    public static final String XML = "xml";
    public static final String JAVA_LANG_OBJECT = "java.lang.object";
    public static final String JAVA_SERIALIZARION = "java serialization";

    public static int convert2SQLType(String typeName) {
        if (typeName == null) {
            return 0;
        }
        String name = typeName.toLowerCase();
        if (name.equals(BIGINT) || name.equals(UNSIGNED_BIGINT)) {
            return -5;
        }
        if (name.equals(BINARY) || name.equals(UNIQUEIDENTIFIER)) {
            return -2;
        }
        if (name.equals(BIT)) {
            return -7;
        }
        if (name.equals("BLOB")) {
            return 2004;
        }
        if (name.equals("BOOLEAN") || name.equals("BOOL")) {
            return 16;
        }
        if (name.equals(CHAR) || name.equals(CHARACTER) || name.equals(NCHAR) || name.equals(NATIONAL_CHARACTER) || name.equals(NATIONAL_CHAR) || name.equals(UNICHAR) || name.equals(UNIQUEIDENTIFIERSTR)) {
            return 1;
        }
        if (name.equals("CLOB")) {
            return 2005;
        }
        if (name.equals("DATALINK")) {
            return 70;
        }
        if (name.equals(DATE)) {
            return 91;
        }
        if (name.equals(DECIMAL) || name.equals("DEC") || name.equals(MONEY) || name.equals(SMALLMONEY)) {
            return 3;
        }
        if (name.equals("DISTINCT")) {
            return 2001;
        }
        if (name.equals(DOUBLE) || name.equals(DOUBLE_PRECISION)) {
            return 8;
        }
        if (name.equals(FLOAT)) {
            return 6;
        }
        if (name.equals(INTEGER) || name.equals(INT) || name.equals(UNSIGNED_INTEGER) || name.equals(UNSIGNED_INT) || name.equals(UNSIGNED_SMALLINT)) {
            return 4;
        }
        if (name.equals(JAVA_LANG_OBJECT)) {
            return 2000;
        }
        if (name.equals(LONG_VARBINARY) || name.equals(IMAGE) || name.equals(XML)) {
            return -4;
        }
        if (name.equals(LONG_VARCHAR) || name.equals(TEXT) || name.equals(UNITEXT)) {
            return -1;
        }
        if (name.equals("NULL")) {
            return 0;
        }
        if (name.equals(NUMERIC)) {
            return 2;
        }
        if (name.equals("OTHER")) {
            return 1111;
        }
        if (name.equals(REAL)) {
            return 7;
        }
        if (name.equals("REF")) {
            return 2006;
        }
        if (name.equals(SMALLINT)) {
            return 5;
        }
        if (name.equals("STRUCT")) {
            return 2002;
        }
        if (name.equals(TIME)) {
            return 92;
        }
        if (name.equals(TIMESTAMP) || name.equals(DATETIME) || name.equals(SMALLDATETIME)) {
            return 93;
        }
        if (name.equals(TINYINT)) {
            return -6;
        }
        if (name.equals(LONG_BINARY) || name.equals(LONG_VARBINARY)) {
            return -4;
        }
        if (name.equals(VARBINARY)) {
            return -3;
        }
        if (name.equals(SYSNAME) || name.equals(VARCHAR) || name.equals(NVARCHAR) || name.equals(UNIVARCHAR) || name.indexOf("CHAR") > 0 && name.indexOf("VARYING") > 0) {
            return 12;
        }
        return 1111;
    }
}

