/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.lsp.clangd.internal.ui;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.eclipse.cdt.lsp.clangd.ClangdMetadata;
import org.eclipse.cdt.lsp.clangd.ClangdOptions;
import org.eclipse.cdt.lsp.clangd.internal.ui.LspEditorUiMessages;
import org.eclipse.cdt.lsp.ui.ConfigurationArea;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.OsgiPreferenceMetadataStore;
import org.eclipse.core.runtime.preferences.PreferenceMetadata;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public final class ClangdConfigurationArea
extends ConfigurationArea {
    private final Text path;
    private final Button tidy;
    private final Combo completion;
    private final Button index;
    private final Button pretty;
    private final Text driver;
    private final Text additional;
    private final Group group;
    private ControlEnableState enableState;
    private final Map<PreferenceMetadata<String>, Text> texts = new HashMap<PreferenceMetadata<String>, Text>();
    private final Map<PreferenceMetadata<String>, Combo> combos = new HashMap<PreferenceMetadata<String>, Combo>();
    private static final String[] completionOptions = new String[]{"detailed", "bundled", ""};
    private static final String[] completionsKeys = new String[]{LspEditorUiMessages.LspEditorPreferencePage_completion_detailed, LspEditorUiMessages.LspEditorPreferencePage_completion_bundled, LspEditorUiMessages.LspEditorPreferencePage_completion_default};
    private final Map<String, String> completions = new HashMap<String, String>();

    public ClangdConfigurationArea(Composite parent, ClangdMetadata metadata, boolean isProjectScope) {
        super(3);
        int i = 0;
        while (i < completionsKeys.length) {
            this.completions.put(completionsKeys[i], completionOptions[i]);
            ++i;
        }
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(768));
        composite.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(this.columns).create());
        this.group = this.createGroup(composite, LspEditorUiMessages.LspEditorPreferencePage_clangd_options_label, 3);
        this.path = this.createFileSelector(metadata.clangdPath(), (Composite)this.group, this::selectClangdExecutable);
        this.tidy = this.createButton(metadata.useTidy(), (Composite)this.group, 32, 0);
        this.index = this.createButton(metadata.useBackgroundIndex(), (Composite)this.group, 32, 0);
        this.completion = this.createCombo(metadata.completionStyle(), (Composite)this.group, completionsKeys);
        this.pretty = this.createButton(metadata.prettyPrint(), (Composite)this.group, 32, 0);
        this.driver = this.createText(metadata.queryDriver(), (Composite)this.group, false);
        this.additional = this.createText(metadata.additionalOptions(), (Composite)this.group, true);
    }

    void enablePreferenceContent(boolean enable) {
        this.enableClangdOptionsGroup(enable);
    }

    private void enableClangdOptionsGroup(boolean enable) {
        if (this.enableState != null) {
            this.enableState.restore();
        }
        this.enableState = enable ? null : ControlEnableState.disable((Control)this.group);
    }

    private Text createFileSelector(PreferenceMetadata<String> meta, Composite composite, Consumer<SelectionEvent> selector) {
        Label label = new Label(composite, 0);
        label.setText(meta.name());
        label.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        Text text = new Text(composite, 2048);
        text.setToolTipText(meta.description());
        text.setData(meta);
        this.texts.put(meta, text);
        text.addKeyListener(KeyListener.keyReleasedAdapter(arg_0 -> ((ClangdConfigurationArea)this).changed(arg_0)));
        text.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).span(this.columns - 2, 1).create());
        Button button = new Button(composite, 0);
        button.setText(LspEditorUiMessages.LspEditorPreferencePage_browse_button);
        button.setLayoutData((Object)new GridData());
        button.addSelectionListener(SelectionListener.widgetSelectedAdapter(selector));
        return text;
    }

    private Text createText(PreferenceMetadata<String> meta, Composite composite, boolean multiLine) {
        Label label = new Label(composite, 0);
        label.setText(meta.name());
        label.setLayoutData((Object)GridDataFactory.fillDefaults().align(4, 0x1000000).create());
        Text text = new Text(composite, multiLine ? 2626 : 2048);
        text.setToolTipText(meta.description());
        text.setData(meta);
        text.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).span(this.columns - 1, 1).hint(-1, multiLine ? 3 * text.getLineHeight() : -1).create());
        this.texts.put(meta, text);
        text.addKeyListener(KeyListener.keyReleasedAdapter(arg_0 -> ((ClangdConfigurationArea)this).changed(arg_0)));
        return text;
    }

    private Combo createCombo(PreferenceMetadata<String> meta, Composite parent, String[] items) {
        Label label = new Label(parent, 0);
        label.setText(meta.name());
        label.setToolTipText(meta.description());
        label.setLayoutData((Object)GridDataFactory.fillDefaults().align(4, 0x1000000).create());
        Combo combo = new Combo(parent, 8);
        combo.setLayoutData((Object)new GridData(32));
        combo.setItems(items);
        combo.setData(meta);
        this.combos.put(meta, combo);
        return combo;
    }

    private void selectClangdExecutable(SelectionEvent e) {
        String selected = this.selectFile(this.path.getText());
        if (selected != null) {
            this.path.setText(selected);
            this.changed((TypedEvent)e);
        }
    }

    private String selectFile(String path) {
        FileDialog dialog = new FileDialog(Display.getCurrent().getActiveShell(), 8192);
        dialog.setText(LspEditorUiMessages.LspEditorPreferencePage_select_clangd_executable);
        File file = new File(path);
        if (file.isFile()) {
            dialog.setFilterPath(file.getParent());
        }
        return dialog.open();
    }

    /*
     * WARNING - void declaration
     */
    public void load(Object options, boolean enable) {
        Object object = options;
        if (object instanceof ClangdOptions) {
            void clangdOptions;
            ClangdOptions clangdOptions2 = (ClangdOptions)object;
            ClangdOptions cfr_ignored_0 = (ClangdOptions)object;
            this.path.setText(clangdOptions.clangdPath());
            this.tidy.setSelection(clangdOptions.useTidy());
            this.index.setSelection(clangdOptions.useBackgroundIndex());
            int i = 0;
            while (i < completionOptions.length) {
                if (completionOptions[i].equals(clangdOptions.completionStyle())) {
                    this.completion.select(i);
                }
                ++i;
            }
            this.pretty.setSelection(clangdOptions.prettyPrint());
            this.driver.setText(clangdOptions.queryDriver());
            this.additional.setText(clangdOptions.additionalOptions().stream().collect(Collectors.joining(System.lineSeparator())));
            this.enablePreferenceContent(enable);
        }
    }

    public void store(IEclipsePreferences prefs) {
        OsgiPreferenceMetadataStore store = new OsgiPreferenceMetadataStore(prefs);
        this.buttons.entrySet().forEach(e -> store.save((Object)((Button)e.getValue()).getSelection(), (PreferenceMetadata)e.getKey()));
        this.texts.entrySet().forEach(e -> store.save((Object)((Text)e.getValue()).getText(), (PreferenceMetadata)e.getKey()));
        this.combos.entrySet().forEach(e -> store.save((Object)this.completions.get(((Combo)e.getValue()).getText()), (PreferenceMetadata)e.getKey()));
    }

    public void dispose() {
        super.dispose();
        this.texts.clear();
        this.combos.clear();
    }

    public boolean optionsChanged(ClangdOptions options) {
        return !options.clangdPath().equals(this.path.getText()) || options.useTidy() != this.tidy.getSelection() || options.useBackgroundIndex() != this.index.getSelection() || !options.completionStyle().equals(this.completions.get(this.completion.getText())) || options.prettyPrint() != this.pretty.getSelection() || !options.queryDriver().equals(this.driver.getText()) || !options.additionalOptions().stream().collect(Collectors.joining(System.lineSeparator())).equals(this.additional.getText());
    }
}

