/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.tooling.ui.queryregistry.properties;

import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.viatra.query.runtime.registry.IQuerySpecificationRegistryEntry;
import org.eclipse.viatra.query.tooling.ui.queryregistry.properties.ParametersPropertySource;

public class IQuerySpecificationRegistryEntryPropertySource
implements IPropertySource {
    private static final String PROPERTY_FQN = "fqn";
    private static final String PROPERTY_PROJECT = "project";
    private static final String PROPERTY_SOURCE = "source";
    private static final String PROPERTY_PARAMETERS = "parameters";
    private final IQuerySpecificationRegistryEntry entry;

    public IQuerySpecificationRegistryEntryPropertySource(IQuerySpecificationRegistryEntry adaptableObject) {
        this.entry = adaptableObject;
    }

    public Object getEditableValue() {
        return this;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        String category = "Info";
        PropertyDescriptor fqnProperty = new PropertyDescriptor((Object)PROPERTY_FQN, "Fully qualified name");
        fqnProperty.setCategory(category);
        PropertyDescriptor sourceProperty = new PropertyDescriptor((Object)PROPERTY_SOURCE, "Source identifier");
        sourceProperty.setCategory(category);
        PropertyDescriptor projectProperty = new PropertyDescriptor((Object)PROPERTY_PROJECT, "Contributing project");
        projectProperty.setCategory(category);
        PropertyDescriptor parametersProperty = new PropertyDescriptor((Object)PROPERTY_PARAMETERS, "Parameters");
        parametersProperty.setCategory(category);
        return new IPropertyDescriptor[]{fqnProperty, sourceProperty, projectProperty, parametersProperty};
    }

    public Object getPropertyValue(Object id) {
        if (id.equals(PROPERTY_FQN)) {
            return this.entry.getFullyQualifiedName();
        }
        if (id.equals(PROPERTY_SOURCE)) {
            return this.entry.getSourceIdentifier();
        }
        if (id.equals(PROPERTY_PROJECT)) {
            return this.entry.getSourceProjectName();
        }
        if (id.equals(PROPERTY_PARAMETERS)) {
            return new ParametersPropertySource(this.entry);
        }
        return null;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }
}

