/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.events;

import org.eclipse.swt.widgets.Event;
import org.eclipse.swtchart.ICircularSeries;
import org.eclipse.swtchart.ISeries;
import org.eclipse.swtchart.extensions.core.BaseChart;
import org.eclipse.swtchart.extensions.core.ScrollableChart;
import org.eclipse.swtchart.extensions.events.AbstractHandledEventProcessor;
import org.eclipse.swtchart.extensions.events.IHandledEventProcessor;
import org.eclipse.swtchart.internal.series.CircularSeries;
import org.eclipse.swtchart.model.Node;

public class CircularMouseDownEvent
extends AbstractHandledEventProcessor
implements IHandledEventProcessor {
    private ScrollableChart scrollableChart;
    private boolean redrawOnClick = true;
    private boolean fillEntireSpace = false;

    public CircularMouseDownEvent(ScrollableChart scrollableChart) {
        this.scrollableChart = scrollableChart;
    }

    @Override
    public int getEvent() {
        return 3;
    }

    @Override
    public int getButton() {
        return 1;
    }

    @Override
    public int getStateMask() {
        return 0;
    }

    public void setRedrawOnClick(boolean redraw) {
        this.redrawOnClick = redraw;
    }

    public void setFillEntireSpace(boolean fillEntireSpace) {
        this.fillEntireSpace = fillEntireSpace;
    }

    @Override
    public void handleEvent(BaseChart baseChart, Event event) {
        ISeries[] iSeriesArray = baseChart.getSeriesSet().getSeries();
        int n = iSeriesArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISeries series = iSeriesArray[n2];
            if (series instanceof CircularSeries) {
                Node correspondingNode;
                ISeries linkedSeries;
                int n3;
                int n4;
                ISeries[] iSeriesArray2;
                String nodeId;
                double primaryValueX = baseChart.getSelectedPrimaryAxisValue(event.x, "X_AXIS");
                double primaryValueY = baseChart.getSelectedPrimaryAxisValue(event.y, "Y_AXIS");
                Node node = ((ICircularSeries)series).getPieSliceFromPosition(primaryValueX, primaryValueY);
                if (!this.redrawOnClick) {
                    ((CircularSeries)series).setHighlightedNode(node);
                    if (this.scrollableChart.getLinkedScrollableCharts().isEmpty()) break;
                    nodeId = null;
                    if (node != null) {
                        nodeId = node.getId();
                    }
                    for (ScrollableChart linkedChart : this.scrollableChart.getLinkedScrollableCharts()) {
                        iSeriesArray2 = linkedChart.getBaseChart().getSeriesSet().getSeries();
                        n4 = iSeriesArray2.length;
                        n3 = 0;
                        while (n3 < n4) {
                            linkedSeries = iSeriesArray2[n3];
                            if (linkedSeries instanceof CircularSeries) {
                                correspondingNode = ((CircularSeries)linkedSeries).getNodeById(nodeId);
                                ((CircularSeries)linkedSeries).setHighlightedNode(correspondingNode);
                            }
                            ++n3;
                        }
                    }
                    break;
                }
                if (node != null) {
                    if (((CircularSeries)series).getRootPointer() == node) {
                        if (!this.fillEntireSpace) {
                            ((CircularSeries)series).getModel().setRootPointer(node.getParent());
                        } else {
                            ((CircularSeries)series).setRootPointer(node.getParent());
                        }
                    } else if (!this.fillEntireSpace) {
                        ((CircularSeries)series).getModel().setRootPointer(node);
                    } else {
                        ((CircularSeries)series).setRootPointer(node);
                    }
                } else {
                    ((CircularSeries)series).setRootPointer(((CircularSeries)series).getRootNode());
                }
                if (!this.scrollableChart.getLinkedScrollableCharts().isEmpty()) {
                    nodeId = null;
                    if (node != null) {
                        nodeId = node.getId();
                        for (ScrollableChart linkedChart : this.scrollableChart.getLinkedScrollableCharts()) {
                            iSeriesArray2 = linkedChart.getBaseChart().getSeriesSet().getSeries();
                            n4 = iSeriesArray2.length;
                            n3 = 0;
                            while (n3 < n4) {
                                linkedSeries = iSeriesArray2[n3];
                                if (linkedSeries instanceof CircularSeries) {
                                    correspondingNode = ((CircularSeries)linkedSeries).getNodeById(nodeId);
                                    if (((CircularSeries)linkedSeries).getRootPointer() == correspondingNode) {
                                        if (!this.fillEntireSpace) {
                                            ((CircularSeries)linkedSeries).getModel().setRootPointer(correspondingNode.getParent());
                                        } else {
                                            ((CircularSeries)linkedSeries).setRootPointer(correspondingNode.getParent());
                                        }
                                    } else if (!this.fillEntireSpace) {
                                        ((CircularSeries)linkedSeries).getModel().setRootPointer(correspondingNode);
                                    } else {
                                        ((CircularSeries)linkedSeries).setRootPointer(correspondingNode);
                                    }
                                }
                                ++n3;
                            }
                        }
                    } else {
                        for (ScrollableChart linkedChart : this.scrollableChart.getLinkedScrollableCharts()) {
                            iSeriesArray2 = linkedChart.getBaseChart().getSeriesSet().getSeries();
                            n4 = iSeriesArray2.length;
                            n3 = 0;
                            while (n3 < n4) {
                                linkedSeries = iSeriesArray2[n3];
                                if (linkedSeries instanceof CircularSeries) {
                                    ((CircularSeries)linkedSeries).setRootPointer(((CircularSeries)linkedSeries).getRootNode());
                                }
                                ++n3;
                            }
                        }
                    }
                }
            }
            ++n2;
        }
    }
}

