/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.search;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.internal.ui.search.DLTKElementLine;
import org.eclipse.php.core.ast.nodes.Program;
import org.eclipse.php.internal.core.search.IOccurrencesFinder;
import org.eclipse.php.internal.ui.search.Messages;
import org.eclipse.php.internal.ui.search.OccurrenceMatch;
import org.eclipse.php.internal.ui.util.StatusInfo;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.text.Match;
import org.eclipse.wst.sse.ui.internal.search.OccurrencesSearchResult;

public class OccurrencesSearchQuery
implements ISearchQuery {
    private final OccurrencesSearchResult fResult;
    private IOccurrencesFinder fFinder;
    private final ISourceModule fElement;
    private final String fJobLabel;
    private final String fSingularLabel;
    private final String fPluralLabel;
    private final String fName;
    private final String fFinderId;

    public OccurrencesSearchQuery(IOccurrencesFinder finder, ISourceModule element) {
        this.fFinder = finder;
        this.fElement = element;
        this.fJobLabel = this.fFinder.getJobLabel();
        this.fResult = new OccurrencesSearchResult((ISearchQuery)this);
        this.fSingularLabel = this.fFinder.getUnformattedSingularLabel();
        this.fPluralLabel = this.fFinder.getUnformattedPluralLabel();
        this.fName = this.fFinder.getElementName();
        this.fFinderId = this.fFinder.getID();
    }

    public IStatus run(IProgressMonitor monitor) {
        if (this.fFinder == null) {
            return new StatusInfo(4, Messages.OccurrencesSearchQuery_0);
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            IOccurrencesFinder.OccurrenceLocation[] occurrences = this.fFinder.getOccurrences();
            if (occurrences != null) {
                HashMap<Integer, DLTKElementLine> lineMap = new HashMap<Integer, DLTKElementLine>();
                Program astRoot = this.fFinder.getASTRoot();
                ArrayList<OccurrenceMatch> resultingMatches = new ArrayList<OccurrenceMatch>();
                int i = 0;
                while (i < occurrences.length) {
                    IOccurrencesFinder.OccurrenceLocation loc = occurrences[i];
                    DLTKElementLine lineKey = this.getLineElement(astRoot, loc, lineMap);
                    if (lineKey != null) {
                        OccurrenceMatch match = new OccurrenceMatch(lineKey, loc.getOffset(), loc.getLength(), loc.getFlags());
                        resultingMatches.add(match);
                    }
                    ++i;
                }
                if (!resultingMatches.isEmpty()) {
                    this.fResult.addMatches(resultingMatches.toArray(new Match[resultingMatches.size()]));
                }
            }
        }
        finally {
            this.fFinder = null;
            monitor.done();
        }
        return Status.OK_STATUS;
    }

    private DLTKElementLine getLineElement(Program astRoot, IOccurrencesFinder.OccurrenceLocation location, HashMap<Integer, DLTKElementLine> lineToGroup) {
        int lineStartOffset;
        int lineNumber = astRoot.getLineNumber(location.getOffset());
        if (lineNumber <= 0) {
            return null;
        }
        DLTKElementLine lineElement = null;
        Integer key = lineNumber;
        lineElement = lineToGroup.get(key);
        if (lineElement == null && (lineStartOffset = astRoot.getPosition(lineNumber, 0)) >= 0) {
            lineElement = new DLTKElementLine((IModelElement)astRoot.getSourceModule(), lineStartOffset, "");
            lineToGroup.put(key, lineElement);
        }
        return lineElement;
    }

    public String getLabel() {
        return this.fJobLabel;
    }

    public String getResultLabel(int nMatches) {
        if (nMatches == 1) {
            return org.eclipse.php.internal.core.search.Messages.format((String)this.fSingularLabel, (Object[])new Object[]{this.fName, this.fElement.getElementName()});
        }
        return org.eclipse.php.internal.core.search.Messages.format((String)this.fPluralLabel, (Object[])new Object[]{this.fName, nMatches, this.fElement.getElementName()});
    }

    public boolean canRerun() {
        return false;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public ISearchResult getSearchResult() {
        return this.fResult;
    }

    public String getFinderId() {
        return this.fFinderId;
    }
}

