/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.pde.ui.editor;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.m2e.pde.MavenTargetDependency;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ClipboardParser {
    private Exception error;
    private List<MavenTargetDependency> dependencies = new ArrayList<MavenTargetDependency>();

    public ClipboardParser(String text) {
        if (text != null && text.trim().startsWith("<")) {
            text = "<dummy>" + text + "</dummy>";
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                ByteArrayInputStream input = new ByteArrayInputStream(text.getBytes("UTF-8"));
                Document doc = builder.parse(input);
                NodeList dependencies = doc.getElementsByTagName("dependency");
                int i = 0;
                while (i < dependencies.getLength()) {
                    Node item = dependencies.item(i);
                    if (item instanceof Element) {
                        this.parseElement((Element)item);
                    }
                    ++i;
                }
                if (this.dependencies.isEmpty()) {
                    this.parseElement(doc.getDocumentElement());
                }
            }
            catch (Exception e) {
                this.error = e;
            }
        }
    }

    private void parseElement(Element element) {
        String groupId = this.getTextFor("groupId", element, "");
        String artifactId = this.getTextFor("artifactId", element, "");
        String version = this.getTextFor("version", element, "");
        String classifier = this.getTextFor("classifier", element, "");
        String type = this.getTextFor("type", element, "jar");
        this.dependencies.add(new MavenTargetDependency(groupId, artifactId, version, type, classifier));
    }

    private String getTextFor(String element, Element doc, String defaultValue) {
        String v;
        NodeList nl = doc.getElementsByTagName(element);
        Node item = nl.item(0);
        if (item != null && !(v = Objects.requireNonNullElse(item.getTextContent(), defaultValue)).isBlank()) {
            return v;
        }
        return defaultValue;
    }

    public Exception getError() {
        return this.error;
    }

    public List<MavenTargetDependency> getDependencies() {
        return this.dependencies;
    }
}

