/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facelet.core.internal.registry.taglib;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.jst.jsf.common.internal.componentcore.AbstractCompCoreQueryFactory;
import org.eclipse.jst.jsf.common.internal.componentcore.AbstractJEEModelProviderQuery;
import org.eclipse.jst.jsf.common.internal.componentcore.AbstractVirtualComponentQuery;
import org.eclipse.jst.jsf.common.internal.finder.AbstractMatcher;
import org.eclipse.jst.jsf.common.internal.locator.AbstractLocatorProvider;
import org.eclipse.jst.jsf.common.internal.locator.ILocatorProvider;
import org.eclipse.jst.jsf.common.internal.resource.ContentTypeResolver;
import org.eclipse.jst.jsf.common.internal.resource.DefaultJarLocator;
import org.eclipse.jst.jsf.common.internal.resource.IJarLocator;
import org.eclipse.jst.jsf.common.internal.resource.JavaCoreMediator;
import org.eclipse.jst.jsf.common.internal.resource.ResourceSingletonObjectManager;
import org.eclipse.jst.jsf.common.internal.resource.WorkspaceMediator;
import org.eclipse.jst.jsf.common.internal.strategy.AbstractTestableExtensibleDefaultProviderSelectionStrategy;
import org.eclipse.jst.jsf.common.internal.strategy.ISimpleStrategy;
import org.eclipse.jst.jsf.designtime.internal.resources.IJSFResourceLocator;
import org.eclipse.jst.jsf.designtime.internal.resources.JarBasedJSFResourceLocator;
import org.eclipse.jst.jsf.designtime.internal.resources.WorkspaceJSFResourceLocator;
import org.eclipse.jst.jsf.facelet.core.internal.FaceletCorePlugin;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.AbstractFaceletTaglibLocator;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.AbstractProjectTaglibDescriptorFactory;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.CompositeComponentTaglibLocator;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.ContextParamSpecifiedFaceletTaglibLocator;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.ExtensionBasedTagDescriptorFactoryProviderStrategy;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.IProjectTaglibDescriptor;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.IProjectTaglibDescriptorFactory;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.JarFileFaceletTaglibLocator;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.ProjectTaglibDescriptor;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.TagRecordFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FaceletTagIndex
extends ResourceSingletonObjectManager<IProjectTaglibDescriptor, IProject> {
    private ISimpleStrategy<IProject, IProjectTaglibDescriptorFactory> _tagDescriptorFactoryProvider = new ProjectTaglibDescriptorFactoryProviderSelectionStrategy();
    private static FaceletTagIndex INSTANCE;

    public FaceletTagIndex(IWorkspace ws) {
        super(ws);
    }

    public FaceletTagIndex(IWorkspace ws, ISimpleStrategy<IProject, IProjectTaglibDescriptorFactory> tagDescriptorFactoryProvider) {
        this(ws);
        this._tagDescriptorFactoryProvider = tagDescriptorFactoryProvider;
    }

    public static synchronized FaceletTagIndex getInstance(IWorkspace ws) {
        if (INSTANCE == null) {
            INSTANCE = new FaceletTagIndex(ws);
        }
        return INSTANCE;
    }

    protected IProjectTaglibDescriptor createNewInstance(IProject project) {
        TagRecordFactory factory = new TagRecordFactory(project, true);
        try {
            IProjectTaglibDescriptorFactory descFactory = (IProjectTaglibDescriptorFactory)this._tagDescriptorFactoryProvider.perform((Object)project);
            return descFactory.create(project, factory);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void flush(IProject project) {
        IProjectTaglibDescriptor flushedDescriptor = (IProjectTaglibDescriptor)this.unmanageResource((IResource)project);
        flushedDescriptor.destroy();
    }

    public static class DefaultProjectTaglibDescriptorFactory
    extends AbstractProjectTaglibDescriptorFactory {
        public IProjectTaglibDescriptor create(IProject project, TagRecordFactory factory) {
            ArrayList<AbstractFaceletTaglibLocator> locators = new ArrayList<AbstractFaceletTaglibLocator>();
            locators.add(new JarFileFaceletTaglibLocator(factory));
            ContextParamSpecifiedFaceletTaglibLocator createContextParamSpecific = this.createContextParamSpecific(project, factory);
            if (createContextParamSpecific != null) {
                locators.add(createContextParamSpecific);
            }
            ArrayList<Object> resourceLocators = new ArrayList<Object>();
            resourceLocators.add(new JarBasedJSFResourceLocator(Collections.EMPTY_LIST, new CopyOnWriteArrayList(), (IJarLocator)new DefaultJarLocator(Collections.singletonList(new AbstractMatcher.AlwaysMatcher()), new JavaCoreMediator()), new ContentTypeResolver()));
            resourceLocators.add(this.createJsfResourceLocator(project));
            AbstractLocatorProvider.DefaultLocatorProvider resourceLocatorProvider = new AbstractLocatorProvider.DefaultLocatorProvider(resourceLocators);
            locators.add(new CompositeComponentTaglibLocator((ILocatorProvider<IJSFResourceLocator>)resourceLocatorProvider));
            LocatorProvider provider = new LocatorProvider(locators);
            return new ProjectTaglibDescriptor(project, factory, (ILocatorProvider<AbstractFaceletTaglibLocator>)provider);
        }

        private WorkspaceJSFResourceLocator createJsfResourceLocator(IProject project) {
            return new WorkspaceJSFResourceLocator(Collections.EMPTY_LIST, new CopyOnWriteArrayList(), FaceletCorePlugin.getDefault().getCompCoreQueryFactory().createVirtualComponentQuery(project), new ContentTypeResolver(), project.getWorkspace());
        }

        private ContextParamSpecifiedFaceletTaglibLocator createContextParamSpecific(IProject project, TagRecordFactory factory) {
            AbstractCompCoreQueryFactory compCoreQueryFactory = FaceletCorePlugin.getDefault().getCompCoreQueryFactory();
            AbstractJEEModelProviderQuery modelProviderQuery = compCoreQueryFactory.createJEEModelProviderQuery(project);
            AbstractVirtualComponentQuery virtualComponentQuery = compCoreQueryFactory.createVirtualComponentQuery(project);
            if (modelProviderQuery != null && virtualComponentQuery != null) {
                return new ContextParamSpecifiedFaceletTaglibLocator(project, factory, modelProviderQuery, virtualComponentQuery, new WorkspaceMediator());
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultProjectTaglibDescriptorFactoryProvider
    implements ISimpleStrategy<IProject, IProjectTaglibDescriptorFactory> {
        private final DefaultProjectTaglibDescriptorFactory _factory;

        public DefaultProjectTaglibDescriptorFactoryProvider(DefaultProjectTaglibDescriptorFactory factory) {
            this._factory = factory;
        }

        public IProjectTaglibDescriptorFactory perform(IProject input) throws Exception {
            return this._factory;
        }

        public IProjectTaglibDescriptorFactory getNoResult() {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LocatorProvider
    extends AbstractLocatorProvider<AbstractFaceletTaglibLocator> {
        private final List<AbstractFaceletTaglibLocator> _locators;

        public LocatorProvider(List<AbstractFaceletTaglibLocator> locators) {
            this._locators = locators;
        }

        protected void doInitialize() {
        }

        protected List<? extends AbstractFaceletTaglibLocator> doGetLocators() {
            return Collections.unmodifiableList(this._locators);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ProjectTaglibDescriptorFactoryProviderSelectionStrategy
    extends AbstractTestableExtensibleDefaultProviderSelectionStrategy<IProject, IProjectTaglibDescriptorFactory> {
        private static final IProjectTaglibDescriptorFactory NO_RESULT = null;

        public ProjectTaglibDescriptorFactoryProviderSelectionStrategy() {
            this.addDefaultStrategy(new DefaultProjectTaglibDescriptorFactoryProvider(new DefaultProjectTaglibDescriptorFactory()));
            this.addExtensionStrategy(new ExtensionBasedTagDescriptorFactoryProviderStrategy());
        }

        public IProjectTaglibDescriptorFactory getNoResult() {
            return NO_RESULT;
        }
    }
}

