/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.integration.zest.viewer;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import javafx.collections.ListChangeListener;
import javafx.embed.swt.FXCanvas;
import javafx.embed.swt.SWTFXUtils;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import org.eclipse.gef.common.adapt.AdapterKey;
import org.eclipse.gef.fx.swt.canvas.IFXCanvasFactory;
import org.eclipse.gef.graph.Edge;
import org.eclipse.gef.graph.Graph;
import org.eclipse.gef.layout.ILayoutAlgorithm;
import org.eclipse.gef.mvc.fx.domain.IDomain;
import org.eclipse.gef.mvc.fx.models.SelectionModel;
import org.eclipse.gef.mvc.fx.parts.IContentPart;
import org.eclipse.gef.mvc.fx.parts.IVisualPart;
import org.eclipse.gef.mvc.fx.viewer.IViewer;
import org.eclipse.gef.zest.fx.ZestProperties;
import org.eclipse.gef.zest.fx.jface.IGraphAttributesProvider;
import org.eclipse.gef.zest.fx.jface.IGraphContentProvider;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IToolTipProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.viatra.integration.zest.viewer.IGraphAttributesProvider2;
import org.eclipse.viatra.integration.zest.viewer.IGraphEdgeContentProvider;
import org.eclipse.viatra.integration.zest.viewer.IGraphEntityRelationshipContentProvider;
import org.eclipse.viatra.integration.zest.viewer.INestedGraphContentProvider;

public class ZestContentViewer
extends ContentViewer {
    private ListChangeListener<IContentPart<? extends Node>> selectionNotifier = new ListChangeListener<IContentPart<? extends Node>>(){

        public void onChanged(ListChangeListener.Change<? extends IContentPart<? extends Node>> c) {
            ZestContentViewer.this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)ZestContentViewer.this, ZestContentViewer.this.getSelection()));
        }
    };
    private Injector injector;
    private FXCanvas canvas;
    private IDomain domain;
    private IViewer viewer;
    private ILayoutAlgorithm layoutAlgorithm;
    protected BiMap<Object, org.eclipse.gef.graph.Node> contentNodeMap = HashBiMap.create();
    protected BiMap<org.eclipse.gef.graph.Node, Object> inverseContentNodeMap = this.contentNodeMap.inverse();
    protected BiMap<Object, Edge> contentEdgeMap = HashBiMap.create();
    protected BiMap<Edge, Object> inverseContentEdgeMap = this.contentEdgeMap.inverse();

    public ZestContentViewer(Module module) {
        this.injector = Guice.createInjector((Module[])new Module[]{module});
    }

    protected FXCanvas createCanvas(Composite parent, int style) {
        IFXCanvasFactory canvasFactory = (IFXCanvasFactory)this.injector.getInstance(IFXCanvasFactory.class);
        return canvasFactory.createCanvas(parent, style);
    }

    public void createControl(Composite parent, int style) {
        this.canvas = this.createCanvas(parent, style);
        this.domain = (IDomain)this.injector.getInstance(IDomain.class);
        this.viewer = (IViewer)this.domain.getAdapter(AdapterKey.get(IViewer.class, (String)"contentViewer"));
        this.canvas.setScene(new Scene(this.viewer.getCanvas()));
        this.getSelectionModel().getSelectionUnmodifiable().addListener(this.selectionNotifier);
        this.domain.activate();
    }

    protected Edge createEdge(ILabelProvider labelProvider, Object contentSourceNode, org.eclipse.gef.graph.Node sourceNode, Object contentTargetNode, org.eclipse.gef.graph.Node targetNode) {
        IGraphAttributesProvider graphNodeLabelProvider;
        Map edgeAttributes;
        Edge edge = new Edge(sourceNode, targetNode);
        if (labelProvider instanceof IGraphAttributesProvider && (edgeAttributes = (graphNodeLabelProvider = (IGraphAttributesProvider)labelProvider).getEdgeAttributes(contentSourceNode, contentTargetNode)) != null) {
            edge.attributesProperty().putAll(edgeAttributes);
        }
        return edge;
    }

    protected Edge createEdge(ILabelProvider labelProvider, Object contentEdgeNode, org.eclipse.gef.graph.Node sourceNode, org.eclipse.gef.graph.Node targetNode) {
        Edge edge = new Edge(sourceNode, targetNode);
        this.doFormatEdge(contentEdgeNode, labelProvider, edge);
        return edge;
    }

    private void doFormatEdge(Object contentEdgeNode, ILabelProvider labelProvider, Edge edge) {
        IGraphAttributesProvider2 graphNodeLabelProvider;
        Map<String, Object> edgeAttributes;
        ZestProperties.setLabel((Edge)edge, () -> labelProvider.getText(contentEdgeNode));
        if (labelProvider instanceof IGraphAttributesProvider2 && (edgeAttributes = (graphNodeLabelProvider = (IGraphAttributesProvider2)labelProvider).getEdgeAttributes(contentEdgeNode)) != null) {
            edge.attributesProperty().putAll(edgeAttributes);
        }
    }

    protected Graph createEmptyGraph() {
        Graph graph = new Graph();
        if (this.layoutAlgorithm != null) {
            ZestProperties.setLayoutAlgorithm((Graph)graph, (ILayoutAlgorithm)this.layoutAlgorithm);
        }
        return graph;
    }

    protected void createNestedGraph(Object contentNestingNode, IContentProvider contentProvider, ILabelProvider labelProvider) {
        if (contentProvider instanceof IGraphContentProvider && ((IGraphContentProvider)contentProvider).hasNestedGraph(contentNestingNode)) {
            Graph graph = this.createNestedGraph(contentNestingNode, (IGraphContentProvider)contentProvider, labelProvider);
            graph.setNestingNode((org.eclipse.gef.graph.Node)this.contentNodeMap.get(contentNestingNode));
        } else if (contentProvider instanceof INestedGraphContentProvider && ((INestedGraphContentProvider)contentProvider).hasNestedGraph(contentNestingNode)) {
            Graph graph = this.createNestedGraph(contentNestingNode, (INestedGraphContentProvider)contentProvider, labelProvider);
            graph.setNestingNode((org.eclipse.gef.graph.Node)this.contentNodeMap.get(contentNestingNode));
        }
    }

    protected Graph createNestedGraph(Object contentNestingNode, IGraphContentProvider graphContentProvider, ILabelProvider labelProvider) {
        Object[] contentNodes;
        IGraphAttributesProvider nestedGraphLabelProvider;
        Map nestedGraphAttributes;
        Graph graph = this.createEmptyGraph();
        if (labelProvider instanceof IGraphAttributesProvider && (nestedGraphAttributes = (nestedGraphLabelProvider = (IGraphAttributesProvider)labelProvider).getNestedGraphAttributes(contentNestingNode)) != null) {
            graph.attributesProperty().putAll(nestedGraphAttributes);
        }
        if ((contentNodes = graphContentProvider.getNestedGraphNodes(contentNestingNode)) != null) {
            this.createNodesAndEdges(graphContentProvider, labelProvider, graph, contentNodes);
        }
        return graph;
    }

    protected Graph createNestedGraph(Object contentNestingNode, INestedGraphContentProvider graphContentProvider, ILabelProvider labelProvider) {
        Object[] contentNodes;
        IGraphAttributesProvider nestedGraphLabelProvider;
        Map nestedGraphAttributes;
        Graph graph = this.createEmptyGraph();
        if (labelProvider instanceof IGraphAttributesProvider && (nestedGraphAttributes = (nestedGraphLabelProvider = (IGraphAttributesProvider)labelProvider).getNestedGraphAttributes(contentNestingNode)) != null) {
            graph.attributesProperty().putAll(nestedGraphAttributes);
        }
        if ((contentNodes = graphContentProvider.getNestedGraphNodes(contentNestingNode)) != null) {
            this.createNodesAndEdges(graphContentProvider, labelProvider, graph, contentNodes);
        }
        return graph;
    }

    protected org.eclipse.gef.graph.Node createNode(Object contentNode, IContentProvider graphContentProvider, ILabelProvider labelProvider) {
        if (this.contentNodeMap.containsKey(contentNode)) {
            throw new IllegalStateException("A node for content <" + contentNode + "> has already been created.");
        }
        org.eclipse.gef.graph.Node node = new org.eclipse.gef.graph.Node();
        this.contentNodeMap.put(contentNode, (Object)node);
        this.doFormatNode(contentNode, graphContentProvider, labelProvider, node);
        return node;
    }

    private void doFormatNode(Object contentNode, IContentProvider graphContentProvider, ILabelProvider labelProvider, org.eclipse.gef.graph.Node node) {
        IGraphAttributesProvider graphNodeLabelProvider;
        Map nodeAttributes;
        ZestProperties.setLabel((org.eclipse.gef.graph.Node)node, () -> labelProvider.getText(contentNode));
        org.eclipse.swt.graphics.Image icon = labelProvider.getImage(contentNode);
        if (icon != null) {
            ZestProperties.setIcon((org.eclipse.gef.graph.Node)node, (Image)SWTFXUtils.toFXImage((ImageData)icon.getImageData(), null));
        }
        if (labelProvider instanceof IToolTipProvider) {
            IToolTipProvider toolTipProvider = (IToolTipProvider)labelProvider;
            ZestProperties.setTooltip((org.eclipse.gef.graph.Node)node, () -> toolTipProvider.getToolTipText(contentNode));
        }
        String textCssStyle = "";
        if (labelProvider instanceof IColorProvider) {
            IColorProvider colorProvider = (IColorProvider)labelProvider;
            Color foreground = colorProvider.getForeground(contentNode);
            Color background = colorProvider.getBackground(contentNode);
            String rectCssStyle = "";
            if (background != null) {
                rectCssStyle = String.valueOf(rectCssStyle) + "-fx-fill: " + this.toCssRgb(background) + ";";
            }
            if (foreground != null) {
                rectCssStyle = String.valueOf(rectCssStyle) + "-fx-stroke: " + this.toCssRgb(foreground) + ";";
                textCssStyle = "-fx-fill: " + this.toCssRgb(foreground) + ";";
            }
            if (!rectCssStyle.isEmpty()) {
                ZestProperties.setShapeCssStyle((org.eclipse.gef.graph.Node)node, (String)rectCssStyle);
            }
        }
        if (labelProvider instanceof IFontProvider) {
            FontData[] fontData;
            IFontProvider fontProvider = (IFontProvider)labelProvider;
            Font font = fontProvider.getFont(contentNode);
            FontData[] fontDataArray = fontData = font == null ? null : font.getFontData();
            if (fontData != null && fontData.length > 0 && fontData[0] != null) {
                String name = fontData[0].getName();
                int size = fontData[0].getHeight();
                int style = fontData[0].getStyle();
                boolean isBold = (style & 1) != 0;
                boolean isItalic = (style & 2) != 0;
                textCssStyle = String.valueOf(textCssStyle) + "-fx-font-family: \"" + name + "\";" + "-fx-font-size: " + size + "pt;";
                if (isItalic) {
                    textCssStyle = String.valueOf(textCssStyle) + "-fx-font-style: italic;";
                }
                if (isBold) {
                    textCssStyle = String.valueOf(textCssStyle) + "-fx-font-weight: bold;";
                }
            }
        }
        ZestProperties.setLabelCssStyle((org.eclipse.gef.graph.Node)node, (String)textCssStyle);
        if (labelProvider instanceof IGraphAttributesProvider && (nodeAttributes = (graphNodeLabelProvider = (IGraphAttributesProvider)labelProvider).getNodeAttributes(contentNode)) != null) {
            node.attributesProperty().putAll(nodeAttributes);
        }
        this.createNestedGraph(contentNode, graphContentProvider, labelProvider);
    }

    protected void createNodesAndEdges(IContentProvider contentProvider, ILabelProvider labelProvider, Graph graph, Object[] contentNodes) {
        if (contentProvider instanceof IGraphContentProvider) {
            this.createNodesAndEdges((IGraphContentProvider)contentProvider, labelProvider, graph, contentNodes);
        } else if (contentProvider instanceof IGraphEdgeContentProvider) {
            this.createNodesAndEdges((IGraphEdgeContentProvider)contentProvider, labelProvider, graph, contentNodes);
        } else if (contentProvider instanceof IGraphEntityRelationshipContentProvider) {
            this.createNodesAndEdges((IGraphEntityRelationshipContentProvider)contentProvider, labelProvider, graph, contentNodes);
        } else {
            throw new UnsupportedOperationException("Content provider type " + contentProvider.getClass().getName() + " is not supported.");
        }
    }

    protected void createNodesAndEdges(IGraphContentProvider graphContentProvider, ILabelProvider labelProvider, Graph graph, Object[] contentNodes) {
        Object[] objectArray = contentNodes;
        int n = contentNodes.length;
        int n2 = 0;
        while (n2 < n) {
            Object node = objectArray[n2];
            org.eclipse.gef.graph.Node graphNode = this.createNode(node, (IContentProvider)graphContentProvider, labelProvider);
            graph.getNodes().add((Object)graphNode);
            ++n2;
        }
        objectArray = contentNodes;
        n = contentNodes.length;
        n2 = 0;
        while (n2 < n) {
            Object contentSourceNode = objectArray[n2];
            org.eclipse.gef.graph.Node sourceNode = (org.eclipse.gef.graph.Node)this.contentNodeMap.get(contentSourceNode);
            Object[] connectedTo = graphContentProvider.getAdjacentNodes(contentSourceNode);
            if (connectedTo != null) {
                Object[] objectArray2 = connectedTo;
                int n3 = connectedTo.length;
                int n4 = 0;
                while (n4 < n3) {
                    Object contentTargetNode = objectArray2[n4];
                    org.eclipse.gef.graph.Node targetNode = (org.eclipse.gef.graph.Node)this.contentNodeMap.get(contentTargetNode);
                    Edge edge = this.createEdge(labelProvider, contentSourceNode, sourceNode, contentTargetNode, targetNode);
                    graph.getEdges().add((Object)edge);
                    ++n4;
                }
            }
            ++n2;
        }
    }

    protected void createNodesAndEdges(IGraphEdgeContentProvider graphContentProvider, ILabelProvider labelProvider, Graph graph, Object[] contentNodes) {
        Object[] objectArray = contentNodes;
        int n = contentNodes.length;
        int n2 = 0;
        while (n2 < n) {
            Object node = objectArray[n2];
            org.eclipse.gef.graph.Node graphNode = this.createNode(node, graphContentProvider, labelProvider);
            graph.getNodes().add((Object)graphNode);
            ++n2;
        }
        objectArray = graphContentProvider.getEdges();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            Object contentSourceEdge = objectArray[n2];
            Object contentSourceNode = graphContentProvider.getSource(contentSourceEdge);
            org.eclipse.gef.graph.Node sourceNode = this.getContentNodeMap().get(contentSourceNode);
            Object contentTargetNode = graphContentProvider.getTarget(contentSourceEdge);
            org.eclipse.gef.graph.Node targetNode = this.getContentNodeMap().get(contentTargetNode);
            Edge edge = this.createEdge(labelProvider, contentSourceEdge, sourceNode, targetNode);
            this.contentEdgeMap.put(contentSourceEdge, (Object)edge);
            graph.getEdges().add((Object)edge);
            ++n2;
        }
    }

    protected void createNodesAndEdges(IGraphEntityRelationshipContentProvider graphContentProvider, ILabelProvider labelProvider, Graph graph, Object[] contentNodes) {
        Object[] objectArray = contentNodes;
        int n = contentNodes.length;
        int n2 = 0;
        while (n2 < n) {
            Object node = objectArray[n2];
            org.eclipse.gef.graph.Node graphNode = this.createNode(node, graphContentProvider, labelProvider);
            graph.getNodes().add((Object)graphNode);
            ++n2;
        }
        objectArray = contentNodes;
        n = contentNodes.length;
        n2 = 0;
        while (n2 < n) {
            Object contentSourceNode = objectArray[n2];
            org.eclipse.gef.graph.Node sourceNode = this.getContentNodeMap().get(contentSourceNode);
            Object[] objectArray2 = contentNodes;
            int n3 = contentNodes.length;
            int n4 = 0;
            while (n4 < n3) {
                Object contentTargetNode = objectArray2[n4];
                org.eclipse.gef.graph.Node targetNode = this.getContentNodeMap().get(contentTargetNode);
                Object[] objectArray3 = graphContentProvider.getEdges(contentSourceNode, contentTargetNode);
                int n5 = objectArray3.length;
                int n6 = 0;
                while (n6 < n5) {
                    Object contentSourceEdge = objectArray3[n6];
                    Edge edge = this.createEdge(labelProvider, contentSourceEdge, sourceNode, targetNode);
                    graph.getEdges().add((Object)edge);
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
    }

    protected Graph createRootGraph(IContentProvider contentProvider, ILabelProvider labelProvider) {
        Object[] nodes;
        INestedGraphContentProvider graphNodeProvider;
        IGraphAttributesProvider graphNodeLabelProvider;
        Map rootGraphAttributes;
        Graph graph = this.createEmptyGraph();
        if (labelProvider instanceof IGraphAttributesProvider && (rootGraphAttributes = (graphNodeLabelProvider = (IGraphAttributesProvider)labelProvider).getGraphAttributes()) != null) {
            graph.attributesProperty().putAll(rootGraphAttributes);
        }
        if (contentProvider instanceof IGraphEdgeContentProvider) {
            graphNodeProvider = (IGraphEdgeContentProvider)contentProvider;
            nodes = graphNodeProvider.getNodes();
            if (nodes != null) {
                this.createNodesAndEdges((IGraphEdgeContentProvider)graphNodeProvider, labelProvider, graph, nodes);
            }
        } else if (contentProvider instanceof IGraphEntityRelationshipContentProvider) {
            graphNodeProvider = (IGraphEntityRelationshipContentProvider)contentProvider;
            nodes = graphNodeProvider.getNodes();
            if (nodes != null) {
                this.createNodesAndEdges((IGraphEntityRelationshipContentProvider)graphNodeProvider, labelProvider, graph, nodes);
            }
        } else if (contentProvider instanceof IGraphContentProvider && (nodes = (graphNodeProvider = (IGraphContentProvider)contentProvider).getNodes()) != null) {
            this.createNodesAndEdges((IGraphContentProvider)graphNodeProvider, labelProvider, graph, nodes);
        }
        return graph;
    }

    public Map<Object, org.eclipse.gef.graph.Node> getContentNodeMap() {
        return Collections.unmodifiableMap(this.contentNodeMap);
    }

    public FXCanvas getControl() {
        return this.canvas;
    }

    public IViewer getFXViewer() {
        return this.viewer;
    }

    public ILabelProvider getLabelProvider() {
        return (ILabelProvider)super.getLabelProvider();
    }

    public ILayoutAlgorithm getLayoutAlgorithm() {
        return this.layoutAlgorithm;
    }

    public ISelection getSelection() {
        ArrayList<Object> selectedContents = new ArrayList<Object>();
        SelectionModel selectionModel = this.getSelectionModel();
        for (IContentPart selectedPart : selectionModel.getSelectionUnmodifiable()) {
            Object contentNode = selectedPart.getContent();
            if (this.inverseContentEdgeMap.containsKey(contentNode)) {
                selectedContents.add(this.inverseContentEdgeMap.get(contentNode));
                continue;
            }
            if (this.inverseContentNodeMap.containsKey(contentNode)) {
                selectedContents.add(this.inverseContentNodeMap.get(contentNode));
                continue;
            }
            selectedContents.add(contentNode);
        }
        return new StructuredSelection(selectedContents);
    }

    protected SelectionModel getSelectionModel() {
        SelectionModel selectionModel = (SelectionModel)this.viewer.getAdapter(SelectionModel.class);
        if (selectionModel == null) {
            throw new IllegalStateException("No SelectionModel bound.");
        }
        return selectionModel;
    }

    protected void handleDispose(DisposeEvent event) {
        this.getSelectionModel().getSelectionUnmodifiable().removeListener(this.selectionNotifier);
        this.domain.deactivate();
        this.domain.dispose();
        super.handleDispose(event);
    }

    protected void inputChanged(Object input, Object oldInput) {
        if (!(input == oldInput || input != null && input.equals(oldInput))) {
            this.refresh();
        }
    }

    protected Graph getRootGraph() {
        return (Graph)this.viewer.getContents().get(0);
    }

    public void refresh() {
        this.contentNodeMap.clear();
        this.contentEdgeMap.clear();
        this.viewer.getContents().setAll(Collections.singletonList(this.createRootGraph(this.getContentProvider(), this.getLabelProvider())));
    }

    public void setLayoutAlgorithm(ILayoutAlgorithm layoutAlgorithm) {
        this.layoutAlgorithm = layoutAlgorithm;
    }

    public void setSelection(ISelection selection, boolean reveal) {
        if (selection.isEmpty()) {
            this.getSelectionModel().clearSelection();
        } else if (selection instanceof StructuredSelection) {
            StructuredSelection structuredSelection = (StructuredSelection)selection;
            if (!structuredSelection.isEmpty()) {
                ArrayList<IContentPart> toBeSelectedParts = new ArrayList<IContentPart>();
                Object[] objectArray = structuredSelection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object toBeSelectedContent = objectArray[n2];
                    IContentPart toBeSelectedPart = (IContentPart)this.viewer.getContentPartMap().get(toBeSelectedContent);
                    if (toBeSelectedPart != null) {
                        toBeSelectedParts.add(toBeSelectedPart);
                        if (reveal) {
                            this.viewer.reveal((IVisualPart)toBeSelectedPart);
                        }
                    } else {
                        throw new IllegalArgumentException(toBeSelectedContent + " is not visualized by a content part of this viewer.");
                    }
                    ++n2;
                }
                this.getSelectionModel().prependToSelection(toBeSelectedParts);
            }
        } else {
            throw new IllegalArgumentException("A non-empty selection of unsupported type '" + selection.getClass() + "' was passed in.");
        }
    }

    protected String toCssRgb(Color color) {
        return "rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ")";
    }

    public void refresh(Object element) {
        org.eclipse.gef.graph.Node node = (org.eclipse.gef.graph.Node)this.contentNodeMap.get(element);
        if (node == null) {
            Edge edge = (Edge)this.contentEdgeMap.get(element);
            if (edge != null) {
                this.doFormatEdge(element, this.getLabelProvider(), edge);
            }
        } else {
            this.doFormatNode(element, this.getContentProvider(), this.getLabelProvider(), node);
        }
    }
}

