/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.ui.model;

import java.math.BigInteger;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenCountUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IHasChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.tcf.internal.debug.ui.ImageCache;
import org.eclipse.tcf.internal.debug.ui.model.TCFChildrenSubExpressions;
import org.eclipse.tcf.internal.debug.ui.model.TCFNode;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeExpression;
import org.eclipse.tcf.protocol.JSON;
import org.eclipse.tcf.services.ISymbols;
import org.eclipse.tcf.util.TCFDataCache;

public class TCFNodeArrayPartition
extends TCFNode {
    private final int offs;
    private final int size;
    private final TCFChildrenSubExpressions children;

    TCFNodeArrayPartition(TCFNode parent, int level, int offs, int size) {
        super(parent, "AP" + level + "." + offs + "." + parent.id);
        this.offs = offs;
        this.size = size;
        this.children = new TCFChildrenSubExpressions(this, level, offs, size);
    }

    int getOffset() {
        return this.offs;
    }

    int getSize() {
        return this.size;
    }

    private BigInteger getLowerBound(Runnable done) {
        Number l;
        TCFNode n = this.parent;
        while (n instanceof TCFNodeArrayPartition) {
            n = n.parent;
        }
        TCFDataCache<ISymbols.Symbol> t = ((TCFNodeExpression)n).getType();
        if (!t.validate(done)) {
            return null;
        }
        ISymbols.Symbol s = (ISymbols.Symbol)t.getData();
        if (s != null && (l = s.getLowerBound()) != null) {
            return JSON.toBigInteger((Number)l);
        }
        return BigInteger.valueOf(0L);
    }

    @Override
    protected boolean getData(IChildrenCountUpdate result, Runnable done) {
        if (!this.children.validate(done)) {
            return false;
        }
        result.setChildCount(this.children.size());
        return true;
    }

    @Override
    protected boolean getData(IChildrenUpdate result, Runnable done) {
        return this.children.getData(result, done);
    }

    @Override
    protected boolean getData(IHasChildrenUpdate result, Runnable done) {
        result.setHasChilren(true);
        return true;
    }

    @Override
    protected boolean getData(ILabelUpdate result, Runnable done) {
        BigInteger lower_bound = this.getLowerBound(done);
        if (lower_bound == null) {
            return false;
        }
        result.setImageDescriptor(ImageCache.getImageDescriptor("icons/full/obj16/arraypartition_obj"), 0);
        String[] cols = result.getColumnIds();
        BigInteger index = lower_bound.add(BigInteger.valueOf(this.offs));
        String name = "[" + index + ".." + index.add(BigInteger.valueOf(this.size - 1)) + "]";
        if (cols == null || cols.length <= 1) {
            result.setLabel(name, 0);
        } else {
            int i = 0;
            while (i < cols.length) {
                String c = cols[i];
                if (c.equals("Name")) {
                    result.setLabel(name, i);
                } else {
                    result.setLabel("", i);
                }
                ++i;
            }
        }
        return true;
    }

    void onSuspended(boolean func_call) {
        this.children.onSuspended(func_call);
    }

    void onValueChanged() {
        this.children.onValueChanged();
    }

    void onRegisterValueChanged() {
        this.children.onRegisterValueChanged();
    }

    void onMemoryChanged() {
        this.children.onMemoryChanged();
    }

    void onMemoryMapChanged() {
        this.children.onMemoryMapChanged();
    }

    @Override
    public int compareTo(TCFNode n) {
        TCFNodeArrayPartition p = (TCFNodeArrayPartition)n;
        if (this.offs < p.offs) {
            return -1;
        }
        if (this.offs > p.offs) {
            return 1;
        }
        return 0;
    }
}

