/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.launching.ext;

import com.google.common.base.Preconditions;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.ProgressMonitorWrapper;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.internal.launching.LaunchingPlugin;
import org.eclipse.jdt.launching.AbstractVMInstall;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstall3;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.rcptt.internal.core.RcpttPlugin;
import org.eclipse.rcptt.internal.launching.ext.OSArchitecture;

public class JDTUtils {
    private static final String TARGET_VM_INSTALL_TYPE = "org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType";
    private static final String HOST_VM_INSTALL_ID = "Q7 Host JVM";
    private static final String SUN_ARCH_DATA_MODEL = "sun.arch.data.model";
    private static final String JAVA_VM_INFO = "java.vm.info";
    private static final String OS_ARCH = "os.arch";

    public static void registerCurrentJVM() throws CoreException {
        IVMInstallType type = JavaRuntime.getVMInstallType((String)TARGET_VM_INSTALL_TYPE);
        if (type == null) {
            return;
        }
        IVMInstall install = type.findVMInstall(HOST_VM_INSTALL_ID);
        if (install != null) {
            type.disposeVMInstall(HOST_VM_INSTALL_ID);
        }
        install = type.createVMInstall(HOST_VM_INSTALL_ID);
        install.setInstallLocation(new File(System.getProperty("java.home")));
        install.setName(HOST_VM_INSTALL_ID);
        JavaRuntime.saveVMConfiguration();
    }

    public static Map<String, String> evaluateSystemPropertiesInThread(AbstractVMInstall install, IProgressMonitor monitor, boolean d32, int timeout) throws CoreException {
        GetPropertiesThread thread = new GetPropertiesThread(install, monitor, d32);
        thread.start();
        try {
            thread.join(timeout);
        }
        catch (InterruptedException e) {
            RcpttPlugin.log((Throwable)e);
        }
        thread.interrupt();
        if (thread.getCoreException() != null) {
            throw thread.getCoreException();
        }
        return thread.getMap();
    }

    protected static void abort(String message, Throwable exception, int code) throws CoreException {
        throw new CoreException((IStatus)new Status(4, LaunchingPlugin.getUniqueIdentifier(), code, message, exception));
    }

    public static Map<String, String> evaluateSystemProperties(AbstractVMInstall install, IProgressMonitor monitor, boolean d32) throws CoreException {
        String[] properties = new String[]{OS_ARCH, "java.version", "java.specification.name", "java.specification.version", JAVA_VM_INFO, "java.vm.name", "java.vm.version", "java.runtime.name", "java.runtime.version", SUN_ARCH_DATA_MODEL};
        return install.evaluateSystemProperties(properties, monitor);
    }

    public static Map<String, String> getProperties(IVMInstall install) throws CoreException {
        if (install instanceof AbstractVMInstall) {
            AbstractVMInstall avi = (AbstractVMInstall)install;
            Map<String, String> properties = JDTUtils.evaluateSystemPropertiesInThread(avi, (IProgressMonitor)new NullProgressMonitor(), false, 60000);
            return properties;
        }
        throw new CoreException(RcpttPlugin.createStatus((String)("Failed to get JVM properties. Unknown JVM installation type: " + install.getClass().getName())));
    }

    public static OSArchitecture detect(IVMInstall install) throws CoreException {
        Preconditions.checkNotNull((Object)install);
        try {
            return JDTUtils.detect(JDTUtils.getProperties(install));
        }
        catch (CoreException e) {
            throw new CoreException(RcpttPlugin.createStatus((String)("Failed to get JVM arhitecture for " + install.getInstallLocation()), (Throwable)e));
        }
    }

    private static OSArchitecture detect(Map<String, String> properties) throws CoreException {
        String model = properties.get(SUN_ARCH_DATA_MODEL);
        if (model != null && "32".equals(model)) {
            return OSArchitecture.x86;
        }
        if (model != null && "64".equals(model)) {
            return OSArchitecture.x86_64;
        }
        String arch = properties.get(OS_ARCH);
        if (arch != null && "amd64".equals(arch)) {
            return OSArchitecture.x86_64;
        }
        if (arch != null && "x86_64".equals(arch)) {
            return OSArchitecture.x86_64;
        }
        if (arch != null && "i386".equals(arch)) {
            return OSArchitecture.x86;
        }
        if (arch != null && "i686".equals(arch)) {
            return OSArchitecture.x86;
        }
        if (arch != null && "i586".equals(arch)) {
            return OSArchitecture.x86;
        }
        String message = String.format("Unknown combination:  %s = %s and %s = %s", SUN_ARCH_DATA_MODEL, model, OS_ARCH, arch);
        throw new CoreException(RcpttPlugin.createStatus((String)message));
    }

    public static boolean canRun32bit(IVMInstall install) {
        if (Platform.getOS().equals("macosx") && install instanceof IVMInstall3) {
            AbstractVMInstall avi = (AbstractVMInstall)install;
            try {
                Map<String, String> properties2 = JDTUtils.evaluateSystemPropertiesInThread(avi, (IProgressMonitor)new NullProgressMonitor(), true, 60000);
                if (!properties2.isEmpty()) {
                    return true;
                }
            }
            catch (CoreException coreException) {}
        }
        return false;
    }

    static class GetPropertiesThread
    extends Thread {
        private Map<String, String> map = new HashMap<String, String>();
        private CoreException coreException;
        private final AbstractVMInstall install;
        private final IProgressMonitor monitor;
        private final boolean d32;

        public Map<String, String> getMap() {
            return this.map;
        }

        public CoreException getCoreException() {
            return this.coreException;
        }

        public GetPropertiesThread(AbstractVMInstall install, IProgressMonitor monitor, boolean d32) {
            this.install = install;
            this.monitor = new ProgressMonitorWrapper(monitor){

                public boolean isCanceled() {
                    return super.isCanceled() || Thread.interrupted();
                }
            };
            this.d32 = d32;
        }

        @Override
        public void run() {
            try {
                this.map = JDTUtils.evaluateSystemProperties(this.install, this.monitor, this.d32);
            }
            catch (CoreException e) {
                this.coreException = e;
            }
        }
    }
}

