/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.statemachine.parsers;

import java.text.FieldPosition;
import java.text.MessageFormat;
import java.text.ParsePosition;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParserEditStatus;
import org.eclipse.gmf.runtime.common.ui.services.parser.ParserEditStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.emf.gmf.command.EMFtoGMFCommandWrapper;
import org.eclipse.papyrus.infra.gmfdiag.common.parsers.AbstractElementTypeBasedAttributeParser;
import org.eclipse.papyrus.infra.internationalization.common.utils.InternationalizationPreferencesUtils;
import org.eclipse.papyrus.uml.diagram.statemachine.part.Messages;
import org.eclipse.papyrus.uml.internationalization.utils.utils.UMLLabelInternationalization;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.UMLPackage;

public class MessageFormatParser
extends AbstractElementTypeBasedAttributeParser {
    private String defaultPattern;
    private String defaultEditablePattern;
    private MessageFormat viewProcessor;
    private MessageFormat editorProcessor;
    private MessageFormat editProcessor;

    public MessageFormatParser(EAttribute[] features) {
        super(features);
    }

    public MessageFormatParser(EAttribute[] features, EAttribute[] editableFeatures) {
        super(features, editableFeatures);
    }

    protected String getDefaultPattern() {
        if (this.defaultPattern == null) {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < this.features.length) {
                if (i > 0) {
                    sb.append(' ');
                }
                sb.append('{');
                sb.append(i);
                sb.append('}');
                ++i;
            }
            this.defaultPattern = sb.toString();
        }
        return this.defaultPattern;
    }

    public void setViewPattern(String viewPattern) {
        super.setViewPattern(viewPattern);
        this.viewProcessor = null;
    }

    public void setEditorPattern(String editorPattern) {
        super.setEditorPattern(editorPattern);
        this.editorProcessor = null;
    }

    protected MessageFormat getViewProcessor() {
        if (this.viewProcessor == null) {
            this.viewProcessor = new MessageFormat(this.getViewPattern() == null ? this.getDefaultPattern() : this.getViewPattern());
        }
        return this.viewProcessor;
    }

    protected MessageFormat getEditorProcessor() {
        if (this.editorProcessor == null) {
            this.editorProcessor = new MessageFormat(this.getEditorPattern() == null ? this.getDefaultEditablePattern() : this.getEditorPattern());
        }
        return this.editorProcessor;
    }

    protected String getDefaultEditablePattern() {
        if (this.defaultEditablePattern == null) {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < this.editableFeatures.length) {
                if (i > 0) {
                    sb.append(' ');
                }
                sb.append('{');
                sb.append(i);
                sb.append('}');
                ++i;
            }
            this.defaultEditablePattern = sb.toString();
        }
        return this.defaultEditablePattern;
    }

    public void setEditPattern(String editPattern) {
        super.setEditPattern(editPattern);
        this.editProcessor = null;
    }

    protected MessageFormat getEditProcessor() {
        if (this.editProcessor == null) {
            this.editProcessor = new MessageFormat(this.getEditPattern() == null ? this.getDefaultEditablePattern() : this.getEditPattern());
        }
        return this.editProcessor;
    }

    public String getEditString(IAdaptable adapter, int flags) {
        EObject element = (EObject)adapter.getAdapter(EObject.class);
        return this.getEditorProcessor().format(this.getEditableValues(element), new StringBuffer(), new FieldPosition(0)).toString();
    }

    public IParserEditStatus isValidEditString(IAdaptable adapter, String editString) {
        ParsePosition pos = new ParsePosition(0);
        Object[] values = this.getEditProcessor().parse(editString, pos);
        if (values == null) {
            return new ParserEditStatus("org.eclipse.papyrus.uml.diagram.statemachine", 1, NLS.bind((String)Messages.MessageFormatParser_InvalidInputError, (Object)new Integer(pos.getErrorIndex())));
        }
        return this.validateNewValues(values);
    }

    public ICommand getParseCommand(IAdaptable adapter, String newString, int flags) {
        Object[] values = this.getEditProcessor().parse(newString, new ParsePosition(0));
        return this.getParseCommand(adapter, values, flags);
    }

    public String getPrintString(IAdaptable adapter, int flags) {
        EObject element = (EObject)adapter.getAdapter(EObject.class);
        return this.getViewProcessor().format(this.getValues(element), new StringBuffer(), new FieldPosition(0)).toString();
    }

    protected ICommand getModificationCommand(EObject element, EStructuralFeature feature, Object value) {
        ModelSet modelSet;
        ICommand result = null;
        if (feature.equals(UMLPackage.eINSTANCE.getNamedElement_Name()) && InternationalizationPreferencesUtils.getInternationalizationPreference((EObject)element) && UMLLabelInternationalization.getInstance().getLabelWithoutUML((NamedElement)element) != null && (modelSet = (ModelSet)element.eResource().getResourceSet()) != null) {
            result = new EMFtoGMFCommandWrapper(UMLLabelInternationalization.getInstance().getSetLabelCommand((EditingDomain)modelSet.getTransactionalEditingDomain(), (NamedElement)element, (String)value, null));
        }
        return result != null ? result : super.getModificationCommand(element, feature, value);
    }

    protected Object getValue(EObject element, EStructuralFeature feature) {
        Object result = null;
        if (element instanceof NamedElement && feature.equals(UMLPackage.eINSTANCE.getNamedElement_Name()) && InternationalizationPreferencesUtils.getInternationalizationPreference((EObject)element) && UMLLabelInternationalization.getInstance().getLabelWithoutUML((NamedElement)element) != null) {
            result = UMLLabelInternationalization.getInstance().getLabelWithoutUML((NamedElement)element);
        }
        return result != null ? result : super.getValue(element, feature);
    }
}

