/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.labels;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.labels.ILabelGenerator;

public abstract class AbstractLabelGeneratorBuilder
implements ILabelGenerator.Builder {
    protected final  @NonNull ILabelGenerator.Registry registry;
    protected final @Nullable Object labelledObject;
    protected @Nullable Map<ILabelGenerator.Option<?>, Object> options = null;

    protected AbstractLabelGeneratorBuilder( @NonNull ILabelGenerator.Registry registry, @Nullable Object labelledObject, @Nullable Map<ILabelGenerator.Option<?>, Object> options) {
        this.registry = registry;
        this.labelledObject = labelledObject;
        this.options = options;
    }

    @Override
    public void appendObject(@Nullable Object object) {
        this.registry.buildSubLabelFor(this, object);
    }

    @Override
    public void buildLabelFor(@Nullable Object object) {
        this.registry.buildLabelFor(this, object);
    }

    @Override
    public @Nullable Object getLabelledObject() {
        return this.labelledObject;
    }

    @Override
    public <T> @Nullable T getOption( @NonNull ILabelGenerator.Option<T> option) {
        return (T)(this.options != null ? this.options.get(option) : null);
    }

    @Override
    public  @NonNull ILabelGenerator.Registry getRegistry() {
        return this.registry;
    }

    @Override
    public <T> boolean hasOption( @NonNull ILabelGenerator.Option<T> option) {
        return this.options != null && this.options.containsKey(option);
    }

    @Override
    public <T> void setOption( @NonNull ILabelGenerator.Option<T> option, @Nullable T value) {
        Map<ILabelGenerator.Option<?>, Object> options2 = this.options;
        if (options2 == null) {
            options2 = new HashMap();
            this.options = options2;
        }
        options2.put(option, value);
    }

    @Override
    public abstract @NonNull String toString();
}

