/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.db.ddl;

import java.io.PrintStream;
import java.sql.Connection;
import java.util.HashSet;
import java.util.Set;
import javax.sql.DataSource;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.IDBAdapter;
import org.eclipse.net4j.db.IDBConnectionProvider;
import org.eclipse.net4j.db.ddl.IDBField;
import org.eclipse.net4j.db.ddl.IDBIndex;
import org.eclipse.net4j.db.ddl.IDBSchema;
import org.eclipse.net4j.db.ddl.IDBSchemaElement;
import org.eclipse.net4j.db.ddl.IDBTable;
import org.eclipse.net4j.db.ddl.SchemaElementNotFoundException;
import org.eclipse.net4j.db.ddl.delta.IDBSchemaDelta;
import org.eclipse.net4j.internal.db.ddl.DelegatingDBSchemaElement;
import org.eclipse.net4j.spi.db.ddl.InternalDBSchema;

public final class DelegatingDBSchema
extends DelegatingDBSchemaElement
implements InternalDBSchema {
    DelegatingDBSchema(InternalDBSchema delegate) {
        super(delegate);
    }

    @Override
    public InternalDBSchema getDelegate() {
        return (InternalDBSchema)super.getDelegate();
    }

    @Override
    public void setDelegate(IDBSchemaElement delegate) {
        IDBTable[] wrapperTables = this.getTables();
        IDBSchema delegateSchema = (IDBSchema)delegate;
        super.setDelegate(delegateSchema);
        IDBTable[] iDBTableArray = wrapperTables;
        int n = wrapperTables.length;
        int n2 = 0;
        while (n2 < n) {
            IDBTable wrapperTable = iDBTableArray[n2];
            ((DelegatingDBSchemaElement)((Object)wrapperTable)).setDelegate(delegateSchema.getTable(wrapperTable.getName()));
            ++n2;
        }
    }

    @Override
    public IDBSchema getWrapper() {
        return this;
    }

    @Override
    public IDBSchemaElement getParent() {
        return DelegatingDBSchema.wrap(this.getDelegate().getParent());
    }

    @Override
    public IDBTable addTable(String name) {
        return DelegatingDBSchema.wrap(this.getDelegate().addTable(name));
    }

    @Override
    public IDBTable removeTable(String name) {
        return DelegatingDBSchema.wrap(this.getDelegate().removeTable(name));
    }

    @Override
    public String createIndexName(IDBTable table, IDBIndex.Type type, IDBField[] fields, int position) {
        return this.getDelegate().createIndexName(DelegatingDBSchema.unwrap(table), type, fields, position);
    }

    @Override
    public boolean isLocked() {
        return this.getDelegate().isLocked();
    }

    @Override
    public boolean lock() {
        return this.getDelegate().lock();
    }

    @Override
    public <T extends IDBSchemaElement> T findElement(IDBSchemaElement prototype) {
        IDBSchemaElement unwrapped = DelegatingDBSchema.unwrap(prototype);
        return DelegatingDBSchema.wrap(this.getDelegate().findElement(unwrapped));
    }

    @Override
    public boolean unlock() {
        return this.getDelegate().unlock();
    }

    @Override
    public void assertUnlocked() throws DBException {
        this.getDelegate().assertUnlocked();
    }

    @Override
    public IDBTable getTableSafe(String name) throws SchemaElementNotFoundException {
        return DelegatingDBSchema.wrap(this.getDelegate().getTableSafe(name));
    }

    @Override
    public IDBTable getTable(String name) {
        return DelegatingDBSchema.wrap(this.getDelegate().getTable(name));
    }

    @Override
    public IDBTable[] getTables() {
        IDBTable[] tables = this.getDelegate().getTables();
        IDBTable[] wrappers = new IDBTable[tables.length];
        int i = 0;
        while (i < tables.length) {
            wrappers[i] = DelegatingDBSchema.wrap(tables[i]);
            ++i;
        }
        return wrappers;
    }

    @Override
    public Set<IDBTable> create(IDBAdapter dbAdapter, Connection connection) throws DBException {
        return DelegatingDBSchema.wrap(this.getDelegate().create(dbAdapter, connection));
    }

    @Override
    public Set<IDBTable> create(IDBAdapter dbAdapter, DataSource dataSource) throws DBException {
        return DelegatingDBSchema.wrap(this.getDelegate().create(dbAdapter, dataSource));
    }

    @Override
    public Set<IDBTable> create(IDBAdapter dbAdapter, IDBConnectionProvider connectionProvider) throws DBException {
        return DelegatingDBSchema.wrap(this.getDelegate().create(dbAdapter, connectionProvider));
    }

    @Override
    public void drop(IDBAdapter dbAdapter, Connection connection) throws DBException {
        this.getDelegate().drop(dbAdapter, connection);
    }

    @Override
    public void drop(IDBAdapter dbAdapter, DataSource dataSource) throws DBException {
        this.getDelegate().drop(dbAdapter, dataSource);
    }

    @Override
    public void drop(IDBAdapter dbAdapter, IDBConnectionProvider connectionProvider) throws DBException {
        this.getDelegate().drop(dbAdapter, connectionProvider);
    }

    @Override
    public void export(Connection connection, PrintStream out) throws DBException {
        this.getDelegate().export(connection, out);
    }

    @Override
    public void export(DataSource dataSource, PrintStream out) throws DBException {
        this.getDelegate().export(dataSource, out);
    }

    @Override
    public void export(IDBConnectionProvider connectionProvider, PrintStream out) throws DBException {
        this.getDelegate().export(connectionProvider, out);
    }

    @Override
    public IDBSchemaDelta compare(IDBSchema oldSchema) {
        return this.getDelegate().compare(DelegatingDBSchema.unwrap(oldSchema));
    }

    private static Set<IDBTable> wrap(Set<IDBTable> tables) {
        return DelegatingDBSchema.wrap(tables, new HashSet());
    }
}

