/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.extension.glazedlists;

import ca.odell.glazedlists.gui.AdvancedTableFormat;
import java.util.Comparator;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.NullComparator;
import org.eclipse.nebula.widgets.nattable.data.IColumnAccessor;
import org.eclipse.nebula.widgets.nattable.data.IColumnPropertyAccessor;
import org.eclipse.nebula.widgets.nattable.data.IColumnPropertyResolver;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.sort.SortConfigAttributes;

public class NatColumnTableFormat<R>
implements AdvancedTableFormat<R> {
    private final IColumnPropertyResolver columnPropertyResolver;
    private IColumnAccessor<R> columnAccessor;
    private IConfigRegistry configRegistry;
    private final ILayer columnHeaderDataLayer;

    public NatColumnTableFormat(IColumnPropertyAccessor<R> columnPropertyAccessor, IConfigRegistry configRegistry, ILayer dataLayer) {
        this((IColumnAccessor<R>)columnPropertyAccessor, (IColumnPropertyResolver)columnPropertyAccessor, configRegistry, dataLayer);
    }

    public NatColumnTableFormat(IColumnAccessor<R> columnAccessor, IColumnPropertyResolver columnPropertyResolver, IConfigRegistry configRegistry, ILayer columnHeaderDataLayer) {
        this.columnPropertyResolver = columnPropertyResolver;
        this.columnAccessor = columnAccessor;
        this.configRegistry = configRegistry;
        this.columnHeaderDataLayer = columnHeaderDataLayer;
    }

    public Class<?> getColumnClass(int col) {
        return null;
    }

    public Comparator<?> getColumnComparator(int col) {
        ILayerCell cell = this.columnHeaderDataLayer.getCellByPosition(col, 0);
        if (cell == null) {
            return null;
        }
        Comparator comparator = (Comparator)this.configRegistry.getConfigAttribute(SortConfigAttributes.SORT_COMPARATOR, cell.getDisplayMode(), cell.getConfigLabels().getLabels());
        return comparator instanceof NullComparator ? null : comparator;
    }

    public String getColumnName(int col) {
        return this.columnPropertyResolver.getColumnProperty(col);
    }

    public int getColumnCount() {
        return this.columnAccessor.getColumnCount();
    }

    public Object getColumnValue(R rowObj, int col) {
        return this.columnAccessor.getDataValue(rowObj, col);
    }
}

