/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.kdm.uml2converter.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.m2m.atl.core.ATLCoreException;
import org.eclipse.m2m.atl.core.IExtractor;
import org.eclipse.m2m.atl.core.IInjector;
import org.eclipse.m2m.atl.core.IModel;
import org.eclipse.m2m.atl.core.IReferenceModel;
import org.eclipse.m2m.atl.core.ModelFactory;
import org.eclipse.m2m.atl.core.emf.EMFModel;
import org.eclipse.m2m.atl.core.launch.ILauncher;
import org.eclipse.m2m.atl.core.service.CoreService;
import org.eclipse.m2m.atl.engine.parser.AtlParser;
import org.eclipse.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.modisco.kdm.uml2converter.internal.KdmToUml2Activator;
import org.eclipse.modisco.kdm.uml2converter.internal.Messages;
import org.eclipse.modisco.util.atl.core.internal.AtlLaunchHelper;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

@Deprecated
public class KdmToUmlConverter {
    public static final String MM_LOCATION = "resources/metamodels";
    public static final String TRANSFO_LOCATION = "resources/transformations";
    public static final String KDM_MM_URI = "http://www.eclipse.org/MoDisco/kdm/action";
    public static final String UML_MM_URI = "http://www.eclipse.org/uml2/5.0.0/UML";
    private static final String ATL_MM_PATH = "http://www.eclipse.org/gmt/2005/ATL";

    public Resource[] getUML2ModelFromKDMModel(Resource kdmModel, boolean generateTraces) throws IOException, ATLCoreException {
        Resource[] result = null;
        if (generateTraces) {
            URL transformation = this.getClass().getResource("resources/transformations/KDMtoUMLWithTraces.asm");
            result = this.getUML2ModelFromKDMModelWithCustomTransformation(kdmModel, generateTraces, transformation);
        } else {
            URL transformation = this.getClass().getResource("resources/transformations/KDMtoUML.asm");
            result = this.getUML2ModelFromKDMModelWithCustomTransformation(kdmModel, generateTraces, transformation);
        }
        return result;
    }

    public Resource[] getUML2ModelFromKDMModelWithCustomTransformation(Resource kdmSourceModel, boolean generateTraces, URL transformation) throws IOException, ATLCoreException {
        ArrayList<AtlLaunchHelper.ModelInfo> inputModels = new ArrayList<AtlLaunchHelper.ModelInfo>();
        ArrayList<AtlLaunchHelper.ModelInfo> outputModels = new ArrayList<AtlLaunchHelper.ModelInfo>();
        URI umlTargetModelUri = URI.createURI((String)"memory:/umlTargetModel");
        AtlLaunchHelper.ModelInfo inputModel = new AtlLaunchHelper.ModelInfo("kdmInput", kdmSourceModel.getURI(), kdmSourceModel, "kdm", URI.createURI((String)KDM_MM_URI));
        inputModels.add(inputModel);
        AtlLaunchHelper.ModelInfo outputModel = new AtlLaunchHelper.ModelInfo("umlOutput", umlTargetModelUri, kdmSourceModel, "uml", URI.createURI((String)UML_MM_URI));
        outputModels.add(outputModel);
        if (generateTraces) {
            URL mmwMMURL = this.getClass().getResource("resources/metamodels/mmw_traceability.ecore");
            AtlLaunchHelper.ModelInfo traceModel = new AtlLaunchHelper.ModelInfo("trace", umlTargetModelUri.trimFileExtension().appendFileExtension("trace.amw"), null, "Trace", URI.createURI((String)mmwMMURL.toString()));
            outputModels.add(traceModel);
        }
        AtlLaunchHelper atlHelper = new AtlLaunchHelper();
        List results = atlHelper.runTransformation(transformation, inputModels, outputModels);
        Resource[] resultsArray = new Resource[results.size()];
        results.toArray(resultsArray);
        return resultsArray;
    }

    public final void basicExportKdmToUmlTransformation(IFile file, IProgressMonitor monitor) throws CoreException {
        InputStream transfoFileStream = this.getClass().getResourceAsStream("resources/transformations/KDMtoUML.atl");
        if (file.exists()) {
            file.setContents(transfoFileStream, 1, monitor);
        } else {
            file.create(transfoFileStream, 1, monitor);
        }
    }

    public void exportKdmToUmlTransformation(IPath pathParameter) {
        IPath path = pathParameter;
        if (path.getFileExtension() == null || !path.getFileExtension().equals("atl")) {
            path = path.addFileExtension("atl");
        }
        final IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
        final IProject destinationProject = file.getProject();
        Job job = new Job(Messages.KDMtoUML2Converter_27){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    KdmToUmlConverter.this.basicExportKdmToUmlTransformation(file, monitor);
                }
                catch (CoreException e) {
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        try {
                            destinationProject.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                            IDE.openEditor((IWorkbenchPage)page, (IFile)file);
                        }
                        catch (Exception e) {
                            MoDiscoLogger.logError((Throwable)e, (Plugin)KdmToUml2Activator.getDefault());
                        }
                    }
                });
            }
        });
        job.schedule();
    }

    public IFile instrumentAtlTranformationWithTraceability(InputStream sourceTransformation, URI atlFileUri) throws ATLCoreException {
        IModel targetModel;
        URI sourceModelUri = atlFileUri.trimFileExtension().appendFragment("-ATL_source").appendFileExtension("ecore");
        URI targetModelUri = atlFileUri.trimFileExtension().appendFragment("-ATL_target").appendFileExtension("ecore");
        IModel sourceModel = AtlParser.getDefault().parseToModel(sourceTransformation);
        if (sourceModel instanceof EMFModel) {
            EMFModel ecoreSourceModel = (EMFModel)sourceModel;
            try {
                ecoreSourceModel.getResource().setURI(sourceModelUri);
                ecoreSourceModel.getResource().save(null);
            }
            catch (IOException e) {
                MoDiscoLogger.logError((Throwable)e, (Plugin)KdmToUml2Activator.getDefault());
            }
        }
        if ((targetModel = this.addTraceability(sourceModel, sourceModelUri, targetModelUri)) instanceof EMFModel) {
            EMFModel ecoreTargetModel = (EMFModel)targetModel;
            try {
                ecoreTargetModel.getResource().setURI(targetModelUri);
                ecoreTargetModel.getResource().save(null);
            }
            catch (IOException e) {
                MoDiscoLogger.logError((Throwable)e, (Plugin)KdmToUml2Activator.getDefault());
            }
        }
        IFile result = null;
        try {
            result = KdmToUmlConverter.parseFromModel(targetModel, atlFileUri);
        }
        catch (IOException e) {
            MoDiscoLogger.logError((Throwable)e, (Plugin)KdmToUml2Activator.getDefault());
        }
        return result;
    }

    public final IModel addTraceability(IModel sourceModel, URI sourceModelUri, URI targetModelUri) throws ATLCoreException {
        final URL transformation = this.getClass().getResource("resources/transformations/ATL2WTracer.asm");
        HashMap<String, String> modelHandlers = new HashMap<String, String>();
        String atlMetaModelName = "ATL";
        modelHandlers.put(atlMetaModelName, "EMF");
        final HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("modelHandlers", modelHandlers);
        options.put("IS_REFINING", true);
        String launcherName = "EMF-specific VM";
        final ILauncher launcher = CoreService.getLauncher((String)launcherName);
        launcher.initialize(options);
        ModelFactory factory = CoreService.getModelFactory((String)launcher.getDefaultModelFactoryName());
        IInjector injector = CoreService.getInjector((String)factory.getDefaultInjectorName());
        IExtractor extractor = CoreService.getExtractor((String)factory.getDefaultExtractorName());
        IReferenceModel atlMM = factory.getBuiltInResource("ATL.ecore");
        HashMap<String, Object> modelOptions = new HashMap<String, Object>();
        String inModelName = "IN";
        modelOptions.put("modelName", inModelName);
        modelOptions.put("path", sourceModelUri.toString());
        modelOptions.put("newModel", false);
        IModel input = factory.newModel(atlMM, modelOptions);
        injector.inject(input, sourceModelUri.toString());
        launcher.addInModel(input, inModelName, atlMetaModelName);
        modelOptions = new HashMap();
        inModelName = "OUT";
        modelOptions.put("modelName", inModelName);
        modelOptions.put("path", targetModelUri.toString());
        modelOptions.put("newModel", true);
        IModel outputInstance = factory.newModel(atlMM, modelOptions);
        launcher.addOutModel(outputInstance, inModelName, atlMetaModelName);
        options.put("continueAfterError", "true");
        options.put("printExecutionTime", "true");
        Job transformationThread = new Job(Messages.KDMtoUML2Converter_42){

            protected IStatus run(IProgressMonitor monitor) {
                IStatus result = Status.OK_STATUS;
                try {
                    launcher.launch("run", monitor, options, new Object[]{transformation.openStream()});
                }
                catch (IOException e) {
                    result = Status.CANCEL_STATUS;
                    MoDiscoLogger.logError((Throwable)e, (Plugin)KdmToUml2Activator.getDefault());
                }
                return result;
            }
        };
        transformationThread.schedule();
        try {
            transformationThread.join();
        }
        catch (InterruptedException e) {
            MoDiscoLogger.logError((Throwable)e, (Plugin)KdmToUml2Activator.getDefault());
        }
        extractor.extract(outputInstance, targetModelUri.toString());
        return outputInstance;
    }

    public static final IFile parseFromModel(IModel transformationModel, URI atlFileUri) throws IOException {
        IFile file = null;
        Path atlFilePath = null;
        if (atlFileUri.isPlatformResource()) {
            atlFilePath = new Path(atlFileUri.toPlatformString(false));
            file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)atlFilePath);
        } else {
            atlFilePath = new Path(atlFileUri.toFileString());
            file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)atlFilePath);
        }
        if (file != null) {
            try {
                AtlParser.getDefault().extract(transformationModel, file.getLocation().toString());
            }
            catch (Exception e) {
                MoDiscoLogger.logError((Throwable)e, (Plugin)KdmToUml2Activator.getDefault());
            }
            try {
                file.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                MoDiscoLogger.logError((Throwable)e, (Plugin)KdmToUml2Activator.getDefault());
            }
        } else {
            MoDiscoLogger.logError((String)"Uri invalid", (Plugin)KdmToUml2Activator.getDefault());
        }
        return file;
    }
}

