/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.utils;

import java.util.Iterator;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.IParamDescriptionPO;
import org.eclipse.jubula.client.core.model.IParamNodePO;
import org.eclipse.jubula.client.core.model.IRefTestSuitePO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;

public class NodeNameUtil {
    protected static final String CLOSE_BRACKET = "]";
    protected static final String OPEN_BRACKET = " [";
    protected static final String SEPARATOR = "; ";
    private static final String UNNAMED_NODE = Messages.UnnamedNode;

    private NodeNameUtil() {
    }

    public static String getText(IRefTestSuitePO testSuitRef) {
        StringBuilder nameBuilder = new StringBuilder();
        String refRealName = testSuitRef.getRealName();
        if (!StringUtils.isBlank((String)refRealName)) {
            nameBuilder.append(refRealName);
            ITestSuitePO testSuite = testSuitRef.getTestSuite();
            String testSuiteName = testSuite != null ? testSuite.getName() : "";
            NodeNameUtil.appendSpecName(nameBuilder, testSuiteName);
        } else {
            String testSuiteRefName = testSuitRef != null ? testSuitRef.getTestSuite().getName() : UNNAMED_NODE;
            NodeNameUtil.createSpecName(nameBuilder, testSuiteRefName);
        }
        return nameBuilder.toString();
    }

    public static String getText(IExecTestCasePO testCaseRef, boolean params) {
        StringBuilder nameBuilder = new StringBuilder();
        String realName = testCaseRef.getRealName();
        if (!StringUtils.isBlank((String)realName)) {
            nameBuilder.append(realName);
            ISpecTestCasePO testCase = testCaseRef.getSpecTestCase();
            String testCaseName = testCase != null ? testCase.getName() : "";
            NodeNameUtil.appendSpecName(nameBuilder, testCaseName);
        } else {
            ISpecTestCasePO testCase = testCaseRef.getSpecTestCase();
            String testCaseName = testCase != null ? testCase.getName() : "";
            NodeNameUtil.createSpecName(nameBuilder, testCaseName);
        }
        if (params) {
            nameBuilder.append(NodeNameUtil.getParameterString(testCaseRef));
        }
        return nameBuilder.toString();
    }

    public static String getText(ISpecTestCasePO testCase, boolean params) {
        if (!params) {
            return testCase.getName();
        }
        return String.valueOf(testCase.getName()) + NodeNameUtil.getParameterString(testCase);
    }

    private static String getParameterString(IParamNodePO paramNode) {
        StringBuilder nameBuilder = new StringBuilder();
        Iterator<IParamDescriptionPO> iter = paramNode.getParameterList().iterator();
        boolean parameterExist = false;
        if (iter.hasNext()) {
            parameterExist = true;
            nameBuilder.append(OPEN_BRACKET);
        }
        if (iter.hasNext()) {
            while (iter.hasNext()) {
                IParamDescriptionPO descr = iter.next();
                nameBuilder.append(descr.getName());
                if (!iter.hasNext()) continue;
                nameBuilder.append(SEPARATOR);
            }
        }
        if (parameterExist) {
            nameBuilder.append(CLOSE_BRACKET);
        }
        return nameBuilder.toString();
    }

    private static void createSpecName(StringBuilder nameBuilder, String refName) {
        nameBuilder.append("<").append(refName).append(">");
    }

    private static void appendSpecName(StringBuilder nameBuilder, String specName) {
        nameBuilder.append(" ").append("(").append(specName).append(")");
    }
}

