/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.generic.ui.internal;

import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jst.server.generic.core.internal.GenericServerRuntime;
import org.eclipse.jst.server.generic.servertype.definition.ServerRuntime;
import org.eclipse.jst.server.generic.ui.internal.GenericServerComposite;
import org.eclipse.jst.server.generic.ui.internal.GenericServerCompositeDecorator;
import org.eclipse.jst.server.generic.ui.internal.GenericServerUIMessages;
import org.eclipse.jst.server.generic.ui.internal.InstallableRuntimeDecorator;
import org.eclipse.jst.server.generic.ui.internal.JRESelectDecorator;
import org.eclipse.jst.server.generic.ui.internal.ServerDefinitionTypeAwareWizardFragment;
import org.eclipse.jst.server.generic.ui.internal.ServerTypeDefinitionRuntimeDecorator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.internal.IInstallableRuntime;
import org.eclipse.wst.server.core.internal.ServerPlugin;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;

public class GenericServerRuntimeWizardFragment
extends ServerDefinitionTypeAwareWizardFragment {
    private GenericServerCompositeDecorator[] fDecorators;

    public boolean isComplete() {
        GenericServerRuntime runtime = this.getRuntimeDelegate();
        if (runtime == null) {
            return false;
        }
        IStatus status = runtime.validate();
        return status != null && status.isOK();
    }

    @Override
    public void createContent(Composite parent, IWizardHandle handle) {
        IInstallableRuntime ir;
        Map properties = null;
        ServerRuntime definition = null;
        if (this.getRuntimeDelegate() != null) {
            properties = this.getRuntimeDelegate().getServerInstanceProperties();
            definition = this.getServerTypeDefinition(this.getServerDefinitionId(), properties);
        }
        if ((ir = ServerPlugin.findInstallableRuntime((String)this.getRuntimeDelegate().getRuntime().getRuntimeType().getId())) != null) {
            this.fDecorators = new GenericServerCompositeDecorator[3];
            this.fDecorators[0] = new JRESelectDecorator(this.getRuntimeDelegate(), this.getWizard());
            this.fDecorators[1] = new ServerTypeDefinitionRuntimeDecorator(definition, properties, this.getWizard(), this.getRuntimeDelegate());
            this.fDecorators[2] = new InstallableRuntimeDecorator(this.getWizard(), this.getRuntimeDelegate());
        } else {
            this.fDecorators = new GenericServerCompositeDecorator[2];
            this.fDecorators[0] = new JRESelectDecorator(this.getRuntimeDelegate(), this.getWizard());
            this.fDecorators[1] = new ServerTypeDefinitionRuntimeDecorator(definition, properties, this.getWizard(), this.getRuntimeDelegate());
        }
        new GenericServerComposite(parent, this.fDecorators);
    }

    private String getServerDefinitionId() {
        String currentDefinition = null;
        if (this.getRuntimeDelegate() != null) {
            currentDefinition = this.getRuntimeDelegate().getRuntime().getRuntimeType().getId();
        }
        if (currentDefinition != null && currentDefinition.length() > 0) {
            return currentDefinition;
        }
        return null;
    }

    public void enter() {
        if (this.getRuntimeDelegate() != null) {
            this.getRuntimeDelegate().getRuntimeWorkingCopy().setName(this.createName());
        }
        int i = 0;
        while (i < this.fDecorators.length) {
            if (this.fDecorators[i].validate()) {
                return;
            }
            ++i;
        }
    }

    public void exit() {
        int i = 0;
        while (i < this.fDecorators.length) {
            if (this.fDecorators[i].validate()) {
                return;
            }
            ++i;
        }
    }

    private String createName() {
        GenericServerRuntime dl = this.getRuntimeDelegate();
        IRuntimeType runtimeType = dl.getRuntime().getRuntimeType();
        String name = NLS.bind((String)GenericServerUIMessages.runtimeName, (Object)runtimeType.getName());
        IRuntime[] list = ServerCore.getRuntimes();
        int suffix = 1;
        String suffixName = name;
        int i = 0;
        while (i < list.length) {
            if ((list[i].getName().equals(name) || list[i].getName().equals(suffixName)) && !list[i].equals(dl.getRuntime())) {
                ++suffix;
            }
            suffixName = String.valueOf(name) + ' ' + suffix;
            ++i;
        }
        if (suffix > 1) {
            return suffixName;
        }
        return name;
    }

    private GenericServerRuntime getRuntimeDelegate() {
        IRuntimeWorkingCopy wc = (IRuntimeWorkingCopy)this.getTaskModel().getObject("runtime");
        if (wc == null) {
            return null;
        }
        return (GenericServerRuntime)wc.loadAdapter(GenericServerRuntime.class, (IProgressMonitor)new NullProgressMonitor());
    }

    @Override
    public String description() {
        String rName = this.getRuntimeName();
        if (rName == null || rName.length() < 1) {
            rName = "Generic";
        }
        return NLS.bind((String)GenericServerUIMessages.runtimeWizardDescription, (Object)rName);
    }

    @Override
    public String title() {
        String rName = this.getRuntimeName();
        if (rName == null || rName.length() < 1) {
            rName = "Generic";
        }
        return NLS.bind((String)GenericServerUIMessages.runtimeWizardTitle, (Object)rName);
    }

    private String getRuntimeName() {
        if (this.getRuntimeDelegate() != null && this.getRuntimeDelegate().getRuntime() != null) {
            return this.getRuntimeDelegate().getRuntime().getName();
        }
        return null;
    }
}

