/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.discovery;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.epp.internal.mpc.ui.MarketplaceClientUi;
import org.eclipse.epp.internal.mpc.ui.MarketplaceClientUiPlugin;
import org.eclipse.epp.internal.mpc.ui.Messages;
import org.eclipse.epp.internal.mpc.ui.discovery.ShowFileSupportProposalsJob;
import org.eclipse.epp.mpc.core.model.INode;
import org.eclipse.epp.mpc.core.model.ISearchResult;
import org.eclipse.epp.mpc.core.model.ITag;
import org.eclipse.epp.mpc.core.service.IMarketplaceService;
import org.eclipse.epp.mpc.core.service.IMarketplaceServiceLocator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorRegistry;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

final class DiscoverFileSupportJob
extends Job {
    private final Display display = Display.getCurrent();
    private final IEditorRegistry editorRegistry;
    private final IEditorDescriptor defaultDescriptor;
    private final String fileName;

    public DiscoverFileSupportJob(IEditorRegistry editorRegistry, IEditorDescriptor defaultDescriptor, String fileName) {
        super(NLS.bind((String)Messages.AskMarketPlaceForFileSupportStrategy_jobName, (Object)DiscoverFileSupportJob.getFileExtensionLabel(fileName)));
        this.editorRegistry = editorRegistry;
        this.defaultDescriptor = defaultDescriptor;
        this.fileName = fileName;
    }

    protected IStatus run(IProgressMonitor monitor) {
        BundleContext bundleContext = MarketplaceClientUiPlugin.getBundleContext();
        ServiceReference locatorReference = bundleContext.getServiceReference(IMarketplaceServiceLocator.class);
        IMarketplaceServiceLocator locator = (IMarketplaceServiceLocator)bundleContext.getService(locatorReference);
        IMarketplaceService marketplaceService = locator.getDefaultMarketplaceService();
        try {
            IStatus iStatus = this.run(marketplaceService, monitor);
            return iStatus;
        }
        finally {
            bundleContext.ungetService(locatorReference);
        }
    }

    private IStatus run(IMarketplaceService marketplaceService, IProgressMonitor monitor) {
        List<? extends INode> nodes;
        List<String> fileExtensions = DiscoverFileSupportJob.getFileExtensions(this.fileName);
        ArrayList<String> fileExtensionTags = new ArrayList<String>();
        for (String string : fileExtensions) {
            fileExtensionTags.add(DiscoverFileSupportJob.getFileExtensionTag(string));
        }
        try {
            ISearchResult searchResult = marketplaceService.tagged(fileExtensionTags, monitor);
            nodes = DiscoverFileSupportJob.orderNodesByTagSubExtensionCount(searchResult.getNodes(), fileExtensionTags);
        }
        catch (Exception ex) {
            Status status = new Status(4, "org.eclipse.epp.mpc.ui", NLS.bind((String)Messages.DiscoverFileSupportJob_discoveryFailed, (Object)DiscoverFileSupportJob.getFileExtensionLabel(this.fileName)), (Throwable)ex);
            MarketplaceClientUi.getLog().log((IStatus)status);
            return Status.CANCEL_STATUS;
        }
        if (nodes.isEmpty()) {
            return Status.OK_STATUS;
        }
        ShowFileSupportProposalsJob openDialog = new ShowFileSupportProposalsJob(this.fileName, nodes, this.editorRegistry, this.defaultDescriptor, this.display);
        openDialog.setPriority(10);
        openDialog.setSystem(true);
        openDialog.schedule();
        return Status.OK_STATUS;
    }

    private static String getFileExtensionTag(String fileExtension) {
        return "fileExtension_" + fileExtension;
    }

    private static List<? extends INode> orderNodesByTagSubExtensionCount(List<? extends INode> nodes, List<String> fileExtensionTags) {
        Collections.sort(fileExtensionTags, (s1, s2) -> s2.length() - s2.replace(".", "").length() - (s1.length() - s1.replace(".", "").length()));
        HashMap nodesByTags = new HashMap();
        block0: for (INode iNode : nodes) {
            if (iNode.getTags() == null || iNode.getTags().getTags() == null) continue;
            for (ITag nodeTag : iNode.getTags().getTags()) {
                boolean foundTag = false;
                for (String tag : fileExtensionTags) {
                    if (!nodeTag.getName().equals(tag)) continue;
                    if (nodesByTags.containsKey(tag)) {
                        ((List)nodesByTags.get(tag)).add(iNode);
                    } else {
                        ArrayList<INode> newNodeList = new ArrayList<INode>();
                        newNodeList.add(iNode);
                        nodesByTags.put(tag, newNodeList);
                    }
                    foundTag = true;
                    break;
                }
                if (foundTag) continue block0;
            }
        }
        ArrayList arrayList = new ArrayList();
        for (String tag : fileExtensionTags) {
            if (!nodesByTags.containsKey(tag)) continue;
            arrayList.addAll((Collection)nodesByTags.get(tag));
        }
        return nodes;
    }

    static String getFileExtensionLabel(String fileName) {
        return fileName.indexOf(46) == -1 ? fileName : String.valueOf('*') + fileName.substring(fileName.lastIndexOf(46), fileName.length());
    }

    static List<String> getFileExtensions(String fileName) {
        ArrayList<String> extensions = new ArrayList<String>();
        while (fileName.length() > 0) {
            extensions.add(fileName);
            if (fileName.indexOf(46) == -1) break;
            fileName = fileName.substring(fileName.indexOf(46) + 1, fileName.length());
        }
        return extensions;
    }
}

