/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.net4j.protocol;

import java.io.IOException;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.common.protocol.CDOProtocolConstants;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionCache;
import org.eclipse.emf.cdo.common.revision.CDORevisionHandler;
import org.eclipse.emf.cdo.server.IUnit;
import org.eclipse.emf.cdo.server.IView;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerProtocol;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerReadIndicationWithMonitoring;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionCache;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.spi.server.InternalUnitManager;
import org.eclipse.emf.cdo.spi.server.InternalView;
import org.eclipse.net4j.util.om.monitor.OMMonitor;

public class UnitIndication
extends CDOServerReadIndicationWithMonitoring {
    private int viewID;
    private CDOID rootID;
    private CDOProtocolConstants.UnitOpcode opcode;

    public UnitIndication(CDOServerProtocol protocol) {
        super(protocol, (short)62);
    }

    protected int getIndicatingWorkPercent() {
        return 1;
    }

    @Override
    protected void indicating(CDODataInput in, OMMonitor monitor) throws Exception {
        this.viewID = in.readXInt();
        this.rootID = in.readCDOID();
        this.opcode = CDOProtocolConstants.UnitOpcode.values()[in.readByte()];
    }

    @Override
    protected void responding(CDODataOutput out, OMMonitor monitor) throws Exception {
        final InternalView view = this.getView(this.viewID);
        InternalRepository repository = this.getRepository();
        if (this.opcode == CDOProtocolConstants.UnitOpcode.CHECK) {
            InternalUnitManager unitManager = repository.getUnitManager();
            boolean isUnit = unitManager.isUnit(this.rootID);
            out.writeBoolean(isUnit);
            return;
        }
        if (this.opcode == CDOProtocolConstants.UnitOpcode.CLOSE) {
            InternalUnitManager unitManager = repository.getUnitManager();
            IUnit unit = unitManager.getUnit(this.rootID);
            if (unit != null) {
                unit.close((IView)view);
                out.writeBoolean(true);
                return;
            }
            out.writeBoolean(false);
            return;
        }
        InternalCDORevisionCache revisionCache = repository.getRevisionManager().getCache();
        IOException[] ioException = new IOException[1];
        RuntimeException[] runtimeException = new RuntimeException[1];
        monitor.begin();
        OMMonitor.Async async = monitor.forkAsync();
        try {
            boolean success = view.openUnit(this.rootID, this.opcode, new CDORevisionHandler((CDORevisionCache)revisionCache, out, ioException, runtimeException){
                private final /* synthetic */ CDORevisionCache val$revisionCache;
                private final /* synthetic */ CDODataOutput val$out;
                private final /* synthetic */ IOException[] val$ioException;
                private final /* synthetic */ RuntimeException[] val$runtimeException;
                {
                    this.val$revisionCache = cDORevisionCache;
                    this.val$out = cDODataOutput;
                    this.val$ioException = iOExceptionArray;
                    this.val$runtimeException = runtimeExceptionArray;
                }

                public boolean handleRevision(CDORevision revision) {
                    try {
                        view.unsubscribe(revision.getID());
                        this.val$revisionCache.addRevision(revision);
                        this.val$out.writeCDORevision(revision, -1);
                        return true;
                    }
                    catch (IOException ex) {
                        this.val$ioException[0] = ex;
                    }
                    catch (RuntimeException ex) {
                        this.val$runtimeException[0] = ex;
                    }
                    return false;
                }
            }, monitor);
            if (ioException[0] != null) {
                throw ioException[0];
            }
            if (runtimeException[0] != null) {
                throw runtimeException[0];
            }
            out.writeCDORevision(null, -1);
            out.writeBoolean(success);
        }
        finally {
            async.stop();
            monitor.done();
        }
    }
}

