/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.figures;

import java.util.List;
import org.eclipse.bpel.model.EventHandler;
import org.eclipse.bpel.model.FaultHandler;
import org.eclipse.bpel.ui.editparts.ProcessEditPart;
import org.eclipse.bpel.ui.editparts.StartNodeEditPart;
import org.eclipse.bpel.ui.figures.HandlerLinkerAdapter;
import org.eclipse.bpel.ui.figures.ManhattanConnectionRouterEx;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Ray;
import org.eclipse.gef.EditPart;

public class ProcessHandlerLinker
extends HandlerLinkerAdapter {
    private ProcessEditPart process;
    private StartNodeEditPart snep;

    public ProcessHandlerLinker(ProcessEditPart processEditPart) {
        super(processEditPart);
        this.process = processEditPart;
    }

    @Override
    protected EventHandler getEventHandler() {
        return this.process.getEventHandler();
    }

    @Override
    protected FaultHandler getFaultHandler() {
        return this.process.getFaultHandler();
    }

    @Override
    protected int getEHTargetAnchorLoc() {
        return 2;
    }

    @Override
    protected boolean isShowEH() {
        return this.process.isShowEH();
    }

    @Override
    protected boolean isShowFH() {
        return this.process.isShowFH();
    }

    private StartNodeEditPart getStartNodeEditPart() {
        if (this.snep == null) {
            List children = this.process.getChildren();
            for (EditPart child : children) {
                if (!(child instanceof StartNodeEditPart)) continue;
                this.snep = (StartNodeEditPart)child;
            }
        }
        return this.snep;
    }

    @Override
    protected Ray getEHRoutingEndConstraint() {
        return ManhattanConnectionRouterEx.LEFT;
    }

    @Override
    protected IFigure getEHFigure() {
        return this.getStartNodeEditPart().getEventImageFigure();
    }

    @Override
    protected IFigure getFHFigure() {
        return this.getStartNodeEditPart().getFaultImageFigure();
    }
}

