/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge.svg12;

import java.util.ArrayList;
import org.apache.batik.bridge.svg12.AbstractContentSelector;
import org.apache.batik.bridge.svg12.ContentManager;
import org.apache.batik.dom.svg12.XBLOMContentElement;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DefaultContentSelector
extends AbstractContentSelector {
    protected SelectedNodes selectedContent;

    public DefaultContentSelector(ContentManager cm, XBLOMContentElement content, Element bound) {
        super(cm, content, bound);
    }

    public NodeList getSelectedContent() {
        if (this.selectedContent == null) {
            this.selectedContent = new SelectedNodes();
        }
        return this.selectedContent;
    }

    boolean update() {
        if (this.selectedContent == null) {
            this.selectedContent = new SelectedNodes();
            return true;
        }
        return this.selectedContent.update();
    }

    protected class SelectedNodes
    implements NodeList {
        protected ArrayList nodes = new ArrayList(10);

        public SelectedNodes() {
            this.update();
        }

        protected boolean update() {
            ArrayList oldNodes = (ArrayList)this.nodes.clone();
            this.nodes.clear();
            Node n = DefaultContentSelector.this.boundElement.getFirstChild();
            while (n != null) {
                if (!DefaultContentSelector.this.isSelected(n)) {
                    this.nodes.add(n);
                }
                n = n.getNextSibling();
            }
            int nodesSize = this.nodes.size();
            if (oldNodes.size() != nodesSize) {
                return true;
            }
            int i = 0;
            while (i < nodesSize) {
                if (oldNodes.get(i) != this.nodes.get(i)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public Node item(int index) {
            if (index < 0 || index >= this.nodes.size()) {
                return null;
            }
            return (Node)this.nodes.get(index);
        }

        public int getLength() {
            return this.nodes.size();
        }
    }
}

