/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.properties;

import org.eclipse.bpel.common.ui.command.ICommandFramework;
import org.eclipse.bpel.common.ui.details.IOngoingChange;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class ChangeTracker {
    protected IOngoingChange fChange;
    protected ICommandFramework fFramework;
    protected boolean fIsTracking;

    public ChangeTracker(Control target, IOngoingChange change, ICommandFramework framework) {
        this(change, framework, target);
    }

    public ChangeTracker(IOngoingChange change, ICommandFramework framework, Control ... targets) {
        this.fChange = change;
        this.fFramework = framework;
        this.fIsTracking = true;
        Control[] controlArray = targets;
        int n = targets.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            this.addListeners(c);
            ++n2;
        }
    }

    public void startTracking() {
        this.fIsTracking = true;
    }

    public void stopTracking() {
        this.fIsTracking = false;
    }

    protected void addListeners(Control target) {
        if (target instanceof Text) {
            this.trackModify(target);
            this.trackFocus(target);
            this.trackEnterKey(target);
        } else if (target instanceof Button) {
            this.trackSelection(target);
        } else if (target instanceof Composite) {
            this.trackFocus(target);
            this.trackSelection(target);
        } else if (target instanceof CCombo) {
            this.trackFocus(target);
            this.trackSelection(target);
            this.trackEnterKey(target);
        } else if (target instanceof Combo) {
            this.trackFocus(target);
            this.trackSelection(target);
            this.trackEnterKey(target);
        }
    }

    protected void trackSelection(Control target) {
        target.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (ChangeTracker.this.fIsTracking) {
                    ChangeTracker.this.fFramework.notifyChangeInProgress(ChangeTracker.this.fChange);
                    ChangeTracker.this.fFramework.notifyChangeDone(ChangeTracker.this.fChange);
                }
            }
        });
    }

    protected void trackFocus(Control target) {
        target.addListener(16, new Listener(){

            public void handleEvent(Event event) {
                if (ChangeTracker.this.fIsTracking) {
                    ChangeTracker.this.fFramework.notifyChangeDone(ChangeTracker.this.fChange);
                }
            }
        });
    }

    protected void trackEnterKey(Control target) {
        target.addListener(1, new Listener(){

            public void handleEvent(Event event) {
                if (ChangeTracker.this.fIsTracking && event.keyCode == 13) {
                    ChangeTracker.this.fFramework.notifyChangeDone(ChangeTracker.this.fChange);
                }
            }
        });
    }

    protected void trackModify(Control target) {
        target.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                if (ChangeTracker.this.fIsTracking) {
                    ChangeTracker.this.fFramework.notifyChangeInProgress(ChangeTracker.this.fChange);
                }
            }
        });
    }
}

