/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.server;

import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentContentChangeEvent;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@Data
public class Document {
    private final Integer version;
    private final String contents;
    private final boolean printSourceOnError;

    public Document(Integer version, String contents) {
        this(version, contents, true);
    }

    public Document(Integer version, String contents, boolean printSourceOnError) {
        this.version = version;
        this.contents = contents;
        this.printSourceOnError = printSourceOnError;
    }

    public int getOffSet(Position position) throws IndexOutOfBoundsException {
        int l = this.contents.length();
        int NL = 10;
        int line = 0;
        int column = 0;
        for (int i = 0; i < l; ++i) {
            char ch = this.contents.charAt(i);
            if (position.getLine() == line && position.getCharacter() == column) {
                return i;
            }
            if (ch == '\n') {
                ++line;
                column = 0;
                continue;
            }
            ++column;
        }
        if (position.getLine() == line && position.getCharacter() == column) {
            return l;
        }
        String _string = position.toString();
        String _xifexpression = null;
        _xifexpression = this.printSourceOnError ? "" : " text was : " + this.contents;
        String _plus = _string + _xifexpression;
        throw new IndexOutOfBoundsException(_plus);
    }

    public Position getPosition(int offset) throws IndexOutOfBoundsException {
        int l = this.contents.length();
        if (offset < 0 || offset > l) {
            String _xifexpression = null;
            _xifexpression = this.printSourceOnError ? "" : " text was : " + this.contents;
            String _plus = Integer.valueOf(offset) + _xifexpression;
            throw new IndexOutOfBoundsException(_plus);
        }
        int NL = 10;
        int line = 0;
        int column = 0;
        for (int i = 0; i < l; ++i) {
            char ch = this.contents.charAt(i);
            if (i == offset) {
                return new Position(line, column);
            }
            if (ch == '\n') {
                ++line;
                column = 0;
                continue;
            }
            ++column;
        }
        return new Position(line, column);
    }

    public String getLineContent(int lineNumber) throws IndexOutOfBoundsException {
        if (lineNumber < 0) {
            String _xifexpression = null;
            _xifexpression = this.printSourceOnError ? "" : " text was : " + this.contents;
            String _plus = Integer.valueOf(lineNumber) + _xifexpression;
            throw new IndexOutOfBoundsException(_plus);
        }
        int NL = 10;
        int LF = 13;
        int l = this.contents.length();
        StringBuilder lineContent = new StringBuilder();
        int line = 0;
        for (int i = 0; i < l; ++i) {
            if (line > lineNumber) {
                return lineContent.toString();
            }
            char ch = this.contents.charAt(i);
            if (line == lineNumber && ch != '\n' && ch != '\r') {
                lineContent.append(ch);
            }
            if (ch != '\n') continue;
            ++line;
        }
        if (line < lineNumber) {
            String _xifexpression_1 = null;
            _xifexpression_1 = this.printSourceOnError ? "" : " text was : " + this.contents;
            String _plus_1 = Integer.valueOf(lineNumber) + _xifexpression_1;
            throw new IndexOutOfBoundsException(_plus_1);
        }
        return lineContent.toString();
    }

    public int getLineCount() {
        int _line = this.getPosition(this.contents.length()).getLine();
        return _line + 1;
    }

    public String getSubstring(Range range) {
        int start = this.getOffSet(range.getStart());
        int end = this.getOffSet(range.getEnd());
        return this.contents.substring(start, end);
    }

    public Document applyTextDocumentChanges(Iterable<? extends TextDocumentContentChangeEvent> changes) {
        Document currentDocument = this;
        Integer _xifexpression = null;
        _xifexpression = currentDocument.version != null ? Integer.valueOf(currentDocument.version + 1) : null;
        Integer newVersion = _xifexpression;
        for (TextDocumentContentChangeEvent textDocumentContentChangeEvent : changes) {
            Document _document;
            boolean _tripleEquals;
            String _xifexpression_1 = null;
            Range _range = textDocumentContentChangeEvent.getRange();
            boolean bl = _tripleEquals = _range == null;
            if (_tripleEquals) {
                _xifexpression_1 = textDocumentContentChangeEvent.getText();
            } else {
                String _xblockexpression = null;
                int start = currentDocument.getOffSet(textDocumentContentChangeEvent.getRange().getStart());
                int end = currentDocument.getOffSet(textDocumentContentChangeEvent.getRange().getEnd());
                String _substring = currentDocument.contents.substring(0, start);
                String _text = textDocumentContentChangeEvent.getText();
                String _plus = _substring + _text;
                String _substring_1 = currentDocument.contents.substring(end);
                _xifexpression_1 = _xblockexpression = _plus + _substring_1;
            }
            String newContent = _xifexpression_1;
            currentDocument = _document = new Document(newVersion, newContent, this.printSourceOnError);
        }
        return currentDocument;
    }

    public Document applyChanges(Iterable<? extends TextEdit> changes) {
        String newContent = this.contents;
        for (TextEdit textEdit : changes) {
            String _plus_1;
            boolean _tripleEquals;
            Range _range = textEdit.getRange();
            boolean bl = _tripleEquals = _range == null;
            if (_tripleEquals) {
                newContent = textEdit.getNewText();
                continue;
            }
            int start = this.getOffSet(textEdit.getRange().getStart());
            int end = this.getOffSet(textEdit.getRange().getEnd());
            String _substring = newContent.substring(0, start);
            String _newText = textEdit.getNewText();
            String _plus = _substring + _newText;
            String _substring_1 = newContent.substring(end);
            newContent = _plus_1 = _plus + _substring_1;
        }
        Integer _xifexpression = null;
        _xifexpression = this.version != null ? Integer.valueOf(this.version + 1) : null;
        return new Document(_xifexpression, newContent);
    }

    @Pure
    public boolean isPrintSourceOnError() {
        return this.printSourceOnError;
    }

    @Pure
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        result = 31 * result + (this.contents == null ? 0 : this.contents.hashCode());
        return 31 * result + (this.printSourceOnError ? 1231 : 1237);
    }

    @Pure
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Document other = (Document)obj;
        if (this.version == null ? other.version != null : !this.version.equals(other.version)) {
            return false;
        }
        if (this.contents == null ? other.contents != null : !this.contents.equals(other.contents)) {
            return false;
        }
        return other.printSourceOnError == this.printSourceOnError;
    }

    @Pure
    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this);
        b.add("version", (Object)this.version);
        b.add("contents", (Object)this.contents);
        b.add("printSourceOnError", (Object)this.printSourceOnError);
        return b.toString();
    }

    @Pure
    public Integer getVersion() {
        return this.version;
    }

    @Pure
    public String getContents() {
        return this.contents;
    }
}

