/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.terminal.view.ui.tabs;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tm.internal.terminal.control.ITerminalListener2;
import org.eclipse.tm.internal.terminal.provisional.api.TerminalState;
import org.eclipse.tm.terminal.view.ui.nls.Messages;
import org.eclipse.tm.terminal.view.ui.tabs.TabCommandFieldHandler;
import org.eclipse.tm.terminal.view.ui.tabs.TabFolderManager;

public class TabTerminalListener
implements ITerminalListener2 {
    private static final String TAB_TERMINAL_LISTENER = "TabTerminalListener";
    final TabFolderManager tabFolderManager;
    private CTabItem tabItem;
    private final String tabItemTitle;

    static void move(CTabItem fromItem, CTabItem toItem) {
        TabTerminalListener listener = (TabTerminalListener)fromItem.getData(TAB_TERMINAL_LISTENER);
        if (listener != null) {
            listener.attachTo(toItem);
        }
    }

    public TabTerminalListener(TabFolderManager tabFolderManager, CTabItem tabItem) {
        Assert.isNotNull((Object)((Object)tabFolderManager));
        Assert.isNotNull((Object)tabItem);
        this.tabFolderManager = tabFolderManager;
        this.tabItemTitle = tabItem.getText();
        this.attachTo(tabItem);
    }

    private void attachTo(CTabItem item) {
        if (this.tabItem != null) {
            this.tabItem.setData(TAB_TERMINAL_LISTENER, null);
        }
        item.setData(TAB_TERMINAL_LISTENER, (Object)this);
        this.tabItem = item;
    }

    protected final CTabItem getTabItem() {
        return this.tabItem;
    }

    public void setState(TerminalState state) {
        CTabItem item = this.getTabItem();
        if (item == null || item.isDisposed()) {
            return;
        }
        item.getDisplay().asyncExec(() -> {
            String newTitle = this.getTerminalConsoleTabTitle(state);
            if (newTitle != null) {
                item.setText(newTitle);
            }
            TabCommandFieldHandler handler = this.tabFolderManager.getTabCommandFieldHandler(item);
            if (TerminalState.CLOSED.equals(state) && handler != null && handler.hasCommandInputField()) {
                handler.setCommandInputField(false);
                ISelectionProvider provider = this.tabFolderManager.getParentView().getViewSite().getSelectionProvider();
                Assert.isNotNull((Object)provider);
                provider.setSelection(provider.getSelection());
            } else {
                this.tabFolderManager.updateStatusLine();
            }
        });
    }

    protected String getTerminalConsoleTabTitle(TerminalState state) {
        Assert.isNotNull((Object)state);
        Assert.isNotNull((Object)Display.findDisplay((Thread)Thread.currentThread()));
        CTabItem item = this.getTabItem();
        if (item == null || item.isDisposed()) {
            return null;
        }
        String oldTitle = item.getText();
        String newTitle = null;
        if (TerminalState.CLOSED.equals(state)) {
            newTitle = NLS.bind((String)Messages.TabTerminalListener_consoleClosed, (Object)this.tabItemTitle, (Object)this.tabFolderManager.state2msg(item, state));
        } else if (TerminalState.CONNECTING.equals(state)) {
            newTitle = NLS.bind((String)Messages.TabTerminalListener_consoleConnecting, (Object)this.tabItemTitle, (Object)this.tabFolderManager.state2msg(item, state));
        } else if (TerminalState.CONNECTED.equals(state)) {
            newTitle = this.tabItemTitle;
        }
        return newTitle != null && !newTitle.equals(oldTitle) ? newTitle : null;
    }

    public void setTerminalTitle(String title) {
    }

    public void setTerminalSelectionChanged() {
        this.tabFolderManager.fireTerminalSelectionChanged();
    }
}

