/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.terminal.view.ui.activator;

import java.net.URL;
import java.util.ArrayList;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tm.internal.terminal.control.ITerminalViewControl;
import org.eclipse.tm.internal.terminal.provisional.api.TerminalState;
import org.eclipse.tm.terminal.view.core.preferences.ScopedEclipsePreferences;
import org.eclipse.tm.terminal.view.core.tracing.TraceHandler;
import org.eclipse.tm.terminal.view.ui.listeners.WorkbenchWindowListener;
import org.eclipse.tm.terminal.view.ui.view.TerminalsView;
import org.eclipse.tm.terminal.view.ui.view.TerminalsViewMementoHandler;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class UIPlugin
extends AbstractUIPlugin {
    private static UIPlugin plugin;
    private static volatile ScopedEclipsePreferences scopedPreferences;
    private static volatile TraceHandler traceHandler;
    private IWorkbenchListener listener;
    private IWindowListener windowListener;

    public static UIPlugin getDefault() {
        return plugin;
    }

    public static String getUniqueIdentifier() {
        if (UIPlugin.getDefault() != null && UIPlugin.getDefault().getBundle() != null) {
            return UIPlugin.getDefault().getBundle().getSymbolicName();
        }
        return "org.eclipse.tm.terminal.view.ui";
    }

    public static ScopedEclipsePreferences getScopedPreferences() {
        if (scopedPreferences == null) {
            scopedPreferences = new ScopedEclipsePreferences(UIPlugin.getUniqueIdentifier());
        }
        return scopedPreferences;
    }

    public static TraceHandler getTraceHandler() {
        if (traceHandler == null) {
            traceHandler = new TraceHandler(UIPlugin.getUniqueIdentifier());
        }
        return traceHandler;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.listener = new IWorkbenchListener(){

            public boolean preShutdown(IWorkbench workbench, boolean forced) {
                if (workbench != null && workbench.getActiveWorkbenchWindow() != null && workbench.getActiveWorkbenchWindow().getActivePage() != null) {
                    IViewReference[] refs;
                    IViewReference[] iViewReferenceArray = refs = workbench.getActiveWorkbenchWindow().getActivePage().getViewReferences();
                    int n = refs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IViewReference ref = iViewReferenceArray[n2];
                        IViewPart part = ref.getView(false);
                        if (part instanceof TerminalsView) {
                            TerminalsViewMementoHandler mementoHandler;
                            ArrayList<CTabItem> saveables = new ArrayList<CTabItem>();
                            CTabFolder tabFolder = ((TerminalsView)part).getAdapter(CTabFolder.class);
                            if (tabFolder != null && !tabFolder.isDisposed()) {
                                CTabItem[] items;
                                CTabItem[] cTabItemArray = items = tabFolder.getItems();
                                int n3 = items.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    ITerminalViewControl terminal;
                                    CTabItem item = cTabItemArray[n4];
                                    if (!item.isDisposed() && (terminal = (ITerminalViewControl)item.getData()) != null && terminal.getState() == TerminalState.CONNECTED) {
                                        saveables.add(item);
                                    }
                                    ++n4;
                                }
                            }
                            if ((mementoHandler = ((TerminalsView)part).getAdapter(TerminalsViewMementoHandler.class)) != null) {
                                mementoHandler.setSaveables(saveables);
                            }
                        }
                        ++n2;
                    }
                }
                return true;
            }

            public void postShutdown(IWorkbench workbench) {
            }
        };
        PlatformUI.getWorkbench().addWorkbenchListener(this.listener);
        if (this.windowListener == null && PlatformUI.getWorkbench() != null) {
            this.windowListener = new WorkbenchWindowListener();
            PlatformUI.getWorkbench().addWindowListener(this.windowListener);
            this.activateContexts();
        }
    }

    void activateContexts() {
        if (Display.getCurrent() != null) {
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (window != null && this.windowListener != null) {
                this.windowListener.windowOpened(window);
            }
        } else {
            PlatformUI.getWorkbench().getDisplay().asyncExec(() -> this.activateContexts());
        }
    }

    public void stop(BundleContext context) throws Exception {
        if (this.windowListener != null && PlatformUI.getWorkbench() != null) {
            PlatformUI.getWorkbench().removeWindowListener(this.windowListener);
            this.windowListener = null;
        }
        plugin = null;
        scopedPreferences = null;
        traceHandler = null;
        if (this.listener != null) {
            PlatformUI.getWorkbench().removeWorkbenchListener(this.listener);
            this.listener = null;
        }
        super.stop(context);
    }

    protected void initializeImageRegistry(ImageRegistry registry) {
        Bundle bundle = this.getBundle();
        URL url = bundle.getEntry("icons/eview16/console_view.png");
        registry.put("TerminalsView", ImageDescriptor.createFromURL((URL)url));
        url = bundle.getEntry("icons/clcl16/lock_co.png");
        registry.put("ScrollLockAction_hover", ImageDescriptor.createFromURL((URL)url));
        url = bundle.getEntry("icons/elcl16/lock_co.png");
        registry.put("ScrollLockAction_enabled", ImageDescriptor.createFromURL((URL)url));
        url = bundle.getEntry("icons/dlcl16/lock_co.png");
        registry.put("ScrollLockAction_disabled", ImageDescriptor.createFromURL((URL)url));
        url = bundle.getEntry("icons/clcl16/command_input_field.gif");
        registry.put("ToggleCommandField_hover", ImageDescriptor.createFromURL((URL)url));
        url = bundle.getEntry("icons/elcl16/command_input_field.gif");
        registry.put("ToggleCommandField_enabled", ImageDescriptor.createFromURL((URL)url));
        url = bundle.getEntry("icons/dlcl16/command_input_field.gif");
        registry.put("ToggleCommandField_disabled", ImageDescriptor.createFromURL((URL)url));
        url = bundle.getEntry("icons/clcl16/new_terminal_view.gif");
        registry.put("NewTerminalViewAction_hover", ImageDescriptor.createFromURL((URL)url));
        url = bundle.getEntry("icons/elcl16/new_terminal_view.gif");
        registry.put("NewTerminalViewAction_enabled", ImageDescriptor.createFromURL((URL)url));
        url = bundle.getEntry("icons/dlcl16/new_terminal_view.gif");
        registry.put("NewTerminalViewAction_disabled", ImageDescriptor.createFromURL((URL)url));
    }

    public static Image getImage(String key) {
        return UIPlugin.getDefault().getImageRegistry().get(key);
    }

    public static ImageDescriptor getImageDescriptor(String key) {
        return UIPlugin.getDefault().getImageRegistry().getDescriptor(key);
    }
}

