/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.Calendar;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.IEditableContent;
import org.eclipse.compare.IModificationDate;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.resources.mapping.ResourceChangeValidator;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.DefaultTextDoubleClickStrategy;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.revisions.Revision;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.history.IFileHistory;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.history.ITag;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSStatus;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.CVSTeamProvider;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFile;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.ILogEntry;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.Update;
import org.eclipse.team.internal.ccvs.core.filehistory.CVSFileHistory;
import org.eclipse.team.internal.ccvs.core.filehistory.CVSFileRevision;
import org.eclipse.team.internal.ccvs.core.filehistory.CVSLocalFileRevision;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFile;
import org.eclipse.team.internal.ccvs.core.syncinfo.FolderSyncInfo;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;
import org.eclipse.team.internal.ccvs.ui.CVSHistoryFilter;
import org.eclipse.team.internal.ccvs.ui.CVSHistoryFilterAction;
import org.eclipse.team.internal.ccvs.ui.CVSHistorySearchFilter;
import org.eclipse.team.internal.ccvs.ui.CVSHistoryTableProvider;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.TableViewerAction;
import org.eclipse.team.internal.ccvs.ui.TextViewerAction;
import org.eclipse.team.internal.ccvs.ui.actions.CVSAction;
import org.eclipse.team.internal.ccvs.ui.actions.MoveRemoteTagAction;
import org.eclipse.team.internal.ccvs.ui.operations.ITagOperation;
import org.eclipse.team.internal.ccvs.ui.operations.TagInRepositoryOperation;
import org.eclipse.team.internal.ccvs.ui.operations.UpdateOperation;
import org.eclipse.team.internal.core.history.LocalFileRevision;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.actions.CompareRevisionAction;
import org.eclipse.team.internal.ui.actions.OpenRevisionAction;
import org.eclipse.team.internal.ui.actions.OpenWithMenu;
import org.eclipse.team.internal.ui.history.AbstractHistoryCategory;
import org.eclipse.team.internal.ui.history.DateHistoryCategory;
import org.eclipse.team.internal.ui.history.DialogHistoryPageSite;
import org.eclipse.team.internal.ui.history.FileRevisionTypedElement;
import org.eclipse.team.internal.ui.history.GenericHistoryView;
import org.eclipse.team.internal.ui.history.MessageHistoryCategory;
import org.eclipse.team.internal.ui.history.WorkbenchHistoryPageSite;
import org.eclipse.team.internal.ui.synchronize.LocalResourceTypedElement;
import org.eclipse.team.ui.history.HistoryPage;
import org.eclipse.team.ui.history.IHistoryCompareAdapter;
import org.eclipse.team.ui.history.IHistoryPageSite;
import org.eclipse.team.ui.history.RevisionAnnotationController;
import org.eclipse.team.ui.synchronize.SaveableCompareEditorInput;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.OpenAndLinkWithEditorHelper;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.progress.IProgressConstants;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;

public class CVSHistoryPage
extends HistoryPage
implements IAdaptable,
IHistoryCompareAdapter {
    ICVSFile file;
    ICVSFile previousFile;
    IFileRevision currentFileRevision;
    private ITypedElement fileElement;
    CVSFileHistory cvsFileHistory;
    IFileRevision[] entries;
    CVSHistoryTableProvider historyTableProvider;
    private Composite tagAndTextComposite;
    private Composite searchComposite;
    TreeViewer treeViewer;
    TextViewer textViewer;
    TableViewer tagViewer;
    CompareRevisionAction compareAction;
    OpenRevisionAction openAction;
    private OpenWithMenu openWithMenu;
    private CVSHistoryFilterAction cvsHistoryFilter;
    private IAction toggleTextAction;
    private IAction toggleTextWrapAction;
    private IAction toggleListAction;
    private IAction toggleFilterAction;
    private IAction toggleSearchAction;
    private TextViewerAction copyAction;
    private TextViewerAction selectAllAction;
    private Action getContentsAction;
    private Action getRevisionAction;
    private Action refreshAction;
    private TableViewerAction copyTagAction;
    private Action tagWithExistingAction;
    private Action localMode;
    private Action remoteMode;
    private Action remoteLocalMode;
    private Action groupByDateMode;
    private Action collapseAll;
    private Action compareModeAction;
    private SashForm sashForm;
    private SashForm innerSashForm;
    private SashForm searchSashForm;
    private Image branchImage;
    private Image versionImage;
    private IDialogSettings settings;
    protected IFileRevision currentSelection;
    RefreshCVSFileHistory refreshCVSFileHistoryJob;
    boolean shutdown = false;
    boolean localFilteredOut = false;
    boolean remoteFilteredOut = false;
    private HistoryResourceListener resourceListener;
    private boolean compareMode = false;
    public static final int REMOTE_LOCAL_MODE = 0;
    public static final int REMOTE_MODE = 1;
    public static final int LOCAL_MODE = 2;
    private static final String SASH_WEIGHTS = "SASH_WEIGHTS";
    private static final String INNER_SASH_WEIGHTS = "INNER_SASH_WEIGHTS";
    private static final String SASH_WEIGHTS_SEPARATOR = ";";
    private static final String SORT_ORDER_KEY = "SORT_ORDER";
    private static final String CVS_HISTORY_PAGE_SECTION = CVSHistoryPage.class.getName();
    private int currentFilerMode = 0;
    private Text searchField;
    private boolean sortTagsAscending;
    private DisposeListener disposeListener;
    private boolean groupingOn;
    private CVSHistoryFilter historyFilter;
    private CVSHistorySearchFilter searchFilter;
    private RevisionAnnotationController rulerSelectionListener;
    private int refreshRequest = 0;
    private DateFormat dateTimeFormat;
    private String description;

    public CVSHistoryPage(Object object) {
        this.file = CVSHistoryPage.getCVSFile(object);
        IDialogSettings viewsSettings = CVSUIPlugin.getPlugin().getDialogSettings();
        this.settings = viewsSettings.getSection(CVS_HISTORY_PAGE_SECTION);
        if (this.settings == null) {
            this.settings = viewsSettings.addNewSection(CVS_HISTORY_PAGE_SECTION);
        }
        this.sortTagsAscending = this.settings.get(SORT_ORDER_KEY) == null || this.settings.getBoolean(SORT_ORDER_KEY);
    }

    public void createControl(Composite parent) {
        int[] nArray;
        int[] nArray2;
        this.initializeImages();
        this.sashForm = new SashForm(parent, 512);
        this.sashForm.setLayoutData((Object)new GridData(1808));
        this.treeViewer = this.createTree((Composite)this.sashForm);
        this.tagAndTextComposite = new Composite((Composite)this.sashForm, 0);
        this.tagAndTextComposite.setLayout((Layout)new FillLayout());
        this.innerSashForm = new SashForm(this.tagAndTextComposite, 256);
        this.tagViewer = this.createTagTable(this.innerSashForm);
        this.textViewer = this.createText(this.innerSashForm);
        this.searchComposite = new Composite((Composite)this.sashForm, 0);
        this.searchComposite.setLayout((Layout)new FillLayout());
        this.searchSashForm = new SashForm(this.searchComposite, 256);
        this.searchField = new Text((Composite)this.searchSashForm, 128);
        this.searchField.setMessage(CVSUIMessages.CVSHistoryPage_EnterSearchTerm);
        SearchHistoryTable searchHistoryTable = new SearchHistoryTable();
        this.searchField.addModifyListener(e -> Display.getDefault().timerExec(1000, (Runnable)searchHistoryTable));
        this.contributeActions();
        this.setViewerVisibility();
        int[] weights = this.loadSashWeights(SASH_WEIGHTS);
        if (weights.length == 3) {
            nArray2 = weights;
        } else {
            int[] nArray3 = new int[3];
            nArray3[0] = 65;
            nArray3[1] = 20;
            nArray2 = nArray3;
            nArray3[2] = 15;
        }
        this.sashForm.setWeights(nArray2);
        int[] innerWeights = this.loadSashWeights(INNER_SASH_WEIGHTS);
        if (innerWeights.length == 2) {
            nArray = innerWeights;
        } else {
            int[] nArray4 = new int[2];
            nArray4[0] = 50;
            nArray = nArray4;
            nArray4[1] = 50;
        }
        this.innerSashForm.setWeights(nArray);
        IHistoryPageSite parentSite = this.getHistoryPageSite();
        if (parentSite != null && parentSite instanceof DialogHistoryPageSite && this.treeViewer != null) {
            parentSite.setSelectionProvider((ISelectionProvider)this.treeViewer);
        }
        this.resourceListener = new HistoryResourceListener();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.resourceListener, 1);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.sashForm, "org.eclipse.team.cvs.ui.resource_history_view_context");
        this.disposeListener = e -> this.saveState();
        parent.addDisposeListener(this.disposeListener);
    }

    private void saveState() {
        this.saveSashWeights(SASH_WEIGHTS, this.sashForm.getWeights());
        this.saveSashWeights(INNER_SASH_WEIGHTS, this.innerSashForm.getWeights());
        this.historyTableProvider.saveColumnLayout();
        this.settings.put(SORT_ORDER_KEY, this.sortTagsAscending);
    }

    private int[] loadSashWeights(String key) {
        String value = this.settings.get(key);
        if (value == null) {
            return new int[0];
        }
        String[] weigths = value.split(SASH_WEIGHTS_SEPARATOR);
        int[] result = new int[weigths.length];
        int i = 0;
        while (i < weigths.length) {
            try {
                result[i] = Integer.parseInt(weigths[i]);
            }
            catch (NumberFormatException numberFormatException) {
                return new int[0];
            }
            ++i;
        }
        return result;
    }

    private void saveSashWeights(String key, int[] weights) {
        StringBuffer value = new StringBuffer();
        int i = 0;
        while (i < weights.length) {
            value = value.append(String.valueOf(weights[i]) + SASH_WEIGHTS_SEPARATOR);
            ++i;
        }
        this.settings.put(key, value.toString());
    }

    private TextViewer createText(SashForm parent) {
        SourceViewer result = new SourceViewer((Composite)parent, null, null, true, 778);
        result.getTextWidget().setIndent(2);
        result.configure((SourceViewerConfiguration)new TextSourceViewerConfiguration(EditorsUI.getPreferenceStore()){

            protected Map getHyperlinkDetectorTargets(ISourceViewer sourceViewer) {
                return Collections.singletonMap("org.eclipse.ui.DefaultTextEditor", new IAdaptable(){

                    public <T> T getAdapter(Class<T> adapter) {
                        if (adapter == IFile.class && CVSHistoryPage.this.getInput() instanceof IFile) {
                            return adapter.cast(CVSHistoryPage.this.getInput());
                        }
                        if (adapter == IFileHistory.class && CVSHistoryPage.this.getInput() instanceof IFileHistory) {
                            return adapter.cast(CVSHistoryPage.this.getInput());
                        }
                        return (T)Platform.getAdapterManager().getAdapter((Object)CVSHistoryPage.this, adapter);
                    }
                });
            }
        });
        result.addSelectionChangedListener(event -> this.copyAction.update());
        result.setTextDoubleClickStrategy((ITextDoubleClickStrategy)new DefaultTextDoubleClickStrategy(), "__dftl_partition_content_type");
        result.activatePlugins();
        return result;
    }

    private TableViewer createTagTable(SashForm parent) {
        Table table = new Table((Composite)parent, 66306);
        TableViewer result = new TableViewer(table);
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(100));
        table.setLayout((Layout)layout);
        result.setContentProvider((IContentProvider)new SimpleContentProvider(this){

            @Override
            public Object[] getElements(Object inputElement) {
                if (inputElement == null) {
                    return new Object[0];
                }
                Object[] tags = (ITag[])inputElement;
                return tags;
            }
        });
        result.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                if (element == null) {
                    return null;
                }
                ITag tag = (ITag)element;
                if (!(tag instanceof CVSTag)) {
                    return null;
                }
                switch (((CVSTag)tag).getType()) {
                    case 0: 
                    case 1: {
                        return CVSHistoryPage.this.branchImage;
                    }
                    case 2: {
                        return CVSHistoryPage.this.versionImage;
                    }
                }
                return null;
            }

            public String getText(Object element) {
                return ((ITag)element).getName();
            }
        });
        result.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                int type2;
                if (!(e1 instanceof ITag) || !(e2 instanceof ITag)) {
                    return super.compare(viewer, e1, e2);
                }
                CVSTag tag1 = (CVSTag)e1;
                CVSTag tag2 = (CVSTag)e2;
                int type1 = tag1.getType();
                if (type1 != (type2 = tag2.getType())) {
                    return type2 - type1;
                }
                if (CVSHistoryPage.this.sortTagsAscending) {
                    return super.compare(viewer, (Object)tag1, (Object)tag2);
                }
                return super.compare(viewer, (Object)tag2, (Object)tag1);
            }
        });
        result.addSelectionChangedListener(event -> {
            this.copyTagAction.setEnabled(false);
            if (event.getSelection() instanceof StructuredSelection && ((StructuredSelection)event.getSelection()).getFirstElement() != null) {
                this.copyTagAction.setEnabled(true);
            }
        });
        return result;
    }

    public void setFocus() {
        this.sashForm.setFocus();
        if (this.refreshRequest != 0) {
            this.refresh(this.refreshRequest);
            this.refreshRequest = 0;
        }
    }

    protected void contributeActions() {
        IToolBarManager tbm;
        CVSUIPlugin plugin = CVSUIPlugin.getPlugin();
        this.refreshAction = new Action(CVSUIMessages.HistoryView_refreshLabel, plugin.getImageDescriptor("elcl16/refresh.gif")){

            public void run() {
                CVSHistoryPage.this.refresh();
            }
        };
        this.refreshAction.setToolTipText(CVSUIMessages.HistoryView_refresh);
        this.refreshAction.setDisabledImageDescriptor(plugin.getImageDescriptor("dlcl16/refresh.gif"));
        this.refreshAction.setHoverImageDescriptor(plugin.getImageDescriptor("elcl16/refresh.gif"));
        final IPreferenceStore store = CVSUIPlugin.getPlugin().getPreferenceStore();
        this.localMode = new Action(CVSUIMessages.CVSHistoryPage_LocalModeAction, plugin.getImageDescriptor("elcl16/local_history_mode.gif")){

            public void run() {
                if (this.isChecked()) {
                    store.setValue("pref_revision_mode", 2);
                    CVSHistoryPage.this.updateFilterMode(2);
                } else {
                    this.setChecked(true);
                }
            }
        };
        this.localMode.setToolTipText(CVSUIMessages.CVSHistoryPage_LocalModeTooltip);
        this.localMode.setDisabledImageDescriptor(plugin.getImageDescriptor("dlcl16/local_history_mode.gif"));
        this.localMode.setHoverImageDescriptor(plugin.getImageDescriptor("elcl16/local_history_mode.gif"));
        this.remoteMode = new Action(CVSUIMessages.CVSHistoryPage_RemoteModeAction, plugin.getImageDescriptor("elcl16/remote_history_mode.gif")){

            public void run() {
                if (this.isChecked()) {
                    store.setValue("pref_revision_mode", 1);
                    CVSHistoryPage.this.updateFilterMode(1);
                } else {
                    this.setChecked(true);
                }
            }
        };
        this.remoteMode.setToolTipText(CVSUIMessages.CVSHistoryPage_RemoteModeTooltip);
        this.remoteMode.setDisabledImageDescriptor(plugin.getImageDescriptor("dlcl16/remote_history_mode.gif"));
        this.remoteMode.setHoverImageDescriptor(plugin.getImageDescriptor("elcl16/remote_history_mode.gif"));
        this.remoteLocalMode = new Action(CVSUIMessages.CVSHistoryPage_CombinedModeAction, plugin.getImageDescriptor("elcl16/all_history_mode.gif")){

            public void run() {
                if (this.isChecked()) {
                    store.setValue("pref_revision_mode", 0);
                    CVSHistoryPage.this.updateFilterMode(0);
                } else {
                    this.setChecked(true);
                }
            }
        };
        this.remoteLocalMode.setToolTipText(CVSUIMessages.CVSHistoryPage_CombinedModeTooltip);
        this.remoteLocalMode.setDisabledImageDescriptor(plugin.getImageDescriptor("dlcl16/all_history_mode.gif"));
        this.remoteLocalMode.setHoverImageDescriptor(plugin.getImageDescriptor("elcl16/all_history_mode.gif"));
        this.updateFilterMode(store.getInt("pref_revision_mode"));
        this.groupByDateMode = new Action(CVSUIMessages.CVSHistoryPage_GroupByDate, CVSUIPlugin.getPlugin().getImageDescriptor("obj16/dates.gif")){

            public void run() {
                CVSHistoryPage.this.groupingOn = !CVSHistoryPage.this.groupingOn;
                store.setValue("pref_groupbydate_mode", CVSHistoryPage.this.groupingOn);
                CVSHistoryPage.this.refreshHistory(false, false, 3);
            }
        };
        this.groupingOn = store.getBoolean("pref_groupbydate_mode");
        this.groupByDateMode.setChecked(this.groupingOn);
        this.groupByDateMode.setToolTipText(CVSUIMessages.CVSHistoryPage_GroupByDate);
        this.groupByDateMode.setDisabledImageDescriptor(plugin.getImageDescriptor("obj16/dates.gif"));
        this.groupByDateMode.setHoverImageDescriptor(plugin.getImageDescriptor("obj16/dates.gif"));
        this.collapseAll = new Action(CVSUIMessages.CVSHistoryPage_CollapseAllAction, plugin.getImageDescriptor("elcl16/collapseall.gif")){

            public void run() {
                CVSHistoryPage.this.treeViewer.collapseAll();
            }
        };
        this.collapseAll.setToolTipText(CVSUIMessages.CVSHistoryPage_CollapseAllTooltip);
        this.collapseAll.setDisabledImageDescriptor(plugin.getImageDescriptor("elcl16/collapseall.gif"));
        this.collapseAll.setHoverImageDescriptor(plugin.getImageDescriptor("elcl16/collapseall.gif"));
        this.compareModeAction = new Action(CVSUIMessages.CVSHistoryPage_CompareModeToggleAction, plugin.getImageDescriptor("eview16/compare_view.gif")){

            public void run() {
                CVSHistoryPage.this.compareMode = !CVSHistoryPage.this.compareMode;
                CVSHistoryPage.this.compareModeAction.setChecked(CVSHistoryPage.this.compareMode);
            }
        };
        this.compareModeAction.setToolTipText(CVSUIMessages.CVSHistoryPage_CompareModeTooltip);
        this.compareModeAction.setDisabledImageDescriptor(plugin.getImageDescriptor("eview16/compare_view.gif"));
        this.compareModeAction.setHoverImageDescriptor(plugin.getImageDescriptor("eview16/compare_view.gif"));
        this.compareModeAction.setChecked(false);
        this.compareAction = new CompareRevisionAction(CVSUIMessages.CVSHistoryPage_CompareRevisionAction, (HistoryPage)this);
        this.compareAction.setEnabled(!this.treeViewer.getSelection().isEmpty());
        this.treeViewer.getTree().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CVSHistoryPage.this.compareAction.setCurrentFileRevision(CVSHistoryPage.this.getCurrentFileRevision());
                CVSHistoryPage.this.compareAction.selectionChanged((IStructuredSelection)CVSHistoryPage.this.treeViewer.getStructuredSelection());
            }
        });
        this.openAction = new OpenRevisionAction(CVSUIMessages.CVSHistoryPage_OpenAction, (HistoryPage)this);
        this.openAction.setEnabled(!this.treeViewer.getSelection().isEmpty());
        this.treeViewer.getTree().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CVSHistoryPage.this.openAction.selectionChanged((IStructuredSelection)CVSHistoryPage.this.treeViewer.getStructuredSelection());
            }
        });
        this.openWithMenu = new OpenWithMenu((HistoryPage)this);
        this.treeViewer.getTree().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CVSHistoryPage.this.openWithMenu.selectionChanged((IStructuredSelection)CVSHistoryPage.this.treeViewer.getStructuredSelection());
            }
        });
        new OpenAndLinkWithEditorHelper((StructuredViewer)this.treeViewer){

            protected void open(ISelection selection, boolean activate) {
                if (CVSHistoryPage.this.getSite() != null && selection instanceof IStructuredSelection) {
                    IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                    if (CVSHistoryPage.this.compareMode) {
                        StructuredSelection sel = new StructuredSelection(new Object[]{CVSHistoryPage.this.getCurrentFileRevision(), structuredSelection.getFirstElement()});
                        CVSHistoryPage.this.compareAction.selectionChanged((IStructuredSelection)sel);
                        CVSHistoryPage.this.compareAction.run();
                    } else {
                        CVSHistoryPage.this.openAction.selectionChanged(structuredSelection);
                        CVSHistoryPage.this.openAction.run();
                    }
                }
            }

            protected void activate(ISelection selection) {
                int currentMode = OpenStrategy.getOpenMethod();
                try {
                    OpenStrategy.setOpenMethod((int)0);
                    this.open(selection, true);
                }
                finally {
                    OpenStrategy.setOpenMethod((int)currentMode);
                }
            }

            protected void linkToEditor(ISelection selection) {
            }
        };
        this.getContentsAction = this.getContextMenuAction(CVSUIMessages.HistoryView_getContentsAction, true, monitor -> {
            monitor.beginTask(null, 100);
            try {
                try {
                    if (this.confirmOverwrite() && this.validateChange()) {
                        IStorage currentStorage = this.currentSelection.getStorage((IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)50));
                        InputStream in = currentStorage.getContents();
                        ((IFile)this.file.getIResource()).setContents(in, false, true, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)50));
                    }
                }
                catch (TeamException e) {
                    throw new CoreException(e.getStatus());
                }
            }
            finally {
                monitor.done();
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this.getContentsAction, "org.eclipse.team.cvs.ui.get_file_contents_action_context");
        this.getRevisionAction = this.getContextMenuAction(CVSUIMessages.HistoryView_getRevisionAction, true, monitor -> {
            ICVSRemoteFile remoteFile = (ICVSRemoteFile)CVSWorkspaceRoot.getRemoteResourceFor((ICVSResource)((CVSFileRevision)this.currentSelection).getCVSRemoteFile());
            try {
                if (this.confirmOverwrite() && this.validateChange()) {
                    CVSTag revisionTag = new CVSTag(remoteFile.getRevision(), 2);
                    if (CVSAction.checkForMixingTags(this.getHistoryPageSite().getShell(), new IResource[]{this.file.getIResource()}, revisionTag)) {
                        new UpdateOperation(null, new IResource[]{this.file.getIResource()}, new Command.LocalOption[]{Update.IGNORE_LOCAL_CHANGES}, revisionTag).run(monitor);
                        Display.getDefault().asyncExec(() -> this.refresh());
                    }
                }
            }
            catch (InvocationTargetException e1) {
                throw CVSException.wrapException((Exception)e1);
            }
            catch (InterruptedException interruptedException) {}
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this.getRevisionAction, "org.eclipse.team.cvs.ui.get_file_revision_action_context");
        MoveRemoteTagAction tagActionDelegate = new MoveRemoteTagAction(){

            @Override
            protected ICVSResource[] getSelectedCVSResources() {
                ICVSResource[] resources = super.getSelectedCVSResources();
                if (resources == null || resources.length == 0) {
                    ArrayList<ICVSRemoteFile> logEntrieFiles = null;
                    IStructuredSelection selection = this.getSelection();
                    if (!selection.isEmpty()) {
                        logEntrieFiles = new ArrayList<ICVSRemoteFile>();
                        for (Object next : selection) {
                            IAdaptable a;
                            Object adapter;
                            if (next instanceof CVSFileRevision) {
                                logEntrieFiles.add(((CVSFileRevision)next).getCVSRemoteFile());
                                continue;
                            }
                            if (!(next instanceof IAdaptable) || !((adapter = (a = (IAdaptable)next).getAdapter(ICVSResource.class)) instanceof ICVSResource)) continue;
                            logEntrieFiles.add(((ILogEntry)adapter).getRemoteFile());
                        }
                    }
                    if (logEntrieFiles != null && !logEntrieFiles.isEmpty()) {
                        return logEntrieFiles.toArray(new ICVSResource[logEntrieFiles.size()]);
                    }
                }
                return resources;
            }

            @Override
            protected ITagOperation createTagOperation() {
                return new TagInRepositoryOperation(this.getTargetPart(), this.getSelectedRemoteResources()){

                    @Override
                    public void execute(IProgressMonitor monitor) throws CVSException, InterruptedException {
                        super.execute(monitor);
                        Display.getDefault().asyncExec(() -> {
                            if (!this.wasCancelled()) {
                                CVSHistoryPage.this.refresh();
                            }
                        });
                    }
                };
            }
        };
        this.tagWithExistingAction = this.getContextMenuAction(CVSUIMessages.HistoryView_tagWithExistingAction, false, arg_0 -> this.lambda$7((IActionDelegate)tagActionDelegate, arg_0));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this.getRevisionAction, "org.eclipse.team.cvs.ui.tag_with_existing_action_context");
        this.toggleTextAction = new Action(TeamUIMessages.GenericHistoryView_ShowCommentViewer){

            public void run() {
                CVSHistoryPage.this.setViewerVisibility();
                store.setValue("pref_show_comments", CVSHistoryPage.this.toggleTextAction.isChecked());
            }
        };
        this.toggleTextAction.setChecked(store.getBoolean("pref_show_comments"));
        this.toggleTextWrapAction = new Action(TeamUIMessages.GenericHistoryView_WrapComments){

            public void run() {
                CVSHistoryPage.this.setViewerVisibility();
                store.setValue("pref_wrap_comments", CVSHistoryPage.this.toggleTextWrapAction.isChecked());
            }
        };
        this.toggleTextWrapAction.setChecked(store.getBoolean("pref_wrap_comments"));
        this.toggleListAction = new Action(TeamUIMessages.GenericHistoryView_ShowTagViewer){

            public void run() {
                CVSHistoryPage.this.setViewerVisibility();
                store.setValue("pref_show_tags", CVSHistoryPage.this.toggleListAction.isChecked());
            }
        };
        this.toggleListAction.setChecked(store.getBoolean("pref_show_tags"));
        this.toggleSearchAction = new Action(CVSUIMessages.CVSHistoryPage_ShowSearchField){

            public void run() {
                CVSHistoryPage.this.setViewerVisibility();
                store.setValue("pref_show_search", CVSHistoryPage.this.toggleSearchAction.isChecked());
                if (!CVSHistoryPage.this.toggleSearchAction.isChecked()) {
                    if (CVSHistoryPage.this.searchFilter != null) {
                        CVSHistoryPage.this.treeViewer.removeFilter((ViewerFilter)CVSHistoryPage.this.searchFilter);
                    }
                } else {
                    CVSHistoryPage.this.searchField.setMessage(CVSUIMessages.CVSHistoryPage_EnterSearchTerm);
                    CVSHistoryPage.this.searchField.selectAll();
                    CVSHistoryPage.this.searchField.setFocus();
                }
            }
        };
        this.toggleSearchAction.setChecked(store.getBoolean("pref_show_search"));
        this.toggleFilterAction = new Action(CVSUIMessages.CVSHistoryPage_NoFilter){

            public void run() {
                if (CVSHistoryPage.this.historyFilter != null) {
                    CVSHistoryPage.this.treeViewer.removeFilter((ViewerFilter)CVSHistoryPage.this.historyFilter);
                }
                CVSHistoryPage.this.historyFilter = null;
                String old = CVSHistoryPage.this.description;
                CVSHistoryPage.this.description = null;
                CVSHistoryPage.this.firePropertyChange((Object)CVSHistoryPage.this, "org.eclipse.team.ui.name", old, CVSHistoryPage.this.getName());
                CVSHistoryPage.this.toggleFilterAction.setEnabled(false);
            }
        };
        this.toggleFilterAction.setEnabled(this.historyFilter != null);
        this.cvsHistoryFilter = new CVSHistoryFilterAction(this);
        this.cvsHistoryFilter.setText(CVSUIMessages.CVSHistoryPage_FilterOn);
        this.cvsHistoryFilter.init(this.treeViewer);
        this.cvsHistoryFilter.setToolTipText(CVSUIMessages.CVSHistoryPage_FilterHistoryTooltip);
        this.cvsHistoryFilter.setImageDescriptor(CVSUIPlugin.getPlugin().getImageDescriptor("elcl16/filter_history.png"));
        MenuManager menuMgr = new MenuManager();
        Menu menu = menuMgr.createContextMenu((Control)this.treeViewer.getTree());
        menuMgr.addMenuListener(menuMgr1 -> this.fillTableMenu(menuMgr1));
        menuMgr.setRemoveAllWhenShown(true);
        this.treeViewer.getTree().setMenu(menu);
        IHistoryPageSite parentSite = this.getHistoryPageSite();
        if (!parentSite.isModal()) {
            IPageSite pageSite;
            IWorkbenchPart part = parentSite.getPart();
            if (part != null) {
                IWorkbenchPartSite workbenchPartSite = part.getSite();
                workbenchPartSite.registerContextMenu(menuMgr, (ISelectionProvider)this.treeViewer);
            }
            if ((pageSite = parentSite.getWorkbenchPageSite()) != null) {
                IActionBars actionBars = pageSite.getActionBars();
                IMenuManager actionBarsMenu = actionBars.getMenuManager();
                if (actionBarsMenu != null) {
                    actionBarsMenu.add(this.toggleTextWrapAction);
                    actionBarsMenu.add((IContributionItem)new Separator());
                    actionBarsMenu.add(this.toggleTextAction);
                    actionBarsMenu.add(this.toggleListAction);
                    actionBarsMenu.add((IContributionItem)new Separator());
                    actionBarsMenu.add(this.toggleSearchAction);
                    actionBarsMenu.add((IContributionItem)new Separator());
                    actionBarsMenu.add((IAction)this.cvsHistoryFilter);
                    actionBarsMenu.add(this.toggleFilterAction);
                }
                this.copyAction = new TextViewerAction((ITextViewer)this.textViewer, 4);
                this.copyAction.setText(CVSUIMessages.HistoryView_copy);
                actionBars.setGlobalActionHandler(ITextEditorActionConstants.COPY, (IAction)this.copyAction);
                this.selectAllAction = new TextViewerAction((ITextViewer)this.textViewer, 7);
                this.selectAllAction.setText(CVSUIMessages.HistoryView_selectAll);
                actionBars.setGlobalActionHandler(ITextEditorActionConstants.SELECT_ALL, (IAction)this.selectAllAction);
                this.copyTagAction = new TableViewerAction(this.tagViewer);
                this.copyTagAction.setText(CVSUIMessages.HistoryView_copy);
                this.copyTagAction.setEnabled(false);
                actionBars.updateActionBars();
            }
        }
        if ((tbm = parentSite.getToolBarManager()) != null) {
            String fileNameQualifier = this.getFileNameQualifier();
            tbm.add((IContributionItem)new Separator(String.valueOf(fileNameQualifier) + "grouping"));
            tbm.appendToGroup(String.valueOf(fileNameQualifier) + "grouping", (IAction)this.groupByDateMode);
            tbm.add((IContributionItem)new Separator(String.valueOf(fileNameQualifier) + "modes"));
            tbm.appendToGroup(String.valueOf(fileNameQualifier) + "modes", (IAction)this.remoteLocalMode);
            tbm.appendToGroup(String.valueOf(fileNameQualifier) + "modes", (IAction)this.localMode);
            tbm.appendToGroup(String.valueOf(fileNameQualifier) + "modes", (IAction)this.remoteMode);
            tbm.add((IContributionItem)new Separator(String.valueOf(fileNameQualifier) + "collapse"));
            tbm.appendToGroup(String.valueOf(fileNameQualifier) + "collapse", (IAction)this.collapseAll);
            if (!parentSite.isModal()) {
                tbm.appendToGroup(String.valueOf(fileNameQualifier) + "collapse", (IAction)this.compareModeAction);
            }
            tbm.update(false);
        }
        menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(menuMgr1 -> this.fillTextMenu(menuMgr1));
        StyledText text = this.textViewer.getTextWidget();
        menu = menuMgr.createContextMenu((Control)text);
        text.setMenu(menu);
        menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(menuMgr1 -> this.fillTagMenu(menuMgr1));
        menu = menuMgr.createContextMenu(this.tagViewer.getControl());
        this.tagViewer.getControl().setMenu(menu);
    }

    private String getFileNameQualifier() {
        return Long.toString(System.currentTimeMillis());
    }

    private boolean isLocalHistoryFilteredOut() {
        return this.localFilteredOut;
    }

    private boolean isRemoteHistoryFilteredOut() {
        return this.remoteFilteredOut;
    }

    void fillTableMenu(IMenuManager manager) {
        IStructuredSelection tempSelection;
        ISelection sel;
        IHistoryPageSite parentSite = this.getHistoryPageSite();
        manager.add((IContributionItem)new Separator("group.file"));
        if (this.file != null && !parentSite.isModal()) {
            manager.add((IAction)this.openAction);
            MenuManager openWithSubmenu = new MenuManager(CVSUIMessages.CVSHistoryPage_OpenWithMenu);
            openWithSubmenu.add((IContributionItem)this.openWithMenu);
            manager.add((IContributionItem)openWithSubmenu);
            manager.add((IAction)this.compareAction);
            manager.add((IContributionItem)new Separator("openCompare"));
        }
        if (this.file != null && !(this.file instanceof RemoteFile) && !(sel = this.treeViewer.getSelection()).isEmpty() && sel instanceof IStructuredSelection && (tempSelection = (IStructuredSelection)sel).size() == 1) {
            manager.add((IAction)this.getContentsAction);
            if (!(tempSelection.getFirstElement() instanceof LocalFileRevision)) {
                manager.add((IAction)this.getRevisionAction);
                manager.add((IContributionItem)new Separator());
                if (!parentSite.isModal()) {
                    manager.add((IAction)this.tagWithExistingAction);
                }
            }
        }
        if (!parentSite.isModal()) {
            manager.add((IContributionItem)new Separator("additions"));
            manager.add((IAction)this.refreshAction);
            manager.add((IContributionItem)new Separator("additions-end"));
        }
    }

    private void fillTextMenu(IMenuManager manager) {
        manager.add((IAction)this.copyAction);
        manager.add((IAction)this.selectAllAction);
    }

    private void fillTagMenu(IMenuManager manager) {
        manager.add((IAction)this.copyTagAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)new SortTagsAction(true));
        manager.add((IAction)new SortTagsAction(false));
    }

    protected TreeViewer createTree(Composite parent) {
        this.historyTableProvider = new CVSHistoryTableProvider();
        TreeViewer viewer = this.historyTableProvider.createTree(parent);
        viewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (CVSHistoryPage.this.entries != null) {
                    return CVSHistoryPage.this.entries;
                }
                if (!(inputElement instanceof IFileHistory) && !(inputElement instanceof AbstractHistoryCategory[])) {
                    return new Object[0];
                }
                if (inputElement instanceof AbstractHistoryCategory[]) {
                    return (AbstractHistoryCategory[])inputElement;
                }
                IFileHistory fileHistory = (IFileHistory)inputElement;
                CVSHistoryPage.this.entries = fileHistory.getFileRevisions();
                return CVSHistoryPage.this.entries;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                CVSHistoryPage.this.entries = null;
            }

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof AbstractHistoryCategory) {
                    return ((AbstractHistoryCategory)parentElement).getRevisions();
                }
                return null;
            }

            public Object getParent(Object element) {
                return null;
            }

            public boolean hasChildren(Object element) {
                IFileRevision[] revs;
                if (element instanceof AbstractHistoryCategory && (revs = ((AbstractHistoryCategory)element).getRevisions()) != null) {
                    return revs.length > 0;
                }
                return false;
            }
        });
        viewer.addSelectionChangedListener(event -> {
            ISelection selection = event.getSelection();
            if (selection == null || !(selection instanceof IStructuredSelection)) {
                this.textViewer.setDocument((IDocument)new Document(""));
                this.tagViewer.setInput(null);
                this.setStatusLineMessage(null);
                return;
            }
            IStructuredSelection ss = (IStructuredSelection)selection;
            if (ss.size() != 1) {
                this.textViewer.setDocument((IDocument)new Document(""));
                this.tagViewer.setInput(null);
                this.setStatusLineMessage(null);
                return;
            }
            Object o = ss.getFirstElement();
            if (o instanceof AbstractHistoryCategory) {
                this.textViewer.setDocument((IDocument)new Document(""));
                this.tagViewer.setInput(null);
                this.setStatusLineMessage(null);
                return;
            }
            IFileRevision entry = (IFileRevision)o;
            this.textViewer.setDocument((IDocument)new Document(entry.getComment()));
            this.tagViewer.setInput((Object)entry.getTags());
            this.setStatusLineMessage(CVSHistoryTableProvider.getCommentAsSingleLine(entry));
        });
        return viewer;
    }

    private Action getContextMenuAction(String title, final boolean needsProgressDialog, final IWorkspaceRunnable action) {
        return new Action(title){

            public void run() {
                block9: {
                    try {
                        if (CVSHistoryPage.this.file == null) {
                            return;
                        }
                        ISelection selection = CVSHistoryPage.this.treeViewer.getSelection();
                        if (!(selection instanceof IStructuredSelection)) {
                            return;
                        }
                        IStructuredSelection ss = (IStructuredSelection)selection;
                        Object o = ss.getFirstElement();
                        if (o instanceof AbstractHistoryCategory) {
                            return;
                        }
                        CVSHistoryPage.this.currentSelection = (IFileRevision)o;
                        if (needsProgressDialog) {
                            PlatformUI.getWorkbench().getProgressService().run(true, true, monitor -> {
                                try {
                                    action.run(monitor);
                                }
                                catch (CoreException e) {
                                    throw new InvocationTargetException(e);
                                }
                            });
                            break block9;
                        }
                        try {
                            action.run(null);
                        }
                        catch (CoreException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    catch (InvocationTargetException e) {
                        IHistoryPageSite parentSite = CVSHistoryPage.this.getHistoryPageSite();
                        CVSUIPlugin.openError(parentSite.getShell(), null, null, e, 12);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }

            public boolean isEnabled() {
                ISelection selection = CVSHistoryPage.this.treeViewer.getSelection();
                if (!(selection instanceof IStructuredSelection)) {
                    return false;
                }
                IStructuredSelection ss = (IStructuredSelection)selection;
                return ss.size() == 1;
            }
        };
    }

    private boolean confirmOverwrite() {
        if (this.file != null && this.file.getIResource().exists()) {
            try {
                if (this.file.isModified(null)) {
                    String title = CVSUIMessages.HistoryView_overwriteTitle;
                    String msg = CVSUIMessages.HistoryView_overwriteMsg;
                    IHistoryPageSite parentSite = this.getHistoryPageSite();
                    MessageDialog dialog = new MessageDialog(parentSite.getShell(), title, null, msg, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
                    int[] result = new int[1];
                    parentSite.getShell().getDisplay().syncExec(() -> {
                        int n = dialog.open();
                    });
                    if (result[0] != 0) {
                        return false;
                    }
                }
            }
            catch (CVSException e) {
                CVSUIPlugin.log((CoreException)((Object)e));
            }
        }
        return true;
    }

    private boolean validateChange() {
        if (this.file != null && this.file.getIResource().exists()) {
            IResourceChangeDescriptionFactory factory = ResourceChangeValidator.getValidator().createDeltaFactory();
            factory.change((IFile)this.file.getIResource());
            return IDE.promptToConfirm((Shell)this.getHistoryPageSite().getShell(), (String)CVSUIMessages.CVSHistoryPage_ValidateChangeTitle, (String)NLS.bind((String)CVSUIMessages.CVSHistoryPage_ValidateChangeMessage, (Object[])new String[]{this.file.getName()}), (IResourceDelta)factory.getDelta(), (String[])new String[0], (boolean)true);
        }
        return false;
    }

    public void refresh() {
        this.refresh(3);
    }

    public void refresh(int refreshFlags) {
        CVSHistoryPage.printDebugInfo("CVSHistoryPage#refresh", (IFile)(this.previousFile != null ? this.previousFile.getIResource() : null), this.cvsFileHistory, new Throwable());
        this.refreshHistory(true, false, refreshFlags);
    }

    private void refreshHistory(boolean refetch, boolean selectOnly, int refreshFlags) {
        if (this.refreshCVSFileHistoryJob.getState() != 0) {
            RefreshCVSFileHistory oldJob = this.refreshCVSFileHistoryJob;
            oldJob.cancel();
            this.refreshCVSFileHistoryJob = new RefreshCVSFileHistory(this);
            this.refreshCVSFileHistoryJob.setLocalFileRevision(oldJob.localFileRevision);
            this.refreshCVSFileHistoryJob.setSelectLocal(oldJob.useLocalSelect);
            refetch = true;
            selectOnly = false;
            refreshFlags = 3;
            CVSHistoryPage.printDebugInfo("CVSHistoryPage#refreshHistory, cancel old job", (IFile)(this.previousFile != null ? this.previousFile.getIResource() : null), this.cvsFileHistory, null);
        }
        this.refreshCVSFileHistoryJob.setFileHistory(this.cvsFileHistory);
        IResource resource = this.previousFile.getIResource();
        if (resource != null) {
            IResource workspaceFile = ResourcesPlugin.getWorkspace().getRoot().findMember(resource.getFullPath());
            this.refreshCVSFileHistoryJob.setWorkspaceFile((IFile)workspaceFile);
        }
        this.refreshCVSFileHistoryJob.setSelectOnly(selectOnly);
        this.refreshCVSFileHistoryJob.setRefetchHistory(refetch);
        this.refreshCVSFileHistoryJob.setIncludeLocals(!this.isLocalHistoryFilteredOut());
        this.refreshCVSFileHistoryJob.setIncludeRemote(!this.isRemoteHistoryFilteredOut());
        this.refreshCVSFileHistoryJob.setGrouping(this.groupingOn);
        this.refreshCVSFileHistoryJob.setRefreshFlags(refreshFlags);
        IHistoryPageSite parentSite = this.getHistoryPageSite();
        CVSHistoryPage.printDebugInfo("CVSHistoryPage#refreshHistory, about to schedule RefreshCVSFileHistoryJob", (IFile)resource, this.cvsFileHistory, null);
        Utils.schedule((Job)this.refreshCVSFileHistoryJob, (IWorkbenchSite)this.getWorkbenchSite(parentSite));
    }

    private IWorkbenchPartSite getWorkbenchSite(IHistoryPageSite parentSite) {
        IWorkbenchPart part = parentSite.getPart();
        if (part != null) {
            return part.getSite();
        }
        return null;
    }

    public void selectRevision(String revision) {
        IFileRevision entry = null;
        entry = this.getFileRevision(revision);
        if (entry != null) {
            StructuredSelection selection = new StructuredSelection((Object)entry);
            this.treeViewer.getTree().setRedraw(false);
            this.treeViewer.setSelection((ISelection)selection, true);
            this.treeViewer.getTree().setRedraw(true);
        } else {
            this.treeViewer.getTree().deselectAll();
        }
    }

    private IFileRevision getFileRevision(String revision) {
        if (this.entries != null) {
            IFileRevision[] iFileRevisionArray = this.entries;
            int n = this.entries.length;
            int n2 = 0;
            while (n2 < n) {
                IFileRevision entry = iFileRevisionArray[n2];
                if (entry.getContentIdentifier().equals(revision)) {
                    return entry;
                }
                ++n2;
            }
        } else if (this.cvsFileHistory != null) {
            return this.cvsFileHistory.getFileRevision(revision);
        }
        return null;
    }

    public void selectLocalRevision(long timeStamp) {
        IFileRevision entry = null;
        if (this.entries != null) {
            IFileRevision[] iFileRevisionArray = this.entries;
            int n = this.entries.length;
            int n2 = 0;
            while (n2 < n) {
                IFileRevision e = iFileRevisionArray[n2];
                if (e.getTimestamp() == timeStamp) {
                    entry = e;
                    break;
                }
                ++n2;
            }
        } else if (this.cvsFileHistory != null) {
            IFileRevision[] tempEntries;
            IFileRevision[] iFileRevisionArray = tempEntries = this.cvsFileHistory.getFileRevisions();
            int n = tempEntries.length;
            int n3 = 0;
            while (n3 < n) {
                IFileRevision tempEntry = iFileRevisionArray[n3];
                if (tempEntry.getTimestamp() == timeStamp) {
                    entry = tempEntry;
                    break;
                }
                ++n3;
            }
        }
        if (entry != null) {
            StructuredSelection selection = new StructuredSelection(entry);
            this.treeViewer.getTree().setRedraw(false);
            this.treeViewer.setSelection((ISelection)selection, true);
            this.treeViewer.getTree().setRedraw(true);
        } else {
            this.treeViewer.getTree().deselectAll();
        }
    }

    protected static ICVSFile getCVSFile(Object object) {
        IResource resource = (IResource)Adapters.adapt((Object)object, IResource.class);
        if (resource instanceof IFile) {
            RepositoryProvider provider = RepositoryProvider.getProvider((IProject)resource.getProject());
            if (provider instanceof CVSTeamProvider) {
                return CVSWorkspaceRoot.getCVSFileFor((IFile)((IFile)resource));
            }
            return null;
        }
        ICVSFile remoteFile = (ICVSFile)Adapters.adapt((Object)object, ICVSFile.class);
        if (remoteFile != null) {
            return remoteFile;
        }
        ICVSResource remote = (ICVSResource)Adapters.adapt((Object)object, ICVSResource.class);
        if (remote instanceof RemoteFile) {
            return (ICVSFile)remote;
        }
        IResourceVariant variant = (IResourceVariant)Adapters.adapt((Object)object, IResourceVariant.class);
        if (variant instanceof RemoteFile) {
            return (ICVSFile)remote;
        }
        IFileRevision revision = (IFileRevision)Adapters.adapt((Object)object, IFileRevision.class);
        if (revision instanceof CVSFileRevision) {
            return ((CVSFileRevision)revision).getCVSRemoteFile();
        }
        return null;
    }

    void setViewerVisibility() {
        boolean showText = this.toggleTextAction.isChecked();
        boolean showList = this.toggleListAction.isChecked();
        boolean showSearch = this.toggleSearchAction.isChecked();
        IHistoryPageSite parentSite = this.getHistoryPageSite();
        if (parentSite.isModal()) {
            showText = false;
            showList = false;
        }
        if (showText && showList && showSearch) {
            this.tagAndTextComposite.setVisible(true);
            this.searchComposite.setVisible(true);
            this.sashForm.setWeights(new int[]{60, 25, 15});
            this.sashForm.setMaximizedControl(null);
            this.innerSashForm.setMaximizedControl(null);
            this.searchSashForm.setMaximizedControl(null);
        } else if (showText && showSearch) {
            this.tagAndTextComposite.setVisible(true);
            this.searchComposite.setVisible(true);
            this.sashForm.setWeights(new int[]{60, 25, 15});
            this.sashForm.setMaximizedControl(null);
            this.innerSashForm.setMaximizedControl((Control)this.textViewer.getTextWidget());
            this.searchSashForm.setMaximizedControl((Control)this.searchField);
        } else if (showList && showSearch) {
            this.tagAndTextComposite.setVisible(true);
            this.searchComposite.setVisible(true);
            this.sashForm.setWeights(new int[]{60, 25, 15});
            this.sashForm.setMaximizedControl(null);
            this.innerSashForm.setMaximizedControl((Control)this.tagViewer.getTable());
            this.searchSashForm.setMaximizedControl((Control)this.searchField);
        } else if (showSearch) {
            this.tagAndTextComposite.setVisible(false);
            this.searchComposite.setVisible(true);
            int[] nArray = new int[3];
            nArray[0] = 85;
            nArray[2] = 15;
            this.sashForm.setWeights(nArray);
            this.sashForm.setMaximizedControl(null);
            this.innerSashForm.setMaximizedControl(null);
            this.searchSashForm.setMaximizedControl((Control)this.searchField);
        } else if (showText && showList) {
            this.tagAndTextComposite.setVisible(true);
            this.searchComposite.setVisible(false);
            int[] nArray = new int[3];
            nArray[0] = 70;
            nArray[1] = 30;
            this.sashForm.setWeights(nArray);
            this.sashForm.setMaximizedControl(null);
            this.innerSashForm.setMaximizedControl(null);
            this.searchSashForm.setMaximizedControl((Control)this.searchField);
        } else if (showText) {
            this.tagAndTextComposite.setVisible(true);
            this.searchComposite.setVisible(false);
            int[] nArray = new int[3];
            nArray[0] = 70;
            nArray[1] = 30;
            this.sashForm.setWeights(nArray);
            this.sashForm.setMaximizedControl(null);
            this.innerSashForm.setMaximizedControl((Control)this.textViewer.getTextWidget());
        } else if (showList) {
            this.tagAndTextComposite.setVisible(true);
            this.searchComposite.setVisible(false);
            int[] nArray = new int[3];
            nArray[0] = 70;
            nArray[1] = 30;
            this.sashForm.setWeights(nArray);
            this.sashForm.setMaximizedControl(null);
            this.innerSashForm.setMaximizedControl((Control)this.tagViewer.getTable());
        } else {
            this.tagAndTextComposite.setVisible(false);
            this.searchComposite.setVisible(false);
            this.sashForm.setMaximizedControl(this.treeViewer.getControl());
        }
        boolean wrapText = this.toggleTextWrapAction.isChecked();
        this.textViewer.getTextWidget().setWordWrap(wrapText);
    }

    private void initializeImages() {
        CVSUIPlugin plugin = CVSUIPlugin.getPlugin();
        this.versionImage = plugin.getImageDescriptor("obj16/prjversions_rep.gif").createImage();
        this.branchImage = plugin.getImageDescriptor("obj16/tag.gif").createImage();
    }

    public void dispose() {
        this.shutdown = true;
        if (!this.sashForm.isDisposed() && !this.innerSashForm.isDisposed()) {
            this.saveState();
            if (this.disposeListener != null) {
                this.sashForm.getParent().removeDisposeListener(this.disposeListener);
                this.disposeListener = null;
            }
        }
        if (this.resourceListener != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.resourceListener);
            this.resourceListener = null;
        }
        if (this.branchImage != null) {
            this.branchImage.dispose();
            this.branchImage = null;
        }
        if (this.versionImage != null) {
            this.versionImage.dispose();
            this.versionImage = null;
        }
        if (this.rulerSelectionListener != null) {
            this.rulerSelectionListener.dispose();
            this.rulerSelectionListener = null;
        }
        if (this.refreshCVSFileHistoryJob != null && this.refreshCVSFileHistoryJob.getState() != 0) {
            this.refreshCVSFileHistoryJob.cancel();
        }
        super.dispose();
    }

    public IFileRevision getCurrentFileRevision() {
        if (this.currentFileRevision != null) {
            return this.currentFileRevision;
        }
        if (this.file != null) {
            try {
                if (this.file instanceof RemoteFile) {
                    RemoteFile remote = (RemoteFile)this.file;
                    this.currentFileRevision = this.cvsFileHistory.getFileRevision(remote.getContentIdentifier());
                    return this.currentFileRevision;
                }
                IFile localFile = (IFile)this.file.getIResource();
                if (localFile != null) {
                    this.currentFileRevision = new LocalFileRevision(localFile);
                } else if (this.file.getSyncInfo() != null) {
                    this.currentFileRevision = this.cvsFileHistory.getFileRevision(this.file.getSyncInfo().getRevision());
                }
                return this.currentFileRevision;
            }
            catch (CVSException cVSException) {}
        }
        return null;
    }

    public Control getControl() {
        return this.sashForm;
    }

    public boolean isValidInput(Object object) {
        return CVSHistoryPage.getCVSFile(object) != null;
    }

    public String getName() {
        if (this.description != null) {
            return this.description;
        }
        if (this.file != null) {
            return this.file.getName();
        }
        return "";
    }

    public IPath getFilePath() {
        if (this.file != null) {
            return this.file.getIResource().getFullPath();
        }
        return null;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IHistoryCompareAdapter.class) {
            return adapter.cast((Object)this);
        }
        return null;
    }

    public ICompareInput getCompareInput(Object object) {
        if (object instanceof IFileRevision) {
            IFileRevision selectedFileRevision = (IFileRevision)object;
            if (this.fileElement == null) {
                this.fileElement = SaveableCompareEditorInput.createFileElement((IFile)((IFile)this.file.getIResource()));
            }
            FileRevisionTypedElement right = new FileRevisionTypedElement(selectedFileRevision, this.getLocalEncoding());
            DiffNode node = new DiffNode(this.fileElement, (ITypedElement)right);
            return node;
        }
        return null;
    }

    private String getLocalEncoding() {
        IResource resource = this.file.getIResource();
        if (resource instanceof IFile) {
            IFile file = (IFile)resource;
            try {
                return file.getCharset();
            }
            catch (CoreException e) {
                CVSUIPlugin.log(e);
            }
        }
        return null;
    }

    public void setClickAction(boolean compare) {
        this.compareMode = !compare;
        this.compareModeAction.run();
    }

    public void prepareInput(ICompareInput input, CompareConfiguration configuration, IProgressMonitor monitor) {
        this.initLabels(input, configuration);
    }

    private void initLabels(ICompareInput input, CompareConfiguration cc) {
        String leftLabel = this.getFileRevisionLabel(input.getLeft(), cc);
        cc.setLeftLabel(leftLabel);
        String rightLabel = this.getFileRevisionLabel(input.getRight(), cc);
        cc.setRightLabel(rightLabel);
    }

    private String getFileRevisionLabel(ITypedElement element, CompareConfiguration cc) {
        String label = null;
        if (element instanceof IEditableContent) {
            if (element instanceof IModificationDate) {
                IModificationDate md = (IModificationDate)element;
                Date dateFromLong = new Date(md.getModificationDate());
                label = NLS.bind((String)TeamUIMessages.CompareFileRevisionEditorInput_workspace, (Object[])new Object[]{element.getName(), this.getDateTimeFormat().format(dateFromLong)});
            } else {
                label = element.getName();
            }
            return label;
        }
        if (element instanceof FileRevisionTypedElement) {
            IFileRevision fileObject = ((FileRevisionTypedElement)element).getFileRevision();
            if (fileObject instanceof LocalFileRevision) {
                try {
                    IStorage storage = ((LocalFileRevision)fileObject).getStorage((IProgressMonitor)new NullProgressMonitor());
                    if (Adapters.adapt((Object)storage, IFileState.class) != null) {
                        label = NLS.bind((String)TeamUIMessages.CompareFileRevisionEditorInput_localRevision, (Object[])new Object[]{element.getName(), ((FileRevisionTypedElement)element).getTimestamp()});
                    }
                }
                catch (CoreException coreException) {}
            } else {
                label = NLS.bind((String)TeamUIMessages.CompareFileRevisionEditorInput_repository, (Object[])new Object[]{element.getName(), ((FileRevisionTypedElement)element).getContentIdentifier(), ((FileRevisionTypedElement)element).getAuthor()});
            }
        }
        return label;
    }

    private synchronized DateFormat getDateTimeFormat() {
        if (this.dateTimeFormat == null) {
            this.dateTimeFormat = DateFormat.getDateTimeInstance();
        }
        return this.dateTimeFormat;
    }

    public String getDescription() {
        try {
            if (this.file != null) {
                return this.file.getRepositoryRelativePath();
            }
        }
        catch (CVSException cVSException) {}
        return null;
    }

    public boolean inputSet() {
        this.currentFileRevision = null;
        Object inputObj = this.getInput();
        ICVSFile cvsFile = CVSHistoryPage.getCVSFile(inputObj);
        if (cvsFile == null) {
            return false;
        }
        this.file = cvsFile;
        this.fileElement = null;
        boolean needRefresh = this.checkPreviousInput();
        CVSHistoryPage.printDebugInfo("CVSHistoryPage#inputSet, needRefresh = " + needRefresh, (IFile)cvsFile.getIResource(), this.cvsFileHistory, null);
        if (this.refreshCVSFileHistoryJob != null) {
            if (!needRefresh && this.refreshCVSFileHistoryJob.getState() != 0) {
                CVSHistoryPage.printDebugInfo("CVSHistoryPage#inputSet, the old job is still running", (IFile)cvsFile.getIResource(), this.cvsFileHistory, null);
                return true;
            }
            CVSHistoryPage.printDebugInfo("CVSHistoryPage#inputSet, cancel the old job", (IFile)cvsFile.getIResource(), this.cvsFileHistory, null);
            this.refreshCVSFileHistoryJob.cancel();
        }
        this.refreshCVSFileHistoryJob = new RefreshCVSFileHistory(this);
        if (inputObj instanceof CVSLocalFileRevision) {
            this.refreshCVSFileHistoryJob.setLocalFileRevision((CVSLocalFileRevision)inputObj);
        } else if (inputObj instanceof IFile) {
            this.refreshCVSFileHistoryJob.setLocalFileRevision(new CVSLocalFileRevision((IFile)inputObj));
        }
        this.refreshCVSFileHistoryJob.setSelectLocal(inputObj instanceof CVSLocalFileRevision || inputObj instanceof IFile);
        if (needRefresh) {
            this.cvsFileHistory = new CVSFileHistory(cvsFile);
            this.cvsFileHistory.includeLocalRevisions(true);
            this.treeViewer.setInput(null);
            this.linkWithEditor();
        }
        this.refreshHistory(needRefresh, !needRefresh, 3);
        if (this.toggleSearchAction != null && this.toggleSearchAction.isChecked()) {
            this.searchField.selectAll();
        }
        return true;
    }

    public void linkWithEditor() {
        if (this.rulerSelectionListener != null) {
            this.rulerSelectionListener.dispose();
            this.rulerSelectionListener = null;
        }
        if (!this.getHistoryPageSite().isModal()) {
            IResource resource = this.file.getIResource();
            if (resource instanceof IFile) {
                IFile file = (IFile)resource;
                this.rulerSelectionListener = new CVSRevisionAnnotationController(this.getHistoryPageSite().getWorkbenchPageSite().getPage(), file);
            } else {
                Object input = this.getInput();
                if (input instanceof IStorageEditorInput) {
                    IStorageEditorInput editorInput = (IStorageEditorInput)input;
                    this.rulerSelectionListener = new CVSRevisionAnnotationController(this.getHistoryPageSite().getWorkbenchPageSite().getPage(), editorInput);
                }
            }
        }
    }

    private boolean checkPreviousInput() {
        if (this.previousFile != null) {
            try {
                if (this.isSameRemote(this.file, this.previousFile) && (this.isSameLocalFile(this.file, this.previousFile) || !this.isLocal(this.file) && this.isLocal(this.previousFile))) {
                    return false;
                }
            }
            catch (CVSException cVSException) {}
        }
        this.previousFile = this.file;
        return true;
    }

    private boolean isLocal(ICVSFile file) {
        return file.getIResource() != null;
    }

    private boolean isSameLocalFile(ICVSFile file, ICVSFile previousFile) {
        IResource r1 = file.getIResource();
        IResource r2 = previousFile.getIResource();
        return r1 != null && r2 != null && r1.equals((Object)r2);
    }

    private boolean isSameRemote(ICVSFile file, ICVSFile previousFile) throws CVSException {
        String path = file.getRepositoryRelativePath();
        String previousPath = previousFile.getRepositoryRelativePath();
        if (path == null && previousPath == null) {
            return true;
        }
        return path != null && previousPath != null && path.equals(previousPath) && this.isSameRepository(file.getParent(), previousFile.getParent());
    }

    private boolean isSameRepository(ICVSFolder parent1, ICVSFolder parent2) {
        try {
            FolderSyncInfo info1 = parent1.getFolderSyncInfo();
            FolderSyncInfo info2 = parent2.getFolderSyncInfo();
            return info1 != null && info2 != null && info1.getRemoteLocation().equals(info2.getRemoteLocation());
        }
        catch (CVSException cVSException) {
            return false;
        }
    }

    private void updateFilterMode(int mode) {
        this.currentFilerMode = mode;
        switch (mode) {
            case 2: {
                this.localFilteredOut = false;
                this.remoteFilteredOut = true;
                this.localMode.setChecked(true);
                this.remoteMode.setChecked(false);
                this.remoteLocalMode.setChecked(false);
                break;
            }
            case 1: {
                this.localFilteredOut = true;
                this.remoteFilteredOut = false;
                this.localMode.setChecked(false);
                this.remoteMode.setChecked(true);
                this.remoteLocalMode.setChecked(false);
                break;
            }
            case 0: {
                this.localFilteredOut = false;
                this.remoteFilteredOut = false;
                this.localMode.setChecked(false);
                this.remoteMode.setChecked(false);
                this.remoteLocalMode.setChecked(true);
            }
        }
        if (this.refreshCVSFileHistoryJob != null) {
            this.refreshHistory(false, false, 3);
        }
    }

    public TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    public void showFilter(CVSHistoryFilter filter) {
        IWorkbenchPart part;
        if (this.historyFilter != null) {
            this.treeViewer.removeFilter((ViewerFilter)this.historyFilter);
        }
        this.historyFilter = filter;
        int before = this.cvsFileHistory.getFileRevisions().length;
        this.treeViewer.addFilter((ViewerFilter)this.historyFilter);
        IHistoryPageSite historyPageSite = this.getHistoryPageSite();
        if (historyPageSite instanceof WorkbenchHistoryPageSite && (part = ((WorkbenchHistoryPageSite)historyPageSite).getPart()) instanceof GenericHistoryView) {
            String revisions = NLS.bind((String)CVSUIMessages.CVSHistoryPage_FilterOnMessage, (Object[])new Object[]{this.historyFilter.getMatchCount(), before});
            String old = this.getName();
            this.description = NLS.bind((String)CVSUIMessages.CVSHistoryPage_FilterDescription, (Object[])new Object[]{this.file.getName(), revisions});
            this.firePropertyChange((Object)this, "org.eclipse.team.ui.name", old, this.getName());
        }
        this.toggleFilterAction.setEnabled(true);
    }

    public void setMode(int flag) {
        switch (flag) {
            case 2: {
                this.localMode.setChecked(true);
                this.localMode.run();
                break;
            }
            case 1: {
                this.remoteMode.setChecked(true);
                this.remoteMode.run();
                break;
            }
            case 0: {
                this.remoteLocalMode.setChecked(true);
                this.remoteLocalMode.run();
            }
        }
        this.refreshHistory(true, false, 3);
    }

    public void saveChanges(IProgressMonitor monitor) throws CoreException {
        if (this.fileElement instanceof LocalResourceTypedElement) {
            LocalResourceTypedElement element = (LocalResourceTypedElement)this.fileElement;
            element.commit(monitor);
        }
    }

    private void setStatusLineMessage(String message) {
        IPageSite workbenchPageSite = this.getHistoryPageSite().getWorkbenchPageSite();
        if (workbenchPageSite != null) {
            workbenchPageSite.getActionBars().getStatusLineManager().setMessage(message);
        }
    }

    private static void printDebugInfo(String message, IFile file, CVSFileHistory history, Throwable t) {
        if (!Policy.DEBUG_HISTORY) {
            return;
        }
        String time = new SimpleDateFormat("m:ss.SSS").format(new Date(System.currentTimeMillis()));
        String fileName = file != null ? file.getName() : "<workspaceFile == null>";
        String fileHistoryID = history != null ? history.toString() : "<fileHistory == null>";
        int i = fileHistoryID.indexOf(64);
        if (i != -1) {
            fileHistoryID = fileHistoryID.substring(i);
        }
        System.out.println(String.valueOf(time) + ": " + fileName + ", " + fileHistoryID + ": " + message);
        if (t != null) {
            t.printStackTrace();
        }
    }

    private /* synthetic */ void lambda$7(IActionDelegate iActionDelegate, IProgressMonitor monitor) throws CoreException {
        iActionDelegate.selectionChanged((IAction)this.tagWithExistingAction, this.treeViewer.getSelection());
        iActionDelegate.run((IAction)this.tagWithExistingAction);
    }

    private final class CVSRevisionAnnotationController
    extends RevisionAnnotationController {
        public CVSRevisionAnnotationController(IWorkbenchPage page, IFile file) {
            super(page, file, (ISelectionProvider)CVSHistoryPage.this.treeViewer);
        }

        public CVSRevisionAnnotationController(IWorkbenchPage page, IStorageEditorInput editorInput) {
            super(page, editorInput, (ISelectionProvider)CVSHistoryPage.this.treeViewer);
        }

        protected Object getHistoryEntry(Revision selected) {
            return CVSHistoryPage.this.getFileRevision(selected.getId());
        }
    }

    private class HistoryResourceListener
    implements IResourceChangeListener {
        private HistoryResourceListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta root = event.getDelta();
            if (CVSHistoryPage.this.file == null || CVSHistoryPage.this.file.getIResource() == null) {
                return;
            }
            IResourceDelta resourceDelta = root.findMember(((IFile)CVSHistoryPage.this.file.getIResource()).getFullPath());
            if (resourceDelta != null) {
                String revision = this.getRevision();
                boolean hasRevision = CVSHistoryPage.this.cvsFileHistory.getFileRevision(revision) != null;
                Display.getDefault().asyncExec(() -> {
                    if (CVSHistoryPage.this.treeViewer.getControl().isDisposed()) {
                        return;
                    }
                    if (CVSHistoryPage.this.treeViewer.getControl().isVisible()) {
                        if (hasRevision) {
                            CVSHistoryPage.this.refresh(1);
                        } else {
                            CVSHistoryPage.this.refresh();
                        }
                    } else {
                        CVSHistoryPage.this.refreshRequest = hasRevision ? 1 : 3;
                    }
                });
            }
        }

        private String getRevision() {
            try {
                byte[] syncBytes = CVSHistoryPage.this.file.getSyncBytes();
                if (syncBytes != null && !ResourceSyncInfo.isAddition((byte[])syncBytes)) {
                    return ResourceSyncInfo.getRevision((byte[])syncBytes);
                }
            }
            catch (CVSException cVSException) {}
            return null;
        }
    }

    private class RefreshCVSFileHistory
    extends Job {
        private static final int NUMBER_OF_CATEGORIES = 4;
        private CVSFileHistory fileHistory;
        private AbstractHistoryCategory[] categories;
        private boolean grouping;
        private Object[] elementsToExpand;
        private boolean revisionsFound;
        private IFile workspaceFile;
        private CVSHistoryPage page;
        private boolean selectOnly;
        private boolean useLocalSelect;
        private CVSLocalFileRevision localFileRevision;
        private int refreshFlags;

        public RefreshCVSFileHistory(CVSHistoryPage page) {
            super(CVSUIMessages.HistoryView_fetchHistoryJob);
            this.refreshFlags = 3;
            this.page = page;
        }

        public void setWorkspaceFile(IFile workspaceFile) {
            this.workspaceFile = workspaceFile;
        }

        public void setIncludeLocals(boolean flag) {
            if (this.fileHistory != null) {
                this.fileHistory.includeLocalRevisions(flag);
            }
        }

        public void setIncludeRemote(boolean flag) {
            if (this.fileHistory != null) {
                this.fileHistory.includeRemoteRevisions(flag);
            }
        }

        public void setRefetchHistory(boolean refetch) {
            if (this.fileHistory != null) {
                this.fileHistory.setRefetchRevisions(refetch);
            }
        }

        public void setFileHistory(CVSFileHistory fileHistory) {
            this.fileHistory = fileHistory;
        }

        public void setGrouping(boolean value) {
            this.grouping = value;
        }

        public void setSelectOnly(boolean select) {
            this.selectOnly = select;
        }

        public void setSelectLocal(boolean localSelect) {
            this.useLocalSelect = localSelect;
        }

        public void setLocalFileRevision(CVSLocalFileRevision localRev) {
            this.localFileRevision = localRev;
        }

        public IStatus run(IProgressMonitor monitor) {
            int cachedRefreshFlags = this.refreshFlags;
            boolean cachedSelectOnly = this.selectOnly;
            IStatus status = Status.OK_STATUS;
            CVSHistoryPage.printDebugInfo("RefreshCVSFileHistory#run started for", this.workspaceFile, this.fileHistory, null);
            if (this.fileHistory != null && !CVSHistoryPage.this.shutdown) {
                CVSHistoryPage.printDebugInfo("RefreshCVSFileHistory#run checkpoint 1", this.workspaceFile, this.fileHistory, null);
                boolean localFetched = false;
                boolean needsUpdate = true;
                if (!this.fileHistory.isInitialized() && this.fileHistory.isIncludeLocal() && (cachedRefreshFlags & 2) > 0) {
                    try {
                        CVSHistoryPage.printDebugInfo("RefreshCVSFileHistory#run checkpoint 2", this.workspaceFile, this.fileHistory, null);
                        this.fileHistory.refresh(1, monitor);
                        this.updateTable(cachedSelectOnly);
                        localFetched = true;
                        needsUpdate = false;
                    }
                    catch (TeamException e) {
                        CVSHistoryPage.printDebugInfo("RefreshCVSFileHistory#run encountered an exception(1)", this.workspaceFile, this.fileHistory, e);
                    }
                }
                try {
                    CVSHistoryPage.printDebugInfo("RefreshCVSFileHistory#run checkpoint 3", this.workspaceFile, this.fileHistory, null);
                    this.fileHistory.refresh(cachedRefreshFlags, monitor);
                    needsUpdate = true;
                }
                catch (OperationCanceledException ex) {
                    CVSHistoryPage.printDebugInfo("RefreshCVSFileHistory#run OperationCanceledException", this.workspaceFile, this.fileHistory, ex);
                    throw ex;
                }
                catch (TeamException ex) {
                    CVSHistoryPage.printDebugInfo("RefreshCVSFileHistory#run encountered an exception(2)", this.workspaceFile, this.fileHistory, ex);
                    if (!localFetched) {
                        try {
                            this.fileHistory.refresh(1, monitor);
                            needsUpdate = true;
                        }
                        catch (TeamException e) {
                            CVSHistoryPage.printDebugInfo("RefreshCVSFileHistory#run encountered an exception(3)", this.workspaceFile, this.fileHistory, e);
                        }
                    }
                    status = new CVSStatus(ex.getStatus().getSeverity(), ex.getStatus().getCode(), ex.getMessage(), (Throwable)ex);
                }
                if (needsUpdate) {
                    CVSHistoryPage.printDebugInfo("RefreshCVSFileHistory#run checkpoint 4", this.workspaceFile, this.fileHistory, null);
                    this.updateTable(cachedSelectOnly);
                }
            }
            if (status != Status.OK_STATUS) {
                this.setProperty(IProgressConstants.KEEP_PROPERTY, Boolean.TRUE);
                this.setProperty(IProgressConstants.NO_IMMEDIATE_ERROR_PROMPT_PROPERTY, Boolean.TRUE);
            }
            CVSHistoryPage.printDebugInfo("RefreshCVSFileHistory#run finished, status: " + status, this.workspaceFile, this.fileHistory, null);
            return status;
        }

        private void updateTable(boolean selectOnly) {
            if (this.grouping) {
                this.revisionsFound = this.sortRevisions();
            }
            Utils.asyncExec(() -> {
                CVSHistoryPage.printDebugInfo("RefreshCVSFileHistory#updateTable, in asyncExec", this.workspaceFile, CVSHistoryPage.this.cvsFileHistory, null);
                CVSHistoryPage.this.treeViewer.refresh();
                CVSHistoryPage.this.historyTableProvider.setFile((IFileHistory)this.fileHistory, this.workspaceFile);
                if (!selectOnly) {
                    if (this.grouping) {
                        this.mapExpandedElements(CVSHistoryPage.this.treeViewer.getExpandedElements());
                        CVSHistoryPage.this.treeViewer.getTree().setLinesVisible(this.revisionsFound);
                        CVSHistoryPage.this.treeViewer.getTree().setRedraw(false);
                        CVSHistoryPage.printDebugInfo("RefreshCVSFileHistory#updateTable, setInput:grouping", this.workspaceFile, CVSHistoryPage.this.cvsFileHistory, null);
                        CVSHistoryPage.this.treeViewer.setInput((Object)this.categories);
                        if (this.elementsToExpand.length > 0) {
                            CVSHistoryPage.this.treeViewer.setExpandedElements(this.elementsToExpand);
                        } else {
                            CVSHistoryPage.this.treeViewer.expandAll();
                            Object[] el = CVSHistoryPage.this.treeViewer.getExpandedElements();
                            if (el != null && el.length > 0) {
                                CVSHistoryPage.this.treeViewer.setSelection((ISelection)new StructuredSelection(el[0]));
                                CVSHistoryPage.this.treeViewer.getTree().deselectAll();
                            }
                        }
                        CVSHistoryPage.this.treeViewer.getTree().setRedraw(true);
                    } else if (this.fileHistory.getFileRevisions().length > 0) {
                        CVSHistoryPage.this.treeViewer.getTree().setLinesVisible(true);
                        CVSHistoryPage.printDebugInfo("RefreshCVSFileHistory#updateTable, setInput:no grouping", this.workspaceFile, CVSHistoryPage.this.cvsFileHistory, null);
                        CVSHistoryPage.this.treeViewer.setInput((Object)this.fileHistory);
                    } else {
                        this.categories = new AbstractHistoryCategory[]{this.getErrorMessage()};
                        CVSHistoryPage.this.treeViewer.getTree().setLinesVisible(false);
                        CVSHistoryPage.this.treeViewer.setInput((Object)this.categories);
                    }
                }
                if (CVSHistoryPage.this.historyFilter != null) {
                    CVSHistoryFilter tempFilter = new CVSHistoryFilter(((CVSHistoryPage)CVSHistoryPage.this).historyFilter.branchName, ((CVSHistoryPage)CVSHistoryPage.this).historyFilter.author, ((CVSHistoryPage)CVSHistoryPage.this).historyFilter.comment, ((CVSHistoryPage)CVSHistoryPage.this).historyFilter.fromDate, ((CVSHistoryPage)CVSHistoryPage.this).historyFilter.toDate, ((CVSHistoryPage)CVSHistoryPage.this).historyFilter.isOr);
                    CVSHistoryPage.this.showFilter(tempFilter);
                }
                if (CVSHistoryPage.this.file != null) {
                    try {
                        if (this.useLocalSelect) {
                            this.page.selectLocalRevision(this.localFileRevision.getTimestamp());
                        } else {
                            byte[] syncBytes = CVSHistoryPage.this.file.getSyncBytes();
                            if (syncBytes != null) {
                                String workspaceRevision = ResourceSyncInfo.getRevision((byte[])syncBytes);
                                this.page.selectRevision(workspaceRevision);
                            }
                        }
                    }
                    catch (CVSException cVSException) {}
                }
            }, (StructuredViewer)CVSHistoryPage.this.treeViewer);
        }

        private void mapExpandedElements(Object[] expandedElements) {
            HashMap elementMap = new HashMap();
            Object[] objectArray = expandedElements;
            int n = expandedElements.length;
            int n2 = 0;
            while (n2 < n) {
                Object expandedElement = objectArray[n2];
                elementMap.put(((DateHistoryCategory)expandedElement).getName(), null);
                ++n2;
            }
            ArrayList<AbstractHistoryCategory> expandable = new ArrayList<AbstractHistoryCategory>();
            AbstractHistoryCategory[] abstractHistoryCategoryArray = this.categories;
            int n3 = this.categories.length;
            n = 0;
            while (n < n3) {
                AbstractHistoryCategory category = abstractHistoryCategoryArray[n];
                if (elementMap.containsKey(category.getName())) {
                    expandable.add(category);
                }
                ++n;
            }
            this.elementsToExpand = new Object[expandable.size()];
            this.elementsToExpand = expandable.toArray(new Object[expandable.size()]);
        }

        private boolean sortRevisions() {
            IFileRevision[] fileRevision = this.fileHistory.getFileRevisions();
            DateHistoryCategory[] tempCategories = new DateHistoryCategory[4];
            Calendar currentCal = Calendar.getInstance();
            tempCategories[0] = new DateHistoryCategory(CVSUIMessages.CVSHistoryPage_Today, currentCal, null);
            Calendar yesterdayCal = Calendar.getInstance();
            yesterdayCal.roll(6, -1);
            tempCategories[1] = new DateHistoryCategory(CVSUIMessages.CVSHistoryPage_Yesterday, yesterdayCal, null);
            Calendar monthCal = Calendar.getInstance();
            monthCal.set(5, 1);
            tempCategories[2] = new DateHistoryCategory(CVSUIMessages.CVSHistoryPage_ThisMonth, monthCal, yesterdayCal);
            tempCategories[3] = new DateHistoryCategory(CVSUIMessages.CVSHistoryPage_Previous, null, monthCal);
            ArrayList<Object> finalCategories = new ArrayList<Object>();
            int i = 0;
            while (i < 4) {
                tempCategories[i].collectFileRevisions(fileRevision, false);
                if (tempCategories[i].hasRevisions()) {
                    finalCategories.add(tempCategories[i]);
                }
                ++i;
            }
            boolean revisionsFound = true;
            if (finalCategories.isEmpty()) {
                finalCategories.add(this.getErrorMessage());
                revisionsFound = false;
            }
            this.categories = finalCategories.toArray(new AbstractHistoryCategory[finalCategories.size()]);
            return revisionsFound;
        }

        private MessageHistoryCategory getErrorMessage() {
            String message = "";
            switch (CVSHistoryPage.this.currentFilerMode) {
                case 2: {
                    message = CVSUIMessages.CVSHistoryPage_LocalModeTooltip;
                    break;
                }
                case 1: {
                    message = CVSUIMessages.CVSHistoryPage_RemoteModeTooltip;
                    break;
                }
                case 0: {
                    message = CVSUIMessages.CVSHistoryPage_NoRevisions;
                }
            }
            MessageHistoryCategory messageCategory = new MessageHistoryCategory(NLS.bind((String)CVSUIMessages.CVSHistoryPage_NoRevisionsForMode, (Object[])new String[]{message}));
            return messageCategory;
        }

        public void setRefreshFlags(int refreshFlags) {
            this.refreshFlags = refreshFlags;
        }
    }

    private final class SearchHistoryTable
    implements Runnable {
        private SearchHistoryTable() {
        }

        @Override
        public void run() {
            String searchString = CVSHistoryPage.this.searchField.getText();
            if (searchString.equals("") || searchString.equals(CVSUIMessages.CVSHistoryPage_EnterSearchTerm)) {
                if (CVSHistoryPage.this.searchFilter != null) {
                    CVSHistoryPage.this.treeViewer.removeFilter((ViewerFilter)CVSHistoryPage.this.searchFilter);
                }
                return;
            }
            if (CVSHistoryPage.this.searchFilter != null) {
                CVSHistoryPage.this.treeViewer.removeFilter((ViewerFilter)CVSHistoryPage.this.searchFilter);
            }
            CVSHistoryPage.this.searchFilter = new CVSHistorySearchFilter(searchString);
            if (CVSHistoryPage.this.historyFilter != null) {
                CVSHistoryPage.this.treeViewer.removeFilter((ViewerFilter)CVSHistoryPage.this.historyFilter);
            }
            CVSHistoryPage.this.treeViewer.addFilter((ViewerFilter)CVSHistoryPage.this.searchFilter);
        }
    }

    private class SimpleContentProvider
    implements IStructuredContentProvider {
        public void dispose() {
        }

        public Object[] getElements(Object element) {
            return new Object[0];
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    final class SortTagsAction
    extends Action {
        private boolean sortAscending;

        public SortTagsAction(boolean sortAscending) {
            super(sortAscending ? CVSUIMessages.CVSHistoryPage_SortTagsAscendingAction : CVSUIMessages.CVSHistoryPage_SortTagsDescendingAction, 8);
            this.setChecked(sortAscending == CVSHistoryPage.this.sortTagsAscending);
            this.sortAscending = sortAscending;
        }

        public void run() {
            CVSHistoryPage.this.sortTagsAscending = this.sortAscending;
            CVSHistoryPage.this.tagViewer.refresh();
        }
    }
}

