/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.pldt.common.editorHelp;

import org.eclipse.cdt.ui.ICHelpBook;
import org.eclipse.cdt.ui.ICHelpResourceDescriptor;
import org.eclipse.cdt.ui.IFunctionSummary;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.IHelpResource;

public class CHelpResourceDescriptorImpl
implements ICHelpResourceDescriptor {
    ICHelpBook book;
    String name;
    String label;
    String href;
    IHelpResource[] resources;
    static boolean traceOn = false;

    public CHelpResourceDescriptorImpl(ICHelpBook helpBook, IFunctionSummary functionSummary, String pluginId) {
        this.book = helpBook;
        this.name = functionSummary.getName();
        StringBuffer buf = new StringBuffer();
        String htmlLocn = this.findHTMLdir(pluginId);
        buf.append("/").append(pluginId).append("/").append(htmlLocn).append("/").append(this.name).append(".html");
        this.href = buf.toString();
        IFunctionSummary.IFunctionPrototypeSummary proto = functionSummary.getPrototype();
        this.label = proto != null ? functionSummary.getPrototype().getPrototypeString(false) : functionSummary.getName();
        this.resources = new IHelpResource[1];
        this.resources[0] = new IHelpResource(){

            public String getHref() {
                return CHelpResourceDescriptorImpl.this.href;
            }

            public String getLabel() {
                if (CHelpResourceDescriptorImpl.this.label == null) {
                    return "NO SUCH LABEL BETH";
                }
                return CHelpResourceDescriptorImpl.this.label;
            }
        };
    }

    public ICHelpBook getCHelpBook() {
        return this.book;
    }

    public IHelpResource[] getHelpResources() {
        return this.resources;
    }

    public String toString() {
        return String.valueOf(this.name) + " -> " + this.href;
    }

    private String findHTMLdir(String pluginId) {
        String result = "html";
        String pid = "org.eclipse.ptp.pldt.common";
        String extid = "althelp";
        if (traceOn) {
            System.out.println("Looking for HTML dir for " + pluginId);
        }
        IExtension[] extensions = Platform.getExtensionRegistry().getExtensionPoint(pid, extid).getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] configElements;
            int j;
            String uid;
            IExtension extn = extensions[i];
            String extLabel = extn.getLabel();
            if (traceOn) {
                System.out.println("  Found extension for " + extLabel + "  id=" + extn.getUniqueIdentifier());
            }
            if ((uid = extn.getUniqueIdentifier()).startsWith(pluginId) && (j = 0) < (configElements = extensions[i].getConfigurationElements()).length) {
                IConfigurationElement ice = configElements[j];
                result = ice.getAttribute("dirname");
                if (traceOn) {
                    System.out.println("    dirname=" + result);
                }
                return result;
            }
            ++i;
        }
        return result;
    }
}

