/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.ui.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.php.refactoring.core.extract.function.ExtractFunctionRefactoring;
import org.eclipse.php.refactoring.ui.utils.RefactoringStarter;
import org.eclipse.php.refactoring.ui.wizard.ExtractFunctionWizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;

public class ExtractFunctionActionDelegate
implements IEditorActionDelegate,
IWorkbenchWindowActionDelegate {
    private IEditorPart targetEditor;
    private Shell shell;

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        if (targetEditor == null) {
            return;
        }
        this.targetEditor = targetEditor;
        IWorkbenchPartSite site = targetEditor.getSite();
        if (site != null) {
            this.shell = site.getShell();
        }
    }

    public void run(IAction action) {
        if (this.targetEditor == null) {
            this.targetEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        }
        if (this.shell == null) {
            this.shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        }
        if (!(this.targetEditor instanceof PHPStructuredEditor)) {
            return;
        }
        PHPStructuredEditor phpEditor = (PHPStructuredEditor)this.targetEditor;
        IFile file = ((IFileEditorInput)phpEditor.getEditorInput()).getFile();
        IStructuredModel model = null;
        try {
            model = StructuredModelManager.getModelManager().getExistingModelForEdit(file);
            IStructuredDocument structuredDocument = model.getStructuredDocument();
            ITextSelection fTextSelection = (ITextSelection)phpEditor.getSelectionProvider().getSelection();
            int startOffset = fTextSelection.getOffset();
            int length = fTextSelection.getLength();
            ExtractFunctionRefactoring refactoring = new ExtractFunctionRefactoring(DLTKCore.createSourceModuleFrom((IFile)file), (IDocument)structuredDocument, startOffset, length);
            new RefactoringStarter().activate((Refactoring)refactoring, new ExtractFunctionWizard(refactoring), this.shell, RefactoringMessages.ExtractMethodAction_dialog_title, false);
        }
        finally {
            if (model != null) {
                model.releaseFromEdit();
            }
            this.targetEditor = null;
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }
}

