/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.properties.internal;

import java.io.IOException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.papyrus.infra.constraints.runtime.ConstraintsManager;
import org.eclipse.papyrus.infra.properties.internal.InfraPropertiesPlugin;

public class EnvironmentExtensionPoint {
    private final String EXTENSION_ID = "org.eclipse.papyrus.infra.properties.environments";

    public EnvironmentExtensionPoint(ModelConsumer environmentAcceptor) {
        IConfigurationElement[] config;
        IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.papyrus.infra.properties.environments");
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            String environmentResource = e.getAttribute("environmentModel");
            URI uri = URI.createURI((String)("ppe:/environment/" + e.getContributor().getName() + "/" + environmentResource));
            try {
                environmentAcceptor.accept(uri);
                ConstraintsManager.instance.addEnvironment(uri);
            }
            catch (IOException ex) {
                InfraPropertiesPlugin.LOG.error("The plugin " + e.getContributor() + " contributed an invalid " + "extension for " + "org.eclipse.papyrus.infra.properties.environments", (Throwable)ex);
            }
            ++n2;
        }
    }

    @FunctionalInterface
    public static interface ModelConsumer {
        public void accept(URI var1) throws IOException;
    }
}

