/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers;

import org.apache.commons.lang.StringUtils;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jubula.client.ui.handlers.AbstractHandler;
import org.eclipse.jubula.client.ui.rcp.businessprocess.JBNavigationHistory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NavigateHandler
extends AbstractHandler {
    public static final String NAVPARAM_ID = "org.eclipse.jubula.client.ui.rcp.commands.navigation.Navigate.parameter.NavigateItem";
    public static final String JUMP = "jumpTo:";
    public static final String EDITED = "Edited,";
    private static final Logger LOG = LoggerFactory.getLogger(NavigateHandler.class);

    protected Object executeImpl(ExecutionEvent event) {
        String par = event.getParameter(NAVPARAM_ID);
        if (par == null) {
            par = StringUtils.endsWith((String)event.getCommand().getId(), (String)"GoBack") ? "-1" : "1";
        }
        try {
            if (StringUtils.startsWith((String)par, (String)JUMP)) {
                int pos = Integer.parseInt(par.substring(JUMP.length()));
                JBNavigationHistory.getInstance().move(pos, true);
            } else if (par != null) {
                if (par.startsWith(EDITED)) {
                    int direction = Integer.parseInt(par.substring(EDITED.length()));
                    JBNavigationHistory.getInstance().editedMove(direction);
                } else {
                    int direction = Integer.parseInt(par);
                    JBNavigationHistory.getInstance().move(direction, false);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            LOG.error("Failed parsing " + par);
        }
        return null;
    }
}

