/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.resource.java.binary;

import org.eclipse.jpt.common.core.AnnotationProvider;
import org.eclipse.jpt.common.core.JptResourceModelListener;
import org.eclipse.jpt.common.core.JptResourceType;
import org.eclipse.jpt.common.core.internal.resource.java.binary.BinaryModel;
import org.eclipse.jpt.common.core.internal.utility.ContentTypeTools;
import org.eclipse.jpt.common.core.resource.java.JavaResourceModel;
import org.eclipse.jpt.common.core.resource.java.JavaResourcePackageFragmentRoot;
import org.eclipse.jpt.common.utility.internal.ListenerList;
import org.eclipse.jpt.common.utility.internal.model.ModelTools;

abstract class RootBinaryModel
extends BinaryModel
implements JavaResourceModel.Root {
    private final AnnotationProvider annotationProvider;
    private final ListenerList<JptResourceModelListener> resourceModelListenerList = ModelTools.listenerList();

    RootBinaryModel(JavaResourceModel parent, AnnotationProvider annotationProvider) {
        super(parent);
        this.annotationProvider = annotationProvider;
    }

    @Override
    protected boolean requiresParent() {
        return false;
    }

    @Override
    public JavaResourceModel.Root getRoot() {
        return this;
    }

    @Override
    public AnnotationProvider getAnnotationProvider() {
        return this.annotationProvider;
    }

    @Override
    public void resourceModelChanged() {
        for (JptResourceModelListener listener : this.resourceModelListenerList) {
            listener.resourceModelChanged(this);
        }
    }

    @Override
    public JptResourceType getResourceType() {
        return ContentTypeTools.getResourceType(JavaResourcePackageFragmentRoot.JAR_CONTENT_TYPE);
    }

    @Override
    public void addResourceModelListener(JptResourceModelListener listener) {
        this.resourceModelListenerList.add((Object)listener);
    }

    @Override
    public void removeResourceModelListener(JptResourceModelListener listener) {
        this.resourceModelListenerList.remove((Object)listener);
    }
}

