/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diagram.internal.factories;

import com.google.common.base.Predicate;
import java.util.List;
import org.eclipse.emf.compare.AttributeChange;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.ResourceAttachmentChange;
import org.eclipse.emf.compare.diagram.internal.extensions.DiagramDiff;
import org.eclipse.emf.compare.internal.postprocessor.factories.AbstractChangeFactory;
import org.eclipse.emf.compare.internal.utils.ComparisonUtil;
import org.eclipse.emf.compare.util.CompareSwitch;
import org.eclipse.emf.compare.utils.MatchUtil;
import org.eclipse.emf.compare.utils.ReferenceUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;

public abstract class AbstractDiagramChangeFactory
extends AbstractChangeFactory {
    public Diff create(Diff input) {
        Diff ret = super.create(input);
        if (ret instanceof DiagramDiff) {
            this.setView((DiagramDiff)ret, input);
            ((DiagramDiff)ret).setSemanticDiff(this.getSemanticDiff(input));
        }
        return ret;
    }

    public EObject setView(DiagramDiff extension, Diff refiningDiff) {
        CompareSwitch<EObject> getterValue = new CompareSwitch<EObject>(){

            public EObject caseReferenceChange(ReferenceChange object) {
                return object.getValue();
            }

            public EObject caseAttributeChange(AttributeChange object) {
                Comparison comparison = object.getMatch().getComparison();
                EObject view = MatchUtil.getContainer((Comparison)comparison, (Diff)object);
                while (view != null && !(view instanceof View)) {
                    view = view.eContainer();
                }
                return view;
            }

            public EObject caseResourceAttachmentChange(ResourceAttachmentChange object) {
                Comparison comparison = object.getMatch().getComparison();
                return MatchUtil.getContainer((Comparison)comparison, (Diff)object);
            }
        };
        EObject view = (EObject)getterValue.doSwitch((EObject)refiningDiff);
        extension.setView(view);
        return view;
    }

    public Match getParentMatch(Diff input) {
        return AbstractDiagramChangeFactory.getParentMatch(ComparisonUtil.getComparison((Diff)input), input);
    }

    public static Match getParentMatch(Comparison comparison, Diff input) {
        if (input.getKind() == DifferenceKind.CHANGE) {
            return comparison.getMatch((EObject)AbstractDiagramChangeFactory.getViewContainer(input));
        }
        return input.getMatch();
    }

    private static View getViewContainer(Diff input) {
        Match match = input.getMatch();
        return AbstractDiagramChangeFactory.getViewContainer(match);
    }

    private static View getViewContainer(Match match) {
        EObject result = match.getLeft();
        if (result == null) {
            result = match.getRight();
        }
        if (!(result instanceof View && result.eIsSet((EStructuralFeature)NotationPackage.Literals.VIEW__ELEMENT) || !(match.eContainer() instanceof Match))) {
            result = AbstractDiagramChangeFactory.getViewContainer((Match)match.eContainer());
        }
        return (View)result;
    }

    private Diff getSemanticDiff(Diff input) {
        List diffs;
        View view;
        Object element;
        if (input instanceof ReferenceChange && ((ReferenceChange)input).getValue() instanceof View && (element = ReferenceUtil.safeEGet((EObject)(view = (View)((ReferenceChange)input).getValue()), (EStructuralFeature)NotationPackage.Literals.VIEW__ELEMENT)) instanceof EObject && (diffs = this.findCrossReferences(ComparisonUtil.getComparison((Diff)input), (EObject)element, (Predicate)new Predicate<Diff>(){

            public boolean apply(Diff diff) {
                return diff instanceof ReferenceChange && ((ReferenceChange)diff).getReference().isContainment();
            }
        })).size() > 0) {
            return (Diff)diffs.get(0);
        }
        return null;
    }
}

